/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.ui.adapter;

import android.content.Context;
import android.content.Intent;
import android.graphics.PointF;
import android.net.Uri;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.core.content.FileProvider;
import androidx.recyclerview.widget.RecyclerView;
import com.davemorrissey.labs.subscaleview.ImageSource;
import com.davemorrissey.labs.subscaleview.SubsamplingScaleImageView;
import com.huantansheng.easyphotos.R;
import com.huantansheng.easyphotos.models.album.entity.Photo;
import com.huantansheng.easyphotos.setting.Setting;
import java.io.File;
import java.util.ArrayList;

public class PreviewPhotosAdapter
extends RecyclerView.Adapter<PreviewPhotosViewHolder> {
    private ArrayList<Photo> photos;
    private OnClickListener listener;
    private LayoutInflater inflater;

    public PreviewPhotosAdapter(Context cxt, ArrayList<Photo> photos, OnClickListener listener) {
        this.photos = photos;
        this.inflater = LayoutInflater.from((Context)cxt);
        this.listener = listener;
    }

    @NonNull
    public PreviewPhotosViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new PreviewPhotosViewHolder(this.inflater.inflate(R.layout.item_preview_photo_easy_photos, parent, false));
    }

    public void onBindViewHolder(@NonNull PreviewPhotosViewHolder holder, int position) {
        final String path = this.photos.get((int)position).path;
        final String type = this.photos.get((int)position).type;
        holder.ivPlay.setVisibility(8);
        holder.ivGifPhoto.setVisibility(8);
        holder.ivLongPhoto.setVisibility(8);
        if (type.contains("video")) {
            holder.ivLongPhoto.setVisibility(0);
            holder.ivLongPhoto.setImage(ImageSource.uri((String)path));
            holder.ivPlay.setVisibility(0);
            holder.ivPlay.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PreviewPhotosAdapter.this.toPlayVideo(v, path, type);
                }
            });
        } else if (path.endsWith("gif") || type.endsWith("gif")) {
            holder.ivGifPhoto.setVisibility(0);
            Setting.imageEngine.loadGif(holder.ivGifPhoto.getContext(), path, holder.ivGifPhoto);
        } else {
            holder.ivLongPhoto.setVisibility(0);
            holder.ivLongPhoto.setImage(ImageSource.uri((String)path));
        }
        holder.ivLongPhoto.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PreviewPhotosAdapter.this.listener.onPhotoClick();
            }
        });
        holder.ivGifPhoto.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PreviewPhotosAdapter.this.listener.onPhotoClick();
            }
        });
        holder.ivLongPhoto.setOnStateChangedListener(new SubsamplingScaleImageView.OnStateChangedListener(){

            public void onScaleChanged(float newScale, int origin) {
                PreviewPhotosAdapter.this.listener.onPhotoScaleChanged();
            }

            public void onCenterChanged(PointF newCenter, int origin) {
            }
        });
    }

    private void toPlayVideo(View v, String path, String type) {
        Context context = v.getContext();
        Intent intent = new Intent("android.intent.action.VIEW");
        Uri uri = this.getUri(context, path, intent);
        intent.setDataAndType(uri, type);
        context.startActivity(intent);
    }

    private Uri getUri(Context context, String path, Intent intent) {
        File file = new File(path);
        if (Build.VERSION.SDK_INT >= 24) {
            intent.addFlags(1);
            intent.addFlags(2);
            return FileProvider.getUriForFile((Context)context, (String)Setting.fileProviderAuthority, (File)file);
        }
        return Uri.fromFile((File)file);
    }

    public int getItemCount() {
        return this.photos.size();
    }

    public class PreviewPhotosViewHolder
    extends RecyclerView.ViewHolder {
        public SubsamplingScaleImageView ivLongPhoto;
        ImageView ivPlay;
        ImageView ivGifPhoto;

        PreviewPhotosViewHolder(View itemView) {
            super(itemView);
            this.ivLongPhoto = (SubsamplingScaleImageView)itemView.findViewById(R.id.iv_long_photo);
            this.ivGifPhoto = (ImageView)itemView.findViewById(R.id.iv_gif_photo);
            this.ivPlay = (ImageView)itemView.findViewById(R.id.iv_play);
        }
    }

    public static interface OnClickListener {
        public void onPhotoClick();

        public void onPhotoScaleChanged();
    }
}

