/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.utils.permission;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.content.PermissionChecker;
import java.util.ArrayList;
import java.util.List;

public class PermissionUtil {
    public static boolean checkAndRequestPermissionsInActivity(Activity cxt, String ... checkPermissions) {
        boolean isHas = true;
        ArrayList<String> permissions = new ArrayList<String>();
        for (String checkPermission : checkPermissions) {
            if (PermissionChecker.checkSelfPermission((Context)cxt, (String)checkPermission) == 0) continue;
            isHas = false;
            permissions.add(checkPermission);
        }
        if (!isHas) {
            String[] p = permissions.toArray(new String[permissions.size()]);
            PermissionUtil.requestPermissionsInActivity(cxt, 12, p);
        }
        return isHas;
    }

    private static void requestPermissionsInActivity(Activity cxt, int requestCode, String ... permissions) {
        ActivityCompat.requestPermissions((Activity)cxt, (String[])permissions, (int)requestCode);
    }

    public static void onPermissionResult(Activity cxt, @NonNull String[] permissions, @NonNull int[] grantResults, PermissionCallBack listener) {
        int length = grantResults.length;
        ArrayList<Integer> positions = new ArrayList<Integer>();
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                if (grantResults[i] == 0) continue;
                positions.add(i);
            }
        }
        if (positions.size() == 0) {
            listener.onSuccess();
            return;
        }
        PermissionUtil.progressNoPermission(cxt, listener, permissions, positions, 0);
    }

    private static void progressNoPermission(Activity cxt, PermissionCallBack listener, String[] permissions, List<Integer> positions, int i) {
        int index = positions.get(i);
        if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)cxt, (String)permissions[index])) {
            listener.onShouldShow();
            return;
        }
        if (i < positions.size() - 1) {
            PermissionUtil.progressNoPermission(cxt, listener, permissions, positions, ++i);
            return;
        }
        listener.onFailed();
    }

    public static interface PermissionCallBack {
        public void onSuccess();

        public void onShouldShow();

        public void onFailed();
    }
}

