/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.models.sticker.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.RectF;
import android.graphics.Region;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.huantansheng.easyphotos.R;
import com.huantansheng.easyphotos.models.sticker.cache.StickerCache;
import com.huantansheng.easyphotos.models.sticker.listener.OnStickerClickListener;

public class BitmapSticker
extends View {
    public boolean isChecked = false;
    private Bitmap image;
    private Bitmap mirrorImage;
    private Bitmap srcImage;
    private boolean mirror = true;
    private int imageWidth;
    private int imageHeight;
    private Bitmap btDelete;
    private Bitmap btScale;
    private Bitmap btMirror;
    private int btSize;
    private Matrix mMatrix;
    private float[] srcPs;
    private float[] dstPs;
    private Paint mPaint;
    private Paint framePaint;
    private boolean isUsing = true;
    private float downX1;
    private float downY1;
    private float downX2;
    private float downY2;
    private ClickType clickType;
    private boolean isOut = false;
    private GestureDetector gestureDetector;
    private float lastDegree;
    private float lastDoubleDegress;
    private OnStickerClickListener listener;
    private int startX;
    private int startY;
    private Path path;
    private String cacheKey;

    public BitmapSticker(Context context, String bitmapPath, int bitmapResourceId, int ViewGroupCenterX, int ViewGroupCenterY) {
        super(context);
        if (TextUtils.isEmpty((CharSequence)bitmapPath)) {
            this.image = StickerCache.get().getSrcBitmap(this.getResources(), bitmapResourceId);
            this.cacheKey = String.valueOf(bitmapResourceId);
        } else {
            this.image = StickerCache.get().getSrcBitmap(bitmapPath);
            this.cacheKey = bitmapPath;
        }
        this.path = new Path();
        this.srcImage = this.image;
        this.mirrorImage = StickerCache.get().getMirrorBitmap(this.cacheKey);
        this.imageWidth = this.image.getWidth();
        this.imageHeight = this.image.getHeight();
        this.startX = ViewGroupCenterX - this.imageWidth / 2;
        if (this.startX < 100) {
            this.startX = ViewGroupCenterX / 2;
        }
        this.startY = ViewGroupCenterY - this.imageHeight / 2;
        if (this.startY < 100) {
            this.startY = ViewGroupCenterY / 2;
        }
        this.initButtons();
        this.initPs();
        this.initPaints();
        this.initMatrix();
        this.initCanvasPosition();
        this.lastDegree = this.computeDegree(new Point(this.imageWidth, this.imageHeight), new Point(this.imageWidth / 2, this.imageHeight / 2));
        this.lastDoubleDegress = 1000.0f;
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new StickerGestureListener());
    }

    public void setOnStickerClickListener(OnStickerClickListener listener) {
        this.listener = listener;
    }

    private void initCanvasPosition() {
        this.mMatrix.postTranslate((float)this.startX, (float)this.startY);
        this.mMatrix.mapPoints(this.dstPs, this.srcPs);
    }

    private void initMatrix() {
        this.mMatrix = new Matrix();
    }

    private void initPaints() {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mPaint.setFilterBitmap(true);
        this.framePaint = new Paint();
        this.framePaint.setAntiAlias(true);
        this.framePaint.setStrokeWidth(1.0f);
        this.framePaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)17170443));
    }

    private void initPs() {
        this.srcPs = new float[]{0.0f, 0.0f, this.imageWidth, 0.0f, this.imageWidth, this.imageHeight, 0.0f, this.imageHeight, this.imageWidth / 2, this.imageHeight / 2};
        this.dstPs = (float[])this.srcPs.clone();
    }

    private void initButtons() {
        this.btDelete = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.mipmap.ic_delete_easy_photos);
        this.btMirror = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.mipmap.ic_mirror_easy_photos);
        this.btScale = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.mipmap.ic_controller_easy_photos);
        this.btSize = this.btDelete.getWidth();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawBitmap(this.image, this.mMatrix, this.mPaint);
        if (this.isUsing) {
            this.drawOthers(canvas);
        }
    }

    private void drawOthers(Canvas canvas) {
        this.path.reset();
        this.path.moveTo(this.dstPs[0], this.dstPs[1]);
        this.path.lineTo(this.dstPs[2], this.dstPs[3]);
        this.path.lineTo(this.dstPs[4], this.dstPs[5]);
        this.path.lineTo(this.dstPs[6], this.dstPs[7]);
        this.path.lineTo(this.dstPs[0], this.dstPs[1]);
        for (int i = 0; i < 7; i += 2) {
            if (i == 6) {
                canvas.drawLine(this.dstPs[i], this.dstPs[i + 1], this.dstPs[0], this.dstPs[1], this.framePaint);
                break;
            }
            canvas.drawLine(this.dstPs[i], this.dstPs[i + 1], this.dstPs[i + 2], this.dstPs[i + 3], this.framePaint);
        }
        canvas.drawBitmap(this.btDelete, this.dstPs[2] - (float)(this.btSize / 2), this.dstPs[3] - (float)(this.btSize / 2), this.mPaint);
        canvas.drawBitmap(this.btMirror, this.dstPs[0] - (float)(this.btSize / 2), this.dstPs[1] - (float)(this.btSize / 2), this.mPaint);
        canvas.drawBitmap(this.btScale, this.dstPs[4] - (float)(this.btSize / 2), this.dstPs[5] - (float)(this.btSize / 2), this.mPaint);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.gestureDetector.onTouchEvent(event);
        if (1 == event.getAction() || 6 == event.getAction() || 6 == event.getAction() || 262 == event.getAction()) {
            this.setDoubleDownPoints(0.0f, 0.0f, 0.0f, 0.0f);
            this.lastDoubleDegress = 1000.0f;
            this.lastDegree = this.computeDegree(new Point((int)this.dstPs[4], (int)this.dstPs[5]), new Point((int)this.dstPs[8], (int)this.dstPs[9]));
        }
        return !this.isOut;
    }

    private void setDoubleDownPoints(float x1, float y1, float x2, float y2) {
        this.downX1 = x1;
        this.downY1 = y1;
        this.downX2 = x2;
        this.downY2 = y2;
    }

    private void calculateClickType(int x, int y) {
        RectF rectF = new RectF((float)(x - this.btSize / 2 - 40), (float)(y - this.btSize / 2 - 40), (float)(x + this.btSize / 2 + 40), (float)(y + this.btSize / 2 + 40));
        if (rectF.contains(this.dstPs[2] - 20.0f, this.dstPs[3])) {
            this.clickType = ClickType.DELETE;
        } else if (rectF.contains(this.dstPs[0], this.dstPs[1])) {
            this.clickType = ClickType.MIRROR;
        } else if (rectF.contains(this.dstPs[4] + 20.0f, this.dstPs[5])) {
            this.clickType = ClickType.SCALE;
        } else if (rectF.contains(this.dstPs[6] - 20.0f, this.dstPs[7])) {
            this.clickType = ClickType.IMAGE;
        } else {
            RectF bounds = new RectF();
            this.path.computeBounds(bounds, true);
            Region region = new Region();
            region.setPath(this.path, new Region((int)bounds.left, (int)bounds.top, (int)bounds.right, (int)bounds.bottom));
            if (region.contains(x, y)) {
                if (this.isOut) {
                    this.isOut = false;
                }
                if (!this.isUsing) {
                    this.isUsing = true;
                    this.listener.onUsing();
                    this.postInvalidate();
                }
                this.clickType = ClickType.IMAGE;
            } else {
                if (this.isUsing) {
                    this.isUsing = false;
                    this.postInvalidate();
                }
                if (!this.isOut) {
                    this.isOut = true;
                }
                this.clickType = ClickType.OUT;
            }
        }
    }

    public void delete() {
        if (null == this.listener) {
            throw new NullPointerException("OnStickerClickListener listener is null");
        }
        this.setVisibility(8);
        StickerCache.get().recycle(this.cacheKey);
        this.listener.onDelete();
    }

    private void mirror() {
        this.image = this.mirror ? this.mirrorImage : this.srcImage;
        this.mirror = !this.mirror;
        this.matrixMap();
    }

    private void top() {
        this.bringToFront();
        this.invalidate();
        this.listener.onTop();
    }

    private void move(float distansX, float distansY) {
        this.mMatrix.postTranslate(distansX, distansY);
        this.matrixMap();
    }

    private void controller(MotionEvent event) {
        this.scale(event);
        this.rotate(event);
    }

    private void scale(MotionEvent event) {
        float moveY1;
        float moveX1;
        float moveY2;
        float moveX2;
        float originalY1;
        float originalX1;
        float originalY2;
        float originalX2;
        if (event.getPointerCount() == 2) {
            originalX2 = this.downX2;
            originalY2 = this.downY2;
            originalX1 = this.downX1;
            originalY1 = this.downY1;
            moveX2 = event.getX(1);
            moveY2 = event.getY(1);
            moveX1 = event.getX(0);
            moveY1 = event.getY(0);
        } else {
            originalX2 = this.dstPs[4];
            originalY2 = this.dstPs[5];
            originalX1 = this.dstPs[0];
            originalY1 = this.dstPs[1];
            moveX2 = event.getX();
            moveY2 = event.getY();
            moveX1 = originalX1;
            moveY1 = originalY1;
        }
        float temp1 = this.getDistanceOfTwoPoints(originalX2, originalY2, originalX1, originalY1);
        float temp2 = this.getDistanceOfTwoPoints(moveX2, moveY2, moveX1, moveY1);
        float scalValue = temp2 / temp1;
        if (this.getScaleValue() < 0.3f && scalValue < 1.0f) {
            return;
        }
        this.mMatrix.postScale(scalValue, scalValue, this.dstPs[8], this.dstPs[9]);
        this.matrixMap();
        if (event.getPointerCount() == 2) {
            this.setDoubleDownPoints(moveX1, moveY1, moveX2, moveY2);
        }
    }

    private void rotate(MotionEvent event) {
        if (event.getPointerCount() == 2) {
            float preDegree = this.computeDegree(new Point((int)event.getX(0), (int)event.getY(0)), new Point((int)event.getX(1), (int)event.getY(1)));
            if (this.lastDoubleDegress == 1000.0f) {
                this.lastDoubleDegress = preDegree;
            }
            this.mMatrix.postRotate(preDegree - this.lastDoubleDegress, this.dstPs[8], this.dstPs[9]);
            this.matrixMap();
            this.lastDoubleDegress = preDegree;
        } else {
            float preDegree = this.computeDegree(new Point((int)event.getX(), (int)event.getY()), new Point((int)this.dstPs[8], (int)this.dstPs[9]));
            this.mMatrix.postRotate(preDegree - this.lastDegree, this.dstPs[8], this.dstPs[9]);
            this.matrixMap();
            this.lastDegree = preDegree;
        }
    }

    public float getScaleValue() {
        float preDistance = (this.srcPs[8] - this.srcPs[0]) * (this.srcPs[8] - this.srcPs[0]) + (this.srcPs[9] - this.srcPs[1]) * (this.srcPs[9] - this.srcPs[1]);
        float lastDistance = (this.dstPs[8] - this.dstPs[0]) * (this.dstPs[8] - this.dstPs[0]) + (this.dstPs[9] - this.dstPs[1]) * (this.dstPs[9] - this.dstPs[1]);
        float scaleValue = (float)Math.sqrt(lastDistance / preDistance);
        return scaleValue;
    }

    private void matrixMap() {
        this.mMatrix.mapPoints(this.dstPs, this.srcPs);
        this.postInvalidate();
    }

    public void setUsing(boolean isUsing) {
        this.isUsing = isUsing;
        this.postInvalidate();
    }

    public boolean isUsing() {
        return this.isUsing;
    }

    private float getDistanceOfTwoPoints(float x1, float y1, float x2, float y2) {
        return (float)Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    public float computeDegree(Point p1, Point p2) {
        float tran_x = p1.x - p2.x;
        float tran_y = p1.y - p2.y;
        float degree = 0.0f;
        float angle = (float)(Math.asin((double)tran_x / Math.sqrt(tran_x * tran_x + tran_y * tran_y)) * 180.0 / Math.PI);
        if (!Float.isNaN(angle)) {
            if (tran_x >= 0.0f && tran_y <= 0.0f) {
                degree = angle;
            } else if (tran_x <= 0.0f && tran_y <= 0.0f) {
                degree = angle;
            } else if (tran_x <= 0.0f && tran_y >= 0.0f) {
                degree = -180.0f - angle;
            } else if (tran_x >= 0.0f && tran_y >= 0.0f) {
                degree = 180.0f - angle;
            }
        }
        return degree;
    }

    private class StickerGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private StickerGestureListener() {
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            switch (BitmapSticker.this.clickType) {
                case DELETE: {
                    BitmapSticker.this.delete();
                    break;
                }
                case MIRROR: {
                    BitmapSticker.this.mirror();
                    break;
                }
                case SCALE: {
                    break;
                }
                case ROTATE: {
                    break;
                }
                case IMAGE: {
                    break;
                }
            }
            return true;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            switch (BitmapSticker.this.clickType) {
                case DELETE: {
                    break;
                }
                case MIRROR: {
                    break;
                }
                case SCALE: {
                    if (e2.getPointerCount() > 1) break;
                    BitmapSticker.this.controller(e2);
                    break;
                }
                case ROTATE: {
                    break;
                }
                case IMAGE: {
                    if (e2.getPointerCount() == 2) {
                        if (BitmapSticker.this.downX1 + BitmapSticker.this.downY1 + BitmapSticker.this.downX2 + BitmapSticker.this.downY2 == 0.0f) {
                            BitmapSticker.this.setDoubleDownPoints(e2.getX(0), e2.getY(0), e2.getX(1), e2.getY(1));
                        }
                        BitmapSticker.this.controller(e2);
                        break;
                    }
                    if (e2.getPointerCount() != 1) break;
                    BitmapSticker.this.move(-distanceX, -distanceY);
                    break;
                }
            }
            return true;
        }

        public boolean onDown(MotionEvent e) {
            BitmapSticker.this.isChecked = true;
            BitmapSticker.this.calculateClickType((int)e.getX(), (int)e.getY());
            if (BitmapSticker.this.clickType == ClickType.IMAGE) {
                BitmapSticker.this.top();
            }
            return true;
        }
    }

    private static enum ClickType {
        DELETE,
        MIRROR,
        SCALE,
        ROTATE,
        IMAGE,
        OUT;

    }
}

