/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.Builder;

import android.app.Activity;
import android.app.Fragment;
import android.support.annotation.NonNull;
import android.view.View;
import com.huantansheng.easyphotos.engine.ImageEngine;
import com.huantansheng.easyphotos.models.ad.AdListener;
import com.huantansheng.easyphotos.models.album.entity.Photo;
import com.huantansheng.easyphotos.result.Result;
import com.huantansheng.easyphotos.setting.Setting;
import com.huantansheng.easyphotos.ui.EasyPhotosActivity;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class AlbumBuilder {
    private static AlbumBuilder instance;
    private WeakReference<Activity> mActivity;
    private WeakReference<android.support.v4.app.Fragment> mFragmentV;
    private WeakReference<Fragment> mFragment;
    private StartupType startupType;
    private WeakReference<AdListener> adListener;

    private AlbumBuilder(Activity activity, StartupType startupType) {
        this.mActivity = new WeakReference<Activity>(activity);
        this.startupType = startupType;
    }

    private AlbumBuilder(android.support.v4.app.Fragment fragment, StartupType startupType) {
        this.mFragmentV = new WeakReference<android.support.v4.app.Fragment>(fragment);
        this.startupType = startupType;
    }

    private AlbumBuilder(Fragment fragment, StartupType startupType) {
        this.mFragment = new WeakReference<Fragment>(fragment);
        this.startupType = startupType;
    }

    private static AlbumBuilder with(Activity activity, StartupType startupType) {
        AlbumBuilder.clear();
        instance = new AlbumBuilder(activity, startupType);
        return instance;
    }

    private static AlbumBuilder with(Fragment fragment, StartupType startupType) {
        AlbumBuilder.clear();
        instance = new AlbumBuilder(fragment, startupType);
        return instance;
    }

    private static AlbumBuilder with(android.support.v4.app.Fragment fragmentV, StartupType startupType) {
        AlbumBuilder.clear();
        instance = new AlbumBuilder(fragmentV, startupType);
        return instance;
    }

    public static AlbumBuilder createCamera(Activity activity) {
        return AlbumBuilder.with(activity, StartupType.CAMERA);
    }

    public static AlbumBuilder createCamera(Fragment fragment) {
        return AlbumBuilder.with(fragment, StartupType.CAMERA);
    }

    public static AlbumBuilder createCamera(android.support.v4.app.Fragment fragmentV) {
        return AlbumBuilder.with(fragmentV, StartupType.CAMERA);
    }

    public static AlbumBuilder createAlbum(Activity activity, boolean isShowCamera, @NonNull ImageEngine imageEngine) {
        if (Setting.imageEngine != imageEngine) {
            Setting.imageEngine = imageEngine;
        }
        if (isShowCamera) {
            return AlbumBuilder.with(activity, StartupType.ALBUM_CAMERA);
        }
        return AlbumBuilder.with(activity, StartupType.ALBUM);
    }

    public static AlbumBuilder createAlbum(Fragment fragment, boolean isShowCamera, @NonNull ImageEngine imageEngine) {
        if (Setting.imageEngine != imageEngine) {
            Setting.imageEngine = imageEngine;
        }
        if (isShowCamera) {
            return AlbumBuilder.with(fragment, StartupType.ALBUM_CAMERA);
        }
        return AlbumBuilder.with(fragment, StartupType.ALBUM);
    }

    public static AlbumBuilder createAlbum(android.support.v4.app.Fragment fragmentV, boolean isShowCamera, @NonNull ImageEngine imageEngine) {
        if (Setting.imageEngine != imageEngine) {
            Setting.imageEngine = imageEngine;
        }
        if (isShowCamera) {
            return AlbumBuilder.with(fragmentV, StartupType.ALBUM_CAMERA);
        }
        return AlbumBuilder.with(fragmentV, StartupType.ALBUM);
    }

    public AlbumBuilder setFileProviderAuthority(String fileProviderAuthority) {
        Setting.fileProviderAuthority = fileProviderAuthority;
        return this;
    }

    public AlbumBuilder setCount(int selectorMaxCount) {
        Setting.count = selectorMaxCount;
        return this;
    }

    public AlbumBuilder setMinFileSize(long minFileSize) {
        Setting.minSize = minFileSize;
        return this;
    }

    public AlbumBuilder setMinWidth(int minWidth) {
        Setting.minWidth = minWidth;
        return this;
    }

    public AlbumBuilder setMinHeight(int minHeight) {
        Setting.minHeight = minHeight;
        return this;
    }

    public AlbumBuilder setSelectedPhotos(ArrayList<Photo> selectedPhotos) {
        Setting.selectedPhotos.clear();
        if (selectedPhotos.isEmpty()) {
            return this;
        }
        Setting.selectedPhotos.addAll(selectedPhotos);
        Setting.selectedOriginal = selectedPhotos.get((int)0).selectedOriginal;
        return this;
    }

    public AlbumBuilder setSelectedPhotoPaths(ArrayList<String> selectedPhotoPaths) {
        Setting.selectedPhotos.clear();
        ArrayList<Photo> selectedPhotos = new ArrayList<Photo>();
        for (String path : selectedPhotoPaths) {
            Photo photo = new Photo(null, path, 0L, 0, 0, 0L, null);
            selectedPhotos.add(photo);
        }
        Setting.selectedPhotos.addAll(selectedPhotos);
        return this;
    }

    public AlbumBuilder setOriginalMenu(boolean isChecked, boolean usable, String unusableHint) {
        Setting.showOriginalMenu = true;
        Setting.selectedOriginal = isChecked;
        Setting.originalMenuUsable = usable;
        Setting.originalMenuUnusableHint = unusableHint;
        return this;
    }

    public AlbumBuilder setPuzzleMenu(boolean shouldShow) {
        Setting.showPuzzleMenu = shouldShow;
        return this;
    }

    public AlbumBuilder setGif(boolean shouldShow) {
        Setting.showGif = shouldShow;
        return this;
    }

    public AlbumBuilder setVideo(boolean shouldShow) {
        Setting.showVideo = shouldShow;
        return this;
    }

    public AlbumBuilder setCleanMenu(boolean shouldShow) {
        Setting.showCleanMenu = shouldShow;
        return this;
    }

    public void start(int requestCode) {
        switch (this.startupType) {
            case CAMERA: {
                Setting.onlyStartCamera = true;
                Setting.isShowCamera = true;
                break;
            }
            case ALBUM: {
                Setting.isShowCamera = false;
                break;
            }
            case ALBUM_CAMERA: {
                Setting.isShowCamera = true;
            }
        }
        this.launchEasyPhotosActivity(requestCode);
    }

    private void launchEasyPhotosActivity(int requestCode) {
        if (null != this.mActivity && null != this.mActivity.get()) {
            EasyPhotosActivity.start((Activity)this.mActivity.get(), requestCode);
            return;
        }
        if (null != this.mFragment && null != this.mFragment.get()) {
            EasyPhotosActivity.start((Fragment)this.mFragment.get(), requestCode);
            return;
        }
        if (null != this.mFragmentV && null != this.mFragmentV.get()) {
            EasyPhotosActivity.start((android.support.v4.app.Fragment)this.mFragmentV.get(), requestCode);
        }
    }

    private static void clear() {
        Result.clear();
        Setting.clear();
        instance = null;
    }

    public AlbumBuilder setAdView(View photosAdView, boolean photosAdIsLoaded, View albumItemsAdView, boolean albumItemsAdIsLoaded) {
        Setting.photosAdView = new WeakReference<View>(photosAdView);
        Setting.albumItemsAdView = new WeakReference<View>(albumItemsAdView);
        Setting.photoAdIsOk = photosAdIsLoaded;
        Setting.albumItemsAdIsOk = albumItemsAdIsLoaded;
        return this;
    }

    public static void setAdListener(AdListener adListener) {
        if (null == instance) {
            return;
        }
        if (AlbumBuilder.instance.startupType == StartupType.CAMERA) {
            return;
        }
        AlbumBuilder.instance.adListener = new WeakReference<AdListener>(adListener);
    }

    public static void notifyPhotosAdLoaded() {
        if (Setting.photoAdIsOk) {
            return;
        }
        if (null == instance) {
            return;
        }
        if (AlbumBuilder.instance.startupType == StartupType.CAMERA) {
            return;
        }
        if (null == AlbumBuilder.instance.adListener) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (null != instance && null != instance.adListener) {
                        Setting.photoAdIsOk = true;
                        ((AdListener)instance.adListener.get()).onPhotosAdLoaded();
                    }
                }
            }).start();
            return;
        }
        Setting.photoAdIsOk = true;
        ((AdListener)AlbumBuilder.instance.adListener.get()).onPhotosAdLoaded();
    }

    public static void notifyAlbumItemsAdLoaded() {
        if (Setting.albumItemsAdIsOk) {
            return;
        }
        if (null == instance) {
            return;
        }
        if (AlbumBuilder.instance.startupType == StartupType.CAMERA) {
            return;
        }
        if (null == AlbumBuilder.instance.adListener) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (null != instance && null != instance.adListener) {
                        Setting.albumItemsAdIsOk = true;
                        ((AdListener)instance.adListener.get()).onAlbumItemsAdLoaded();
                    }
                }
            }).start();
            return;
        }
        Setting.albumItemsAdIsOk = true;
        ((AdListener)AlbumBuilder.instance.adListener.get()).onAlbumItemsAdLoaded();
    }

    private static enum StartupType {
        CAMERA,
        ALBUM,
        ALBUM_CAMERA;

    }
}

