/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.graphics.BitmapFactory;
import android.hardware.Camera;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.FileProvider;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SimpleItemAnimator;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.huantansheng.easyphotos.EasyPhotos;
import com.huantansheng.easyphotos.R;
import com.huantansheng.easyphotos.models.ad.AdListener;
import com.huantansheng.easyphotos.models.album.AlbumModel;
import com.huantansheng.easyphotos.models.album.entity.Photo;
import com.huantansheng.easyphotos.result.Result;
import com.huantansheng.easyphotos.setting.Setting;
import com.huantansheng.easyphotos.ui.PreviewActivity;
import com.huantansheng.easyphotos.ui.PuzzleSelectorActivity;
import com.huantansheng.easyphotos.ui.adapter.AlbumItemsAdapter;
import com.huantansheng.easyphotos.ui.adapter.PhotosAdapter;
import com.huantansheng.easyphotos.ui.widget.PressedTextView;
import com.huantansheng.easyphotos.utils.Color.ColorUtils;
import com.huantansheng.easyphotos.utils.String.StringUtils;
import com.huantansheng.easyphotos.utils.media.MediaScannerConnectionUtils;
import com.huantansheng.easyphotos.utils.permission.PermissionUtil;
import com.huantansheng.easyphotos.utils.settings.SettingsUtils;
import com.huantansheng.easyphotos.utils.system.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class EasyPhotosActivity
extends AppCompatActivity
implements AlbumItemsAdapter.OnClickListener,
PhotosAdapter.OnClickListener,
AdListener,
View.OnClickListener {
    private File mTempImageFile;
    private AlbumModel albumModel;
    private ArrayList<Object> photoList = new ArrayList();
    private ArrayList<Object> albumItemList = new ArrayList();
    private ArrayList<Photo> resultList = new ArrayList();
    private RecyclerView rvPhotos;
    private PhotosAdapter photosAdapter;
    private GridLayoutManager gridLayoutManager;
    private RecyclerView rvAlbumItems;
    private AlbumItemsAdapter albumItemsAdapter;
    private RelativeLayout rootViewAlbumItems;
    private PressedTextView tvAlbumItems;
    private PressedTextView tvDone;
    private PressedTextView tvPreview;
    private TextView tvOriginal;
    private AnimatorSet setHide;
    private AnimatorSet setShow;
    private int currAlbumItemIndex = 0;
    private ImageView ivCamera;
    private LinearLayout mSecondMenus;
    private RelativeLayout permissionView;
    private TextView tvPermission;
    private View mBottomBar;

    public static void start(Activity activity, int requestCode) {
        Intent intent = new Intent((Context)activity, EasyPhotosActivity.class);
        activity.startActivityForResult(intent, requestCode);
    }

    public static void start(Fragment fragment, int requestCode) {
        Intent intent = new Intent((Context)fragment.getActivity(), EasyPhotosActivity.class);
        fragment.startActivityForResult(intent, requestCode);
    }

    public static void start(android.support.v4.app.Fragment fragment, int requestCode) {
        Intent intent = new Intent(fragment.getContext(), EasyPhotosActivity.class);
        fragment.startActivityForResult(intent, requestCode);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_easy_photos);
        this.hideActionBar();
        this.adaptationStatusBar();
        if (!Setting.onlyStartCamera && null == Setting.imageEngine) {
            this.finish();
            return;
        }
        this.initSomeViews();
        if (PermissionUtil.checkAndRequestPermissionsInActivity((Activity)this, this.getNeedPermissions())) {
            this.hasPermissions();
        }
    }

    private void adaptationStatusBar() {
        if (Build.VERSION.SDK_INT >= 23) {
            int statusColor = this.getWindow().getStatusBarColor();
            if (statusColor == 0) {
                statusColor = ContextCompat.getColor((Context)this, (int)R.color.colorPrimaryDark);
            }
            if (ColorUtils.isWhiteColor(statusColor)) {
                SystemUtils.getInstance().setStatusDark((Activity)this, true);
            }
        }
    }

    private void initSomeViews() {
        this.mBottomBar = this.findViewById(R.id.m_bottom_bar);
        this.permissionView = (RelativeLayout)this.findViewById(R.id.rl_permissions_view);
        this.tvPermission = (TextView)this.findViewById(R.id.tv_permission);
        this.rootViewAlbumItems = (RelativeLayout)this.findViewById(R.id.root_view_album_items);
        this.setClick(R.id.iv_back);
    }

    private void hasPermissions() {
        if (Setting.onlyStartCamera) {
            this.launchCamera(11);
            return;
        }
        this.permissionView.setVisibility(8);
        AlbumModel.CallBack albumModelCallBack = new AlbumModel.CallBack(){

            @Override
            public void onAlbumWorkedCallBack() {
                EasyPhotosActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        EasyPhotosActivity.this.onAlbumWorkedDo();
                    }
                });
            }
        };
        this.albumModel = AlbumModel.getInstance();
        this.albumModel.query((Context)this, albumModelCallBack);
    }

    protected String[] getNeedPermissions() {
        if (Setting.isShowCamera) {
            if (Build.VERSION.SDK_INT >= 16) {
                return new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
            }
            return new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"};
        }
        if (Build.VERSION.SDK_INT >= 16) {
            return new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
        }
        return new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        PermissionUtil.onPermissionResult((Activity)this, permissions, grantResults, new PermissionUtil.PermissionCallBack(){

            @Override
            public void onSuccess() {
                EasyPhotosActivity.this.hasPermissions();
            }

            @Override
            public void onShouldShow() {
                EasyPhotosActivity.this.tvPermission.setText(R.string.permissions_again_easy_photos);
                EasyPhotosActivity.this.permissionView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (PermissionUtil.checkAndRequestPermissionsInActivity((Activity)EasyPhotosActivity.this, EasyPhotosActivity.this.getNeedPermissions())) {
                            EasyPhotosActivity.this.hasPermissions();
                        }
                    }
                });
            }

            @Override
            public void onFailed() {
                EasyPhotosActivity.this.tvPermission.setText(R.string.permissions_die_easy_photos);
                EasyPhotosActivity.this.permissionView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        SettingsUtils.startMyApplicationDetailsForResult((Activity)EasyPhotosActivity.this, EasyPhotosActivity.this.getPackageName());
                    }
                });
            }
        });
    }

    private void launchCamera(int requestCode) {
        if (TextUtils.isEmpty((CharSequence)Setting.fileProviderAuthority)) {
            throw new RuntimeException("AlbumBuilder : \u8bf7\u6267\u884c setFileProviderAuthority()\u65b9\u6cd5");
        }
        if (!this.cameraIsCanUse()) {
            this.permissionView.setVisibility(0);
            this.tvPermission.setText(R.string.permissions_die_easy_photos);
            this.permissionView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    SettingsUtils.startMyApplicationDetailsForResult((Activity)EasyPhotosActivity.this, EasyPhotosActivity.this.getPackageName());
                }
            });
            return;
        }
        this.toAndroidCamera(requestCode);
    }

    private void toAndroidCamera(int requestCode) {
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (cameraIntent.resolveActivity(this.getPackageManager()) != null) {
            this.createCameraTempImageFile();
            if (this.mTempImageFile != null && this.mTempImageFile.exists()) {
                Uri imageUri = null;
                imageUri = Build.VERSION.SDK_INT >= 24 ? FileProvider.getUriForFile((Context)this, (String)Setting.fileProviderAuthority, (File)this.mTempImageFile) : Uri.fromFile((File)this.mTempImageFile);
                cameraIntent.addFlags(1);
                cameraIntent.putExtra("output", (Parcelable)imageUri);
                this.startActivityForResult(cameraIntent, requestCode);
            } else {
                Toast.makeText((Context)this, (int)R.string.camera_temp_file_error_easy_photos, (int)0).show();
            }
        } else {
            Toast.makeText((Context)this, (int)R.string.msg_no_camera_easy_photos, (int)0).show();
        }
    }

    private void createCameraTempImageFile() {
        String cacheDirPath;
        File dir = new File(Environment.getExternalStorageDirectory(), File.separator + "DCIM" + File.separator + "Camera" + File.separator);
        if (!(dir.exists() && dir.isDirectory() || dir.mkdirs() || null != (dir = this.getExternalFilesDir(null)) && dir.exists() || null != (dir = this.getFilesDir()) && dir.exists() || (dir = new File(cacheDirPath = File.separator + "data" + File.separator + "data" + File.separator + this.getPackageName() + File.separator + "cache" + File.separator)).exists())) {
            dir.mkdirs();
        }
        try {
            this.mTempImageFile = File.createTempFile("IMG", ".jpg", dir);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.mTempImageFile = null;
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 14) {
            if (PermissionUtil.checkAndRequestPermissionsInActivity((Activity)this, this.getNeedPermissions())) {
                this.hasPermissions();
            }
            return;
        }
        switch (resultCode) {
            case -1: {
                if (11 == requestCode) {
                    if (this.mTempImageFile == null || !this.mTempImageFile.exists()) {
                        throw new RuntimeException("EasyPhotos\u62cd\u7167\u4fdd\u5b58\u7684\u56fe\u7247\u4e0d\u5b58\u5728");
                    }
                    this.onCameraResult();
                    return;
                }
                if (13 == requestCode) {
                    if (data.getBooleanExtra("keyOfPreviewClickDone", false)) {
                        this.done();
                        return;
                    }
                    this.photosAdapter.change();
                    this.processOriginalMenu();
                    this.shouldShowMenuDone();
                    return;
                }
                if (16 != requestCode) break;
                Photo puzzlePhoto = (Photo)data.getParcelableExtra("keyOfEasyPhotosResult");
                this.addNewPhoto(puzzlePhoto);
                return;
            }
            case 0: {
                if (11 == requestCode) {
                    while (this.mTempImageFile != null && this.mTempImageFile.exists()) {
                        boolean success = this.mTempImageFile.delete();
                        if (!success) continue;
                        this.mTempImageFile = null;
                    }
                    if (Setting.onlyStartCamera) {
                        this.finish();
                    }
                    return;
                }
                if (13 != requestCode) break;
                this.processOriginalMenu();
                return;
            }
        }
    }

    private void addNewPhoto(Photo photo) {
        MediaScannerConnectionUtils.refresh((Context)this, photo.path);
        photo.selectedOriginal = Setting.selectedOriginal;
        String albumItem_all_name = this.getString(R.string.selector_folder_all_easy_photos);
        this.albumModel.album.getAlbumItem(albumItem_all_name).addImageItem(0, photo);
        String folderPath = new File(photo.path).getParentFile().getAbsolutePath();
        String albumName = StringUtils.getLastPathSegment(folderPath);
        this.albumModel.album.addAlbumItem(albumName, folderPath, photo.path);
        this.albumModel.album.getAlbumItem(albumName).addImageItem(0, photo);
        this.albumItemList.clear();
        this.albumItemList.addAll(this.albumModel.getAlbumItems());
        if (Setting.hasAlbumItemsAd()) {
            int albumItemsAdIndex = 2;
            if (this.albumItemList.size() < albumItemsAdIndex + 1) {
                albumItemsAdIndex = this.albumItemList.size() - 1;
            }
            this.albumItemList.add(albumItemsAdIndex, Setting.albumItemsAdView);
        }
        this.albumItemsAdapter.notifyDataSetChanged();
        if (Setting.count == 1) {
            Result.clear();
            Result.addPhoto(photo);
        } else if (Result.count() >= Setting.count) {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.selector_reach_max_image_hint_easy_photos, new Object[]{Setting.count}), (int)0).show();
        } else {
            Result.addPhoto(photo);
        }
        this.rvAlbumItems.scrollToPosition(0);
        this.albumItemsAdapter.setSelectedPosition(0);
        this.shouldShowMenuDone();
    }

    private void onCameraResult() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HH:mm:ss", Locale.getDefault());
        String imageName = "IMG_%s.jpg";
        String filename = String.format(imageName, dateFormat.format(new Date()));
        File reNameFile = new File(this.mTempImageFile.getParentFile(), filename);
        if (!reNameFile.exists() && this.mTempImageFile.renameTo(reNameFile)) {
            this.mTempImageFile = reNameFile;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)this.mTempImageFile.getAbsolutePath(), (BitmapFactory.Options)options);
        if (Setting.onlyStartCamera || this.albumModel.getAlbumItems().isEmpty()) {
            MediaScannerConnectionUtils.refresh((Context)this, this.mTempImageFile);
            Intent data = new Intent();
            Photo photo = new Photo(this.mTempImageFile.getName(), this.mTempImageFile.getAbsolutePath(), this.mTempImageFile.lastModified() / 1000L, options.outWidth, options.outHeight, this.mTempImageFile.length(), options.outMimeType);
            photo.selectedOriginal = Setting.selectedOriginal;
            this.resultList.add(photo);
            data.putParcelableArrayListExtra("keyOfEasyPhotosResult", this.resultList);
            data.putExtra("keyOfEasyPhotosResultSelectedOriginal", Setting.selectedOriginal);
            ArrayList<String> pathList = new ArrayList<String>();
            pathList.add(photo.path);
            data.putStringArrayListExtra("keyOfEasyPhotosResultPaths", pathList);
            this.setResult(-1, data);
            this.finish();
            return;
        }
        Photo photo = new Photo(this.mTempImageFile.getName(), this.mTempImageFile.getAbsolutePath(), this.mTempImageFile.lastModified() / 1000L, options.outWidth, options.outHeight, this.mTempImageFile.length(), options.outMimeType);
        this.addNewPhoto(photo);
    }

    private void onAlbumWorkedDo() {
        this.initView();
    }

    private void initView() {
        if (this.albumModel.getAlbumItems().isEmpty()) {
            Toast.makeText((Context)this, (int)R.string.no_photos_easy_photos, (int)1).show();
            if (Setting.isShowCamera) {
                this.launchCamera(11);
            } else {
                this.finish();
            }
            return;
        }
        EasyPhotos.setAdListener(this);
        if (Setting.hasPhotosAd()) {
            this.findViewById(R.id.m_tool_bar_bottom_line).setVisibility(8);
        }
        this.ivCamera = (ImageView)this.findViewById(R.id.fab_camera);
        if (Setting.isShowCamera) {
            this.ivCamera.setVisibility(0);
        }
        if (!Setting.showPuzzleMenu) {
            this.findViewById(R.id.tv_puzzle).setVisibility(8);
        }
        this.mSecondMenus = (LinearLayout)this.findViewById(R.id.m_second_level_menu);
        int columns = this.getResources().getInteger(R.integer.photos_columns_easy_photos);
        this.tvAlbumItems = (PressedTextView)this.findViewById(R.id.tv_album_items);
        this.tvAlbumItems.setText(this.albumModel.getAlbumItems().get((int)0).name);
        this.tvDone = (PressedTextView)this.findViewById(R.id.tv_done);
        this.rvPhotos = (RecyclerView)this.findViewById(R.id.rv_photos);
        ((SimpleItemAnimator)this.rvPhotos.getItemAnimator()).setSupportsChangeAnimations(false);
        this.photoList.clear();
        this.photoList.addAll(this.albumModel.getCurrAlbumItemPhotos(0));
        if (Setting.hasPhotosAd()) {
            this.photoList.add(0, Setting.photosAdView);
        }
        this.photosAdapter = new PhotosAdapter((Context)this, this.photoList, this);
        this.gridLayoutManager = new GridLayoutManager((Context)this, columns);
        if (Setting.hasPhotosAd()) {
            this.gridLayoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    if (position == 0) {
                        return EasyPhotosActivity.this.gridLayoutManager.getSpanCount();
                    }
                    return 1;
                }
            });
        }
        this.rvPhotos.setLayoutManager((RecyclerView.LayoutManager)this.gridLayoutManager);
        this.rvPhotos.setAdapter((RecyclerView.Adapter)this.photosAdapter);
        this.tvOriginal = (TextView)this.findViewById(R.id.tv_original);
        if (Setting.showOriginalMenu) {
            this.processOriginalMenu();
        } else {
            this.tvOriginal.setVisibility(8);
        }
        this.tvPreview = (PressedTextView)this.findViewById(R.id.tv_preview);
        this.initAlbumItems();
        this.shouldShowMenuDone();
        this.setClick(R.id.iv_album_items, R.id.tv_clear, R.id.iv_second_menu, R.id.tv_puzzle);
        this.setClick(new View[]{this.tvAlbumItems, this.rootViewAlbumItems, this.tvDone, this.tvOriginal, this.tvPreview, this.ivCamera});
    }

    private void hideActionBar() {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.hide();
        }
    }

    private void initAlbumItems() {
        this.rvAlbumItems = (RecyclerView)this.findViewById(R.id.rv_album_items);
        this.albumItemList.clear();
        this.albumItemList.addAll(this.albumModel.getAlbumItems());
        if (Setting.hasAlbumItemsAd()) {
            int albumItemsAdIndex = 2;
            if (this.albumItemList.size() < albumItemsAdIndex + 1) {
                albumItemsAdIndex = this.albumItemList.size() - 1;
            }
            this.albumItemList.add(albumItemsAdIndex, Setting.albumItemsAdView);
        }
        this.albumItemsAdapter = new AlbumItemsAdapter((Context)this, this.albumItemList, 0, this);
        this.rvAlbumItems.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.rvAlbumItems.setAdapter((RecyclerView.Adapter)this.albumItemsAdapter);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (R.id.tv_album_items == id2 || R.id.iv_album_items == id2) {
            this.showAlbumItems(8 == this.rootViewAlbumItems.getVisibility());
        } else if (R.id.root_view_album_items == id2) {
            this.showAlbumItems(false);
        } else if (R.id.iv_back == id2) {
            this.setResult(0);
            this.finish();
        } else if (R.id.tv_done == id2) {
            this.done();
        } else if (R.id.tv_clear == id2) {
            if (Result.isEmpty()) {
                this.processSecondMenu();
                return;
            }
            Result.removeAll();
            this.photosAdapter.change();
            this.shouldShowMenuDone();
            this.processSecondMenu();
        } else if (R.id.tv_original == id2) {
            if (!Setting.originalMenuUsable) {
                Toast.makeText((Context)this, (CharSequence)Setting.originalMenuUnusableHint, (int)0).show();
                return;
            }
            Setting.selectedOriginal = !Setting.selectedOriginal;
            this.processOriginalMenu();
            this.processSecondMenu();
        } else if (R.id.tv_preview == id2) {
            PreviewActivity.start((Activity)this, -1, 0);
        } else if (R.id.fab_camera == id2) {
            this.launchCamera(11);
        } else if (R.id.iv_second_menu == id2) {
            this.processSecondMenu();
        } else if (R.id.tv_puzzle == id2) {
            this.processSecondMenu();
            PuzzleSelectorActivity.start((Activity)this);
        }
    }

    public void processSecondMenu() {
        if (this.mSecondMenus == null) {
            return;
        }
        if (0 == this.mSecondMenus.getVisibility()) {
            this.mSecondMenus.setVisibility(4);
            if (Setting.isShowCamera) {
                this.ivCamera.setVisibility(0);
            }
        } else {
            this.mSecondMenus.setVisibility(0);
            if (Setting.isShowCamera) {
                this.ivCamera.setVisibility(4);
            }
        }
    }

    private void done() {
        Intent intent = new Intent();
        Result.processOriginal();
        this.resultList.addAll(Result.photos);
        intent.putParcelableArrayListExtra("keyOfEasyPhotosResult", this.resultList);
        ArrayList<String> resultPaths = new ArrayList<String>();
        for (Photo photo : this.resultList) {
            resultPaths.add(photo.path);
        }
        intent.putStringArrayListExtra("keyOfEasyPhotosResultPaths", resultPaths);
        intent.putExtra("keyOfEasyPhotosResultSelectedOriginal", Setting.selectedOriginal);
        this.setResult(-1, intent);
        this.finish();
    }

    private void processOriginalMenu() {
        if (!Setting.showOriginalMenu) {
            return;
        }
        if (Setting.selectedOriginal) {
            this.tvOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.easy_photos_fg_accent));
        } else if (Setting.originalMenuUsable) {
            this.tvOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.easy_photos_fg_primary));
        } else {
            this.tvOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.easy_photos_fg_primary_dark));
        }
    }

    private void showAlbumItems(boolean isShow) {
        if (null == this.setShow) {
            this.newAnimators();
        }
        if (isShow) {
            this.rootViewAlbumItems.setVisibility(0);
            this.setShow.start();
        } else {
            this.setHide.start();
        }
    }

    private void newAnimators() {
        this.newHideAnim();
        this.newShowAnim();
    }

    private void newShowAnim() {
        ObjectAnimator translationShow = ObjectAnimator.ofFloat((Object)this.rvAlbumItems, (String)"translationY", (float[])new float[]{this.mBottomBar.getTop(), 0.0f});
        ObjectAnimator alphaShow = ObjectAnimator.ofFloat((Object)this.rootViewAlbumItems, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        translationShow.setDuration(300L);
        this.setShow = new AnimatorSet();
        this.setShow.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.setShow.play((Animator)translationShow).with((Animator)alphaShow);
    }

    private void newHideAnim() {
        ObjectAnimator translationHide = ObjectAnimator.ofFloat((Object)this.rvAlbumItems, (String)"translationY", (float[])new float[]{0.0f, this.mBottomBar.getTop()});
        ObjectAnimator alphaHide = ObjectAnimator.ofFloat((Object)this.rootViewAlbumItems, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        translationHide.setDuration(200L);
        this.setHide = new AnimatorSet();
        this.setHide.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                EasyPhotosActivity.this.rootViewAlbumItems.setVisibility(8);
            }
        });
        this.setHide.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        this.setHide.play((Animator)translationHide).with((Animator)alphaHide);
    }

    @Override
    public void onAlbumItemClick(int position, int realPosition) {
        this.updatePhotos(realPosition);
        this.showAlbumItems(false);
        this.tvAlbumItems.setText(this.albumModel.getAlbumItems().get((int)realPosition).name);
    }

    private void updatePhotos(int currAlbumItemIndex) {
        this.currAlbumItemIndex = currAlbumItemIndex;
        this.photoList.clear();
        this.photoList.addAll(this.albumModel.getCurrAlbumItemPhotos(currAlbumItemIndex));
        if (Setting.hasPhotosAd()) {
            this.photoList.add(0, Setting.photosAdView);
        }
        this.photosAdapter.change();
        this.rvPhotos.scrollToPosition(0);
    }

    private void shouldShowMenuDone() {
        if (Result.isEmpty()) {
            if (0 == this.tvDone.getVisibility()) {
                ScaleAnimation scaleHide = new ScaleAnimation(1.0f, 0.0f, 1.0f, 0.0f);
                scaleHide.setDuration(200L);
                this.tvDone.startAnimation((Animation)scaleHide);
            }
            this.tvDone.setVisibility(4);
            this.tvPreview.setVisibility(4);
        } else {
            if (4 == this.tvDone.getVisibility()) {
                ScaleAnimation scaleShow = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f);
                scaleShow.setDuration(200L);
                this.tvDone.startAnimation((Animation)scaleShow);
            }
            this.tvDone.setVisibility(0);
            this.tvPreview.setVisibility(0);
        }
        this.tvDone.setText(this.getString(R.string.selector_action_done_easy_photos, new Object[]{Result.count(), Setting.count}));
    }

    @Override
    public void onPhotoClick(int position, int realPosition) {
        PreviewActivity.start((Activity)this, this.currAlbumItemIndex, realPosition);
    }

    @Override
    public void onSelectorOutOfMax() {
        Toast.makeText((Context)this, (CharSequence)this.getString(R.string.selector_reach_max_image_hint_easy_photos, new Object[]{Setting.count}), (int)0).show();
    }

    @Override
    public void onSelectorChanged() {
        this.shouldShowMenuDone();
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    public void onBackPressed() {
        if (null != this.rootViewAlbumItems && this.rootViewAlbumItems.getVisibility() == 0) {
            this.showAlbumItems(false);
            return;
        }
        if (null != this.mSecondMenus && 0 == this.mSecondMenus.getVisibility()) {
            this.processSecondMenu();
            return;
        }
        super.onBackPressed();
    }

    @Override
    public void onPhotosAdLoaded() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                EasyPhotosActivity.this.photosAdapter.change();
            }
        });
    }

    @Override
    public void onAlbumItemsAdLoaded() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                EasyPhotosActivity.this.albumItemsAdapter.notifyDataSetChanged();
            }
        });
    }

    private void setClick(int ... ids) {
        for (int id2 : ids) {
            this.findViewById(id2).setOnClickListener((View.OnClickListener)this);
        }
    }

    private void setClick(View ... views) {
        for (View v : views) {
            v.setOnClickListener((View.OnClickListener)this);
        }
    }

    public boolean cameraIsCanUse() {
        boolean isCanUse = true;
        Camera mCamera = null;
        try {
            mCamera = Camera.open();
            Camera.Parameters mParameters = mCamera.getParameters();
            mCamera.setParameters(mParameters);
        }
        catch (Exception e) {
            isCanUse = false;
        }
        if (mCamera != null) {
            try {
                mCamera.release();
            }
            catch (Exception e) {
                e.printStackTrace();
                return isCanUse;
            }
        }
        return isCanUse;
    }
}

