/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.models.puzzle;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.huantansheng.easyphotos.models.puzzle.Area;
import com.huantansheng.easyphotos.models.puzzle.Line;
import com.huantansheng.easyphotos.models.puzzle.MatrixUtils;

public class PuzzlePiece {
    private static Xfermode SRC_IN = new PorterDuffXfermode(PorterDuff.Mode.SRC_IN);
    private Drawable drawable;
    private Matrix matrix;
    private Matrix previousMatrix;
    private Area area;
    private Rect drawableBounds;
    private float[] drawablePoints;
    private float[] mappedDrawablePoints;
    private float previousMoveX;
    private float previousMoveY;
    private final RectF mappedBounds;
    private final PointF centerPoint;
    private final PointF mappedCenterPoint;
    private ValueAnimator animator;
    private int duration = 300;
    private Matrix tempMatrix;

    PuzzlePiece(Drawable drawable2, Area area, Matrix matrix) {
        this.drawable = drawable2;
        this.area = area;
        this.matrix = matrix;
        this.previousMatrix = new Matrix();
        this.drawableBounds = new Rect(0, 0, this.getWidth(), this.getHeight());
        this.drawablePoints = new float[]{0.0f, 0.0f, this.getWidth(), 0.0f, this.getWidth(), this.getHeight(), 0.0f, this.getHeight()};
        this.mappedDrawablePoints = new float[8];
        this.mappedBounds = new RectF();
        this.centerPoint = new PointF(area.centerX(), area.centerY());
        this.mappedCenterPoint = new PointF();
        this.animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.tempMatrix = new Matrix();
    }

    void draw(Canvas canvas) {
        this.draw(canvas, 255, true);
    }

    void draw(Canvas canvas, int alpha) {
        this.draw(canvas, alpha, false);
    }

    private void draw(Canvas canvas, int alpha, boolean needClip) {
        if (this.drawable instanceof BitmapDrawable) {
            int saved = canvas.saveLayer(null, null, 31);
            Bitmap bitmap = ((BitmapDrawable)this.drawable).getBitmap();
            Paint paint = ((BitmapDrawable)this.drawable).getPaint();
            paint.setColor(-1);
            paint.setAlpha(alpha);
            if (needClip) {
                canvas.drawPath(this.area.getAreaPath(), paint);
                paint.setXfermode(SRC_IN);
            }
            canvas.drawBitmap(bitmap, this.matrix, paint);
            paint.setXfermode(null);
            canvas.restoreToCount(saved);
        } else {
            canvas.save();
            if (needClip) {
                canvas.clipPath(this.area.getAreaPath());
            }
            canvas.concat(this.matrix);
            this.drawable.setBounds(this.drawableBounds);
            this.drawable.setAlpha(alpha);
            this.drawable.draw(canvas);
            canvas.restore();
        }
    }

    public Area getArea() {
        return this.area;
    }

    public void setDrawable(Drawable drawable2) {
        this.drawable = drawable2;
        this.drawableBounds = new Rect(0, 0, this.getWidth(), this.getHeight());
        this.drawablePoints = new float[]{0.0f, 0.0f, this.getWidth(), 0.0f, this.getWidth(), this.getHeight(), 0.0f, this.getHeight()};
    }

    public Drawable getDrawable() {
        return this.drawable;
    }

    public int getWidth() {
        return this.drawable.getIntrinsicWidth();
    }

    public int getHeight() {
        return this.drawable.getIntrinsicHeight();
    }

    public boolean contains(float x, float y) {
        return this.area.contains(x, y);
    }

    public boolean contains(Line line) {
        return this.area.contains(line);
    }

    public Rect getDrawableBounds() {
        return this.drawableBounds;
    }

    void setPreviousMoveX(float previousMoveX) {
        this.previousMoveX = previousMoveX;
    }

    void setPreviousMoveY(float previousMoveY) {
        this.previousMoveY = previousMoveY;
    }

    private RectF getCurrentDrawableBounds() {
        this.matrix.mapRect(this.mappedBounds, new RectF(this.drawableBounds));
        return this.mappedBounds;
    }

    private PointF getCurrentDrawableCenterPoint() {
        this.getCurrentDrawableBounds();
        this.mappedCenterPoint.x = this.mappedBounds.centerX();
        this.mappedCenterPoint.y = this.mappedBounds.centerY();
        return this.mappedCenterPoint;
    }

    public PointF getAreaCenterPoint() {
        this.centerPoint.x = this.area.centerX();
        this.centerPoint.y = this.area.centerY();
        return this.centerPoint;
    }

    private float getMatrixScale() {
        return MatrixUtils.getMatrixScale(this.matrix);
    }

    float getMatrixAngle() {
        return MatrixUtils.getMatrixAngle(this.matrix);
    }

    float[] getCurrentDrawablePoints() {
        this.matrix.mapPoints(this.mappedDrawablePoints, this.drawablePoints);
        return this.mappedDrawablePoints;
    }

    boolean isFilledArea() {
        RectF bounds = this.getCurrentDrawableBounds();
        return !(bounds.left > this.area.left() || bounds.top > this.area.top() || bounds.right < this.area.right() || bounds.bottom < this.area.bottom());
    }

    boolean canFilledArea() {
        float minScale;
        float scale = MatrixUtils.getMatrixScale(this.matrix);
        return scale >= (minScale = MatrixUtils.getMinMatrixScale(this));
    }

    void record() {
        this.previousMatrix.set(this.matrix);
    }

    void translate(float offsetX, float offsetY) {
        this.matrix.set(this.previousMatrix);
        this.postTranslate(offsetX, offsetY);
    }

    private void zoom(float scaleX, float scaleY, PointF midPoint) {
        this.matrix.set(this.previousMatrix);
        this.postScale(scaleX, scaleY, midPoint);
    }

    void zoomAndTranslate(float scaleX, float scaleY, PointF midPoint, float offsetX, float offsetY) {
        this.matrix.set(this.previousMatrix);
        this.postTranslate(offsetX, offsetY);
        this.postScale(scaleX, scaleY, midPoint);
    }

    void set(Matrix matrix) {
        this.matrix.set(matrix);
        this.moveToFillArea(null);
    }

    void postTranslate(float x, float y) {
        this.matrix.postTranslate(x, y);
    }

    void postScale(float scaleX, float scaleY, PointF midPoint) {
        this.matrix.postScale(scaleX, scaleY, midPoint.x, midPoint.y);
    }

    void postFlipVertically() {
        this.matrix.postScale(1.0f, -1.0f, this.area.centerX(), this.area.centerY());
    }

    void postFlipHorizontally() {
        this.matrix.postScale(-1.0f, 1.0f, this.area.centerX(), this.area.centerY());
    }

    void postRotate(float degree) {
        this.matrix.postRotate(degree, this.area.centerX(), this.area.centerY());
        float minScale = MatrixUtils.getMinMatrixScale(this);
        if (this.getMatrixScale() < minScale) {
            PointF midPoint = new PointF();
            midPoint.set(this.getCurrentDrawableCenterPoint());
            this.postScale(minScale / this.getMatrixScale(), minScale / this.getMatrixScale(), midPoint);
        }
        if (!MatrixUtils.judgeIsImageContainsBorder(this, this.getMatrixAngle())) {
            float[] imageIndents = MatrixUtils.calculateImageIndents(this);
            float deltaX = -(imageIndents[0] + imageIndents[2]);
            float deltaY = -(imageIndents[1] + imageIndents[3]);
            this.postTranslate(deltaX, deltaY);
        }
    }

    private void animateTranslate(final View view, final float translateX, final float translateY) {
        this.animator.end();
        this.animator.removeAllUpdateListeners();
        this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float x = translateX * ((Float)animation.getAnimatedValue()).floatValue();
                float y = translateY * ((Float)animation.getAnimatedValue()).floatValue();
                PuzzlePiece.this.translate(x, y);
                view.invalidate();
            }
        });
        this.animator.setDuration((long)this.duration);
        this.animator.start();
    }

    void moveToFillArea(View view) {
        if (this.isFilledArea()) {
            return;
        }
        this.record();
        RectF rectF = this.getCurrentDrawableBounds();
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        if (rectF.left > this.area.left()) {
            offsetX = this.area.left() - rectF.left;
        }
        if (rectF.top > this.area.top()) {
            offsetY = this.area.top() - rectF.top;
        }
        if (rectF.right < this.area.right()) {
            offsetX = this.area.right() - rectF.right;
        }
        if (rectF.bottom < this.area.bottom()) {
            offsetY = this.area.bottom() - rectF.bottom;
        }
        if (view == null) {
            this.postTranslate(offsetX, offsetY);
        } else {
            this.animateTranslate(view, offsetX, offsetY);
        }
    }

    void fillArea(final View view, boolean quick) {
        if (this.isFilledArea()) {
            return;
        }
        this.record();
        final float startScale = this.getMatrixScale();
        final float endScale = MatrixUtils.getMinMatrixScale(this);
        final PointF midPoint = new PointF();
        midPoint.set(this.getCurrentDrawableCenterPoint());
        this.tempMatrix.set(this.matrix);
        this.tempMatrix.postScale(endScale / startScale, endScale / startScale, midPoint.x, midPoint.y);
        RectF rectF = new RectF(this.drawableBounds);
        this.tempMatrix.mapRect(rectF);
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        if (rectF.left > this.area.left()) {
            offsetX = this.area.left() - rectF.left;
        }
        if (rectF.top > this.area.top()) {
            offsetY = this.area.top() - rectF.top;
        }
        if (rectF.right < this.area.right()) {
            offsetX = this.area.right() - rectF.right;
        }
        if (rectF.bottom < this.area.bottom()) {
            offsetY = this.area.bottom() - rectF.bottom;
        }
        final float translateX = offsetX;
        final float translateY = offsetY;
        this.animator.end();
        this.animator.removeAllUpdateListeners();
        this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                float scale = (startScale + (endScale - startScale) * value) / startScale;
                float x = translateX * value;
                float y = translateY * value;
                PuzzlePiece.this.zoom(scale, scale, midPoint);
                PuzzlePiece.this.postTranslate(x, y);
                view.invalidate();
            }
        });
        if (quick) {
            this.animator.setDuration(0L);
        } else {
            this.animator.setDuration((long)this.duration);
        }
        this.animator.start();
    }

    void updateWith(MotionEvent event, Line line) {
        float offsetX = (event.getX() - this.previousMoveX) / 2.0f;
        float offsetY = (event.getY() - this.previousMoveY) / 2.0f;
        if (!this.canFilledArea()) {
            Area area = this.getArea();
            float deltaScale = MatrixUtils.getMinMatrixScale(this) / this.getMatrixScale();
            this.postScale(deltaScale, deltaScale, area.getCenterPoint());
            this.record();
            this.previousMoveX = event.getX();
            this.previousMoveY = event.getY();
        }
        if (line.direction() == Line.Direction.HORIZONTAL) {
            this.translate(0.0f, offsetY);
        } else if (line.direction() == Line.Direction.VERTICAL) {
            this.translate(offsetX, 0.0f);
        }
        RectF rectF = this.getCurrentDrawableBounds();
        Area area = this.getArea();
        float moveY = 0.0f;
        if (rectF.top > area.top()) {
            moveY = area.top() - rectF.top;
        }
        if (rectF.bottom < area.bottom()) {
            moveY = area.bottom() - rectF.bottom;
        }
        float moveX = 0.0f;
        if (rectF.left > area.left()) {
            moveX = area.left() - rectF.left;
        }
        if (rectF.right < area.right()) {
            moveX = area.right() - rectF.right;
        }
        if (moveX != 0.0f || moveY != 0.0f) {
            this.previousMoveX = event.getX();
            this.previousMoveY = event.getY();
            this.postTranslate(moveX, moveY);
            this.record();
        }
    }

    public void setArea(Area area) {
        this.area = area;
    }

    boolean isAnimateRunning() {
        return this.animator.isRunning();
    }

    void setAnimateDuration(int duration) {
        this.duration = duration;
    }
}

