/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.ui.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.huantansheng.easyphotos.R;
import com.huantansheng.easyphotos.models.album.entity.Photo;
import com.huantansheng.easyphotos.setting.Setting;
import java.util.ArrayList;

public class PuzzleSelectorAdapter
extends RecyclerView.Adapter {
    private ArrayList<Photo> dataList;
    private LayoutInflater mInflater;
    private OnClickListener listener;

    public PuzzleSelectorAdapter(Context cxt, ArrayList<Photo> dataList, OnClickListener listener) {
        this.dataList = dataList;
        this.listener = listener;
        this.mInflater = LayoutInflater.from((Context)cxt);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new PhotoViewHolder(this.mInflater.inflate(R.layout.item_puzzle_selector_easy_photos, parent, false));
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        final int p = position;
        Photo photo = this.dataList.get(position);
        String path = photo.path;
        String type = photo.type;
        if (Setting.showGif) {
            if (path.endsWith(".gif") || type.endsWith(".gif")) {
                Setting.imageEngine.loadGifAsBitmap(((PhotoViewHolder)holder).ivPhoto.getContext(), path, ((PhotoViewHolder)holder).ivPhoto);
                ((PhotoViewHolder)holder).tvGif.setVisibility(0);
            } else {
                Setting.imageEngine.loadPhoto(((PhotoViewHolder)holder).ivPhoto.getContext(), path, ((PhotoViewHolder)holder).ivPhoto);
                ((PhotoViewHolder)holder).tvGif.setVisibility(8);
            }
        } else {
            Setting.imageEngine.loadPhoto(((PhotoViewHolder)holder).ivPhoto.getContext(), path, ((PhotoViewHolder)holder).ivPhoto);
            ((PhotoViewHolder)holder).tvGif.setVisibility(8);
        }
        ((PhotoViewHolder)holder).ivPhoto.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PuzzleSelectorAdapter.this.listener.onPhotoClick(p);
            }
        });
    }

    public int getItemCount() {
        return null == this.dataList ? 0 : this.dataList.size();
    }

    public class PhotoViewHolder
    extends RecyclerView.ViewHolder {
        ImageView ivPhoto;
        TextView tvGif;

        public PhotoViewHolder(View itemView) {
            super(itemView);
            this.ivPhoto = (ImageView)itemView.findViewById(R.id.iv_photo);
            this.tvGif = (TextView)itemView.findViewById(R.id.tv_gif);
        }
    }

    public static interface OnClickListener {
        public void onPhotoClick(int var1);
    }
}

