/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.result;

import android.graphics.BitmapFactory;
import android.os.Build;
import com.huantansheng.easyphotos.models.album.entity.Photo;
import com.huantansheng.easyphotos.setting.Setting;
import java.util.ArrayList;

public class Result {
    public static ArrayList<Photo> photos = new ArrayList();

    public static void addPhoto(Photo photo) {
        photo.selected = true;
        photos.add(photo);
    }

    public static void removePhoto(Photo photo) {
        photo.selected = false;
        photos.remove(photo);
    }

    public static void removePhoto(int photoIndex) {
        Result.removePhoto(photos.get(photoIndex));
    }

    public static void removeAll() {
        int size = photos.size();
        for (int i = 0; i < size; ++i) {
            Result.removePhoto(0);
        }
    }

    public static void processOriginal() {
        boolean isIceApi;
        boolean bl = isIceApi = Build.VERSION.SDK_INT == 15;
        if (Setting.showOriginalMenu && Setting.originalMenuUsable) {
            for (Photo photo : photos) {
                photo.selectedOriginal = Setting.selectedOriginal;
                if (!isIceApi || photo.width != 0) continue;
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeFile((String)photo.path, (BitmapFactory.Options)options);
                photo.width = options.outWidth;
                photo.height = options.outHeight;
            }
        }
    }

    public static void clear() {
        photos.clear();
    }

    public static boolean isEmpty() {
        return photos.isEmpty();
    }

    public static int count() {
        return photos.size();
    }

    public static String getSelectorNumber(Photo photo) {
        return String.valueOf(photos.indexOf(photo) + 1);
    }

    public static String getPhotoPath(int position) {
        return Result.photos.get((int)position).path;
    }

    public static String getPhotoType(int position) {
        return Result.photos.get((int)position).type;
    }
}

