/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.ui.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.RequestOptions;
import com.huantansheng.easyphotos.R;
import com.huantansheng.easyphotos.models.album.entity.Photo;
import com.huantansheng.easyphotos.setting.Setting;
import java.util.ArrayList;

public class PuzzleSelectorPreviewAdapter
extends RecyclerView.Adapter {
    ArrayList<Photo> dataList;
    RequestManager mGlide;
    LayoutInflater mInflater;
    OnClickListener listener;

    public PuzzleSelectorPreviewAdapter(Context cxt, ArrayList<Photo> dataList, OnClickListener listener) {
        this.dataList = dataList;
        this.listener = listener;
        this.mInflater = LayoutInflater.from((Context)cxt);
        this.mGlide = Glide.with((Context)cxt);
        RequestOptions options = new RequestOptions().centerCrop();
        this.mGlide.applyDefaultRequestOptions(options);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new PhotoViewHolder(this.mInflater.inflate(R.layout.item_puzzle_selector_preview_easy_photos, parent, false));
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        final int p = position;
        Photo photo = this.dataList.get(position);
        String path = photo.path;
        String type = photo.type;
        if (Setting.showGif) {
            if (path.endsWith(".gif") || type.endsWith(".gif")) {
                this.mGlide.asBitmap().load(path).into(((PhotoViewHolder)holder).ivPhoto);
                ((PhotoViewHolder)holder).tvGif.setVisibility(0);
            } else {
                this.mGlide.load(path).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).into(((PhotoViewHolder)holder).ivPhoto);
                ((PhotoViewHolder)holder).tvGif.setVisibility(8);
            }
        } else {
            this.mGlide.load(path).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).into(((PhotoViewHolder)holder).ivPhoto);
            ((PhotoViewHolder)holder).tvGif.setVisibility(8);
        }
        ((PhotoViewHolder)holder).ivDelete.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PuzzleSelectorPreviewAdapter.this.listener.onDeleteClick(p);
            }
        });
    }

    public int getItemCount() {
        return null == this.dataList ? 0 : this.dataList.size();
    }

    public class PhotoViewHolder
    extends RecyclerView.ViewHolder {
        ImageView ivPhoto;
        ImageView ivDelete;
        TextView tvGif;

        public PhotoViewHolder(View itemView) {
            super(itemView);
            this.ivPhoto = (ImageView)itemView.findViewById(R.id.iv_photo);
            this.ivDelete = (ImageView)itemView.findViewById(R.id.iv_delete);
            this.tvGif = (TextView)itemView.findViewById(R.id.tv_gif);
        }
    }

    public static interface OnClickListener {
        public void onDeleteClick(int var1);
    }
}

