/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.ui.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.RequestOptions;
import com.huantansheng.easyphotos.R;
import com.huantansheng.easyphotos.result.Result;
import com.huantansheng.easyphotos.setting.Setting;
import com.huantansheng.easyphotos.ui.widget.PressedImageView;

public class PreviewPhotosFragmentAdapter
extends RecyclerView.Adapter<PreviewPhotoVH> {
    private LayoutInflater inflater;
    private RequestManager mGlide;
    private OnClickListener listener;
    private int checkedPosition = -1;

    public PreviewPhotosFragmentAdapter(Context context, OnClickListener listener) {
        this.inflater = LayoutInflater.from((Context)context);
        this.listener = listener;
        this.mGlide = Glide.with((Context)context);
        RequestOptions options = new RequestOptions().centerCrop();
        this.mGlide.applyDefaultRequestOptions(options);
    }

    public PreviewPhotoVH onCreateViewHolder(ViewGroup parent, int viewType) {
        return new PreviewPhotoVH(this.inflater.inflate(R.layout.item_preview_selected_photos_easy_photos, parent, false));
    }

    public void onBindViewHolder(PreviewPhotoVH holder, int position) {
        final int p = position;
        String path = Result.getPhotoPath(position);
        String type = Result.getPhotoType(position);
        if (Setting.showGif) {
            if (path.endsWith(".gif") || type.endsWith(".gif")) {
                this.mGlide.asBitmap().load(path).into((ImageView)holder.ivPhoto);
                holder.tvGif.setVisibility(0);
            } else {
                this.mGlide.load(path).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).into((ImageView)holder.ivPhoto);
                holder.tvGif.setVisibility(8);
            }
        } else {
            this.mGlide.load(path).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).into((ImageView)holder.ivPhoto);
            holder.tvGif.setVisibility(8);
        }
        if (this.checkedPosition == p) {
            holder.frame.setVisibility(0);
        } else {
            holder.frame.setVisibility(8);
        }
        holder.ivPhoto.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PreviewPhotosFragmentAdapter.this.listener.onPhotoClick(p);
            }
        });
    }

    public int getItemCount() {
        return Result.count();
    }

    public void setChecked(int position) {
        if (this.checkedPosition == position) {
            return;
        }
        this.checkedPosition = position;
        this.notifyDataSetChanged();
    }

    public static interface OnClickListener {
        public void onPhotoClick(int var1);
    }

    class PreviewPhotoVH
    extends RecyclerView.ViewHolder {
        PressedImageView ivPhoto;
        View frame;
        TextView tvGif;

        public PreviewPhotoVH(View itemView) {
            super(itemView);
            this.ivPhoto = (PressedImageView)itemView.findViewById(R.id.iv_photo);
            this.frame = itemView.findViewById(R.id.v_selector);
            this.tvGif = (TextView)itemView.findViewById(R.id.tv_gif);
        }
    }
}

