/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos.ui.adapter;

import android.content.Context;
import android.support.constraint.ConstraintLayout;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.RequestOptions;
import com.huantansheng.easyphotos.R;
import com.huantansheng.easyphotos.models.ad.AdViewHolder;
import com.huantansheng.easyphotos.models.album.entity.AlbumItem;
import com.huantansheng.easyphotos.setting.Setting;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class AlbumItemsAdapter
extends RecyclerView.Adapter {
    private static final int TYPE_AD = 0;
    private static final int TYPE_ALBUM_ITEMS = 1;
    ArrayList<Object> dataList;
    RequestManager mGlide;
    LayoutInflater mInflater;
    int selectedPosition;
    OnClickListener listener;
    int adPosition = 0;
    int padding = 0;

    public AlbumItemsAdapter(Context cxt, ArrayList<Object> list, int selectedPosition, OnClickListener listener) {
        this.dataList = list;
        this.mInflater = LayoutInflater.from((Context)cxt);
        this.listener = listener;
        this.mGlide = Glide.with((Context)cxt);
        this.selectedPosition = selectedPosition;
        RequestOptions options = new RequestOptions().centerCrop();
        this.mGlide.applyDefaultRequestOptions(options);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        switch (viewType) {
            case 0: {
                return new AdViewHolder(this.mInflater.inflate(R.layout.item_ad_easy_photos, parent, false));
            }
        }
        return new AlbumItemsViewHolder(this.mInflater.inflate(R.layout.item_dialog_album_items_easy_photos, parent, false));
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, final int position) {
        if (holder instanceof AlbumItemsViewHolder) {
            if (this.padding == 0) {
                this.padding = ((AlbumItemsViewHolder)holder).mRoot.getPaddingLeft();
            }
            if (position == this.getItemCount() - 1) {
                ((AlbumItemsViewHolder)holder).mRoot.setPadding(this.padding, this.padding, this.padding, this.padding);
            } else {
                ((AlbumItemsViewHolder)holder).mRoot.setPadding(this.padding, this.padding, this.padding, 0);
            }
            AlbumItem item = (AlbumItem)this.dataList.get(position);
            this.mGlide.load(item.coverImagePath).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).into(((AlbumItemsViewHolder)holder).ivAlbumCover);
            ((AlbumItemsViewHolder)holder).tvAlbumName.setText((CharSequence)item.name);
            ((AlbumItemsViewHolder)holder).tvAlbumPhotosCount.setText((CharSequence)String.valueOf(item.photos.size()));
            if (this.selectedPosition == position) {
                ((AlbumItemsViewHolder)holder).ivSelected.setVisibility(0);
            } else {
                ((AlbumItemsViewHolder)holder).ivSelected.setVisibility(4);
            }
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    int realPosition = position;
                    if (Setting.hasAlbumItemsAd() && position > AlbumItemsAdapter.this.adPosition) {
                        --realPosition;
                    }
                    int tempSelected = AlbumItemsAdapter.this.selectedPosition;
                    AlbumItemsAdapter.this.selectedPosition = position;
                    AlbumItemsAdapter.this.notifyItemChanged(tempSelected);
                    AlbumItemsAdapter.this.notifyItemChanged(position);
                    AlbumItemsAdapter.this.listener.onAlbumItemClick(position, realPosition);
                }
            });
            return;
        }
        if (holder instanceof AdViewHolder) {
            View adView;
            this.adPosition = position;
            if (!Setting.albumItemsAdIsOk) {
                ((AdViewHolder)holder).adFrame.setVisibility(8);
                return;
            }
            WeakReference weakReference = (WeakReference)this.dataList.get(position);
            if (null != weakReference && null != (adView = (View)weakReference.get())) {
                if (null != adView.getParent() && adView.getParent() instanceof FrameLayout) {
                    ((FrameLayout)adView.getParent()).removeAllViews();
                }
                ((AdViewHolder)holder).adFrame.setVisibility(0);
                ((AdViewHolder)holder).adFrame.removeAllViews();
                ((AdViewHolder)holder).adFrame.addView(adView);
            }
        }
    }

    public void setSelectedPosition(int position) {
        int realPosition = position;
        if (Setting.hasAlbumItemsAd() && position > this.adPosition) {
            --realPosition;
        }
        int tempSelected = this.selectedPosition;
        this.selectedPosition = position;
        this.notifyItemChanged(tempSelected);
        this.notifyItemChanged(position);
        this.listener.onAlbumItemClick(position, realPosition);
    }

    public int getItemCount() {
        return this.dataList.size();
    }

    public int getItemViewType(int position) {
        Object item = this.dataList.get(position);
        if (null == item || item instanceof WeakReference) {
            return 0;
        }
        return 1;
    }

    public class AlbumItemsViewHolder
    extends RecyclerView.ViewHolder {
        ImageView ivAlbumCover;
        TextView tvAlbumName;
        TextView tvAlbumPhotosCount;
        ImageView ivSelected;
        ConstraintLayout mRoot;

        public AlbumItemsViewHolder(View itemView) {
            super(itemView);
            this.ivAlbumCover = (ImageView)itemView.findViewById(R.id.iv_album_cover);
            this.tvAlbumName = (TextView)itemView.findViewById(R.id.tv_album_name);
            this.tvAlbumPhotosCount = (TextView)itemView.findViewById(R.id.tv_album_photos_count);
            this.ivSelected = (ImageView)itemView.findViewById(R.id.iv_selected);
            this.mRoot = (ConstraintLayout)itemView.findViewById(R.id.m_root_view);
        }
    }

    public static interface OnClickListener {
        public void onAlbumItemClick(int var1, int var2);
    }
}

