/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import android.view.View;
import com.huantansheng.easyphotos.models.ad.AdListener;
import com.huantansheng.easyphotos.models.album.AlbumModel;
import com.huantansheng.easyphotos.models.album.entity.Photo;
import com.huantansheng.easyphotos.result.Result;
import com.huantansheng.easyphotos.setting.Setting;
import com.huantansheng.easyphotos.ui.EasyPhotosActivity;
import com.huantansheng.easyphotos.ui.PuzzleActivity;
import com.huantansheng.easyphotos.utils.bitmap.BitmapUtils;
import com.huantansheng.easyphotos.utils.bitmap.SaveBitmapCallBack;
import com.huantansheng.easyphotos.utils.media.MediaScannerConnectionUtils;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class EasyPhotos {
    public static final String RESULT_PHOTOS = "keyOfEasyPhotosResult";
    public static final String RESULT_PATHS = "keyOfEasyPhotosResultPaths";
    public static final String RESULT_SELECTED_ORIGINAL = "keyOfEasyPhotosResultSelectedOriginal";
    public static final String RESULT_PUZZLE_PHOTO = "keyOfEasyPhotosResultPuzzlePhoto";
    public static final String RESULT_PUZZLE_PATH = "keyOfEasyPhotosResultPuzzlePath";
    private static EasyPhotos instance;
    private final WeakReference<Activity> mActivity;
    private StartupType startupType;
    private String fileProviderAuthoritiesText;
    private boolean isShowCamera = false;
    private boolean onlyStartCamera = false;
    private WeakReference<AdListener> adListener;

    private EasyPhotos(Activity activity, StartupType startupType) {
        this.mActivity = new WeakReference<Activity>(activity);
        this.startupType = startupType;
    }

    private static EasyPhotos with(Activity activity, StartupType startupType) {
        EasyPhotos.clear();
        instance = new EasyPhotos(activity, startupType);
        return instance;
    }

    public static EasyPhotos createCamera(Activity activity) {
        return EasyPhotos.with(activity, StartupType.CAMERA);
    }

    public static EasyPhotos createAlbum(Activity activity, boolean isShowCamera) {
        if (isShowCamera) {
            return EasyPhotos.with(activity, StartupType.ALBUM_CAMERA);
        }
        return EasyPhotos.with(activity, StartupType.ALBUM);
    }

    public EasyPhotos setFileProviderAuthoritiesText(String fileProviderAuthoritiesText) {
        this.fileProviderAuthoritiesText = fileProviderAuthoritiesText;
        return this;
    }

    public EasyPhotos setCount(int selectorMaxCount) {
        Setting.count = selectorMaxCount;
        return this;
    }

    public EasyPhotos setMinFileSize(long minFileSize) {
        Setting.minSize = minFileSize;
        return this;
    }

    public EasyPhotos setMinWidth(int minWidth) {
        Setting.minWidth = minWidth;
        return this;
    }

    public EasyPhotos setMinHeight(int minHeight) {
        Setting.minHeight = minHeight;
        return this;
    }

    public EasyPhotos setSelectedPhotos(ArrayList<Photo> selectedPhotos) {
        Setting.selectedPhotos.clear();
        if (selectedPhotos.isEmpty()) {
            return this;
        }
        Setting.selectedPhotos.addAll(selectedPhotos);
        Setting.selectedOriginal = selectedPhotos.get((int)0).selectedOriginal;
        return this;
    }

    public EasyPhotos setSelectedPhotoPaths(ArrayList<String> selectedPhotoPaths) {
        Setting.selectedPhotos.clear();
        ArrayList<Photo> selectedPhotos = new ArrayList<Photo>();
        for (String path : selectedPhotoPaths) {
            Photo photo = new Photo(false, null, path, 0L, 0, 0, 0L, null);
            selectedPhotos.add(photo);
        }
        Setting.selectedPhotos.addAll(selectedPhotos);
        return this;
    }

    public EasyPhotos setOriginalMenu(boolean isChecked, boolean usable, String unusableHint) {
        Setting.showOriginalMenu = true;
        Setting.selectedOriginal = isChecked;
        Setting.originalMenuUsable = usable;
        Setting.originalMenuUnusableHint = unusableHint;
        return this;
    }

    public void start(int requestCode) {
        switch (this.startupType) {
            case CAMERA: {
                this.onlyStartCamera = true;
                break;
            }
            case ALBUM: {
                this.isShowCamera = false;
                break;
            }
            case ALBUM_CAMERA: {
                this.isShowCamera = true;
            }
        }
        this.launchEasyPhotosActivity(requestCode);
    }

    private void launchEasyPhotosActivity(int requestCode) {
        EasyPhotosActivity.start((Activity)this.mActivity.get(), this.onlyStartCamera, this.isShowCamera, this.fileProviderAuthoritiesText, requestCode);
    }

    private static void clear() {
        Result.clear();
        Setting.clear();
        AlbumModel.clear();
        instance = null;
    }

    public EasyPhotos setAdView(View photosAdView, boolean photosAdIsLoaded, View albumItemsAdView, boolean albumItemsAdIsLoaded) {
        Setting.photosAdView = new WeakReference<View>(photosAdView);
        Setting.albumItemsAdView = new WeakReference<View>(albumItemsAdView);
        Setting.photoAdIsOk = photosAdIsLoaded;
        Setting.albumItemsAdIsOk = albumItemsAdIsLoaded;
        return this;
    }

    public static void setAdListener(AdListener adListener) {
        if (null == instance) {
            return;
        }
        if (EasyPhotos.instance.startupType == StartupType.CAMERA) {
            return;
        }
        EasyPhotos.instance.adListener = new WeakReference<AdListener>(adListener);
    }

    public static void notifyPhotosAdLoaded() {
        if (Setting.photoAdIsOk) {
            return;
        }
        if (null == instance) {
            return;
        }
        if (EasyPhotos.instance.startupType == StartupType.CAMERA) {
            return;
        }
        if (null == EasyPhotos.instance.adListener) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (null != instance && null != instance.adListener) {
                        Setting.photoAdIsOk = true;
                        ((AdListener)instance.adListener.get()).onPhotosAdLoaded();
                    }
                }
            }).start();
            return;
        }
        Setting.photoAdIsOk = true;
        ((AdListener)EasyPhotos.instance.adListener.get()).onPhotosAdLoaded();
    }

    public static void notifyAlbumItemsAdLoaded() {
        if (Setting.albumItemsAdIsOk) {
            return;
        }
        if (null == instance) {
            return;
        }
        if (EasyPhotos.instance.startupType == StartupType.CAMERA) {
            return;
        }
        if (null == EasyPhotos.instance.adListener) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (null != instance && null != instance.adListener) {
                        Setting.albumItemsAdIsOk = true;
                        ((AdListener)instance.adListener.get()).onAlbumItemsAdLoaded();
                    }
                }
            }).start();
            return;
        }
        Setting.albumItemsAdIsOk = true;
        ((AdListener)EasyPhotos.instance.adListener.get()).onAlbumItemsAdLoaded();
    }

    public static void recycle(Bitmap bitmap) {
        BitmapUtils.recycle(bitmap);
    }

    public static void recycle(Bitmap ... bitmaps) {
        BitmapUtils.recycle(bitmaps);
    }

    public static void recycle(List<Bitmap> bitmaps) {
        BitmapUtils.recycle(bitmaps);
    }

    public static void addWatermark(Bitmap watermark, Bitmap image, int srcImageWidth, int offsetX, int offsetY, boolean addInLeft) {
        BitmapUtils.addWatermark(watermark, image, srcImageWidth, offsetX, offsetY, addInLeft);
    }

    public static void addWatermarkWithText(Bitmap watermark, Bitmap image, int srcImageWidth, @NonNull String text, int offsetX, int offsetY, boolean addInLeft) {
        BitmapUtils.addWatermarkWithText(watermark, image, srcImageWidth, text, offsetX, offsetY, addInLeft);
    }

    public static void saveBitmapToDir(Activity act, String dirPath, String namePrefix, Bitmap bitmap, boolean notifyMedia, SaveBitmapCallBack callBack) {
        BitmapUtils.saveBitmapToDir(act, dirPath, namePrefix, bitmap, notifyMedia, callBack);
    }

    public static Bitmap createBitmapFromView(View view) {
        return BitmapUtils.createBitmapFromView(view);
    }

    public static void startPuzzleWithPhotos(Activity act, ArrayList<Photo> photos, String puzzleSaveDirPath, String puzzleSaveNamePrefix, int requestCode, boolean replaceCustom) {
        act.setResult(-1);
        PuzzleActivity.startWithPhotos(act, photos, puzzleSaveDirPath, puzzleSaveNamePrefix, requestCode, replaceCustom);
    }

    public static void startPuzzleWithPaths(Activity act, ArrayList<String> paths, String puzzleSaveDirPath, String puzzleSaveNamePrefix, int requestCode, boolean replaceCustom) {
        PuzzleActivity.startWithPaths(act, paths, puzzleSaveDirPath, puzzleSaveNamePrefix, requestCode, replaceCustom);
    }

    public static void notifyMedia(Context cxt, String ... filePaths) {
        MediaScannerConnectionUtils.refresh(cxt, filePaths);
    }

    public static void notifyMedia(Context cxt, File ... files) {
        MediaScannerConnectionUtils.refresh(cxt, files);
    }

    public static void notifyMedia(Context cxt, List<String> fileList) {
        MediaScannerConnectionUtils.refresh(cxt, fileList);
    }

    private static enum StartupType {
        CAMERA,
        ALBUM,
        ALBUM_CAMERA;

    }
}

