/*
 * Decompiled with CFR 0.152.
 */
package com.huantansheng.easyphotos;

import android.app.Activity;
import android.view.View;
import com.huantansheng.easyphotos.models.ad.AdListener;
import com.huantansheng.easyphotos.models.album.AlbumModel;
import com.huantansheng.easyphotos.result.Result;
import com.huantansheng.easyphotos.setting.Setting;
import com.huantansheng.easyphotos.ui.EasyPhotosActivity;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class EasyPhotos {
    public static final String RESULT = "keyOfEasyPhotosResult";
    private static EasyPhotos instance;
    private final WeakReference<Activity> mActivity;
    private StartupType startupType;
    private String fileProviderAuthoritiesText;
    private boolean isShowCamera = false;
    private boolean onlyStartCamera = false;
    private WeakReference<AdListener> adListener;

    private EasyPhotos(Activity activity, StartupType startupType) {
        this.mActivity = new WeakReference<Activity>(activity);
        this.startupType = startupType;
    }

    public static EasyPhotos with(Activity activity, StartupType startupType) {
        EasyPhotos.clear();
        instance = new EasyPhotos(activity, startupType);
        return instance;
    }

    public EasyPhotos setFileProviderAuthoritiesText(String fileProviderAuthoritiesText) {
        this.fileProviderAuthoritiesText = fileProviderAuthoritiesText;
        return this;
    }

    public EasyPhotos setCount(int selectorMaxCount) {
        if (Setting.count != 1 && Result.count() > selectorMaxCount) {
            Result.clear();
        }
        Setting.count = selectorMaxCount;
        return this;
    }

    public EasyPhotos setMinSize(int minWidth, int minHeight) {
        Setting.minWidth = minWidth;
        Setting.minHeight = minHeight;
        return this;
    }

    public EasyPhotos setSelectedPhotos(ArrayList<String> selectedPhotos) {
        Result.addSelectedPhotos(selectedPhotos);
        return this;
    }

    public EasyPhotos setAdView(View photosAdView, boolean photosAdIsLoaded, View albumItemsAdView, boolean albumItemsAdIsLoaded) {
        Setting.photosAdView = new WeakReference<View>(photosAdView);
        Setting.albumItemsAdView = new WeakReference<View>(albumItemsAdView);
        Setting.photoAdIsOk = photosAdIsLoaded;
        Setting.albumItemsAdIsOk = albumItemsAdIsLoaded;
        return this;
    }

    public void start(int requestCode) {
        switch (this.startupType) {
            case CAMERA: {
                this.onlyStartCamera = true;
                break;
            }
            case ALBUM: {
                this.isShowCamera = false;
                break;
            }
            case ALBUM_CAMERA: {
                this.isShowCamera = true;
            }
        }
        this.launchEasyPhotosActivity(requestCode);
    }

    private void launchEasyPhotosActivity(int requestCode) {
        EasyPhotosActivity.start((Activity)this.mActivity.get(), this.onlyStartCamera, this.isShowCamera, this.fileProviderAuthoritiesText, requestCode);
    }

    private static void clear() {
        Result.clear();
        Setting.clear();
        AlbumModel.clear();
        instance = null;
    }

    public static void setAdListener(AdListener adListener) {
        if (null == instance) {
            return;
        }
        EasyPhotos.instance.adListener = new WeakReference<AdListener>(adListener);
    }

    public static void notifyPhotosAdLoaded() {
        if (null == instance) {
            return;
        }
        if (null == EasyPhotos.instance.adListener) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (null != instance && null != instance.adListener) {
                        Setting.photoAdIsOk = true;
                        ((AdListener)instance.adListener.get()).onPhotosAdLoaded();
                    }
                }
            }).start();
            return;
        }
        Setting.photoAdIsOk = true;
        ((AdListener)EasyPhotos.instance.adListener.get()).onPhotosAdLoaded();
    }

    public static void notifyAlbumItemsAdLoaded() {
        if (null == instance) {
            return;
        }
        if (null == EasyPhotos.instance.adListener) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (null != instance && null != instance.adListener) {
                        Setting.albumItemsAdIsOk = true;
                        ((AdListener)instance.adListener.get()).onAlbumItemsAdLoaded();
                    }
                }
            }).start();
            return;
        }
        Setting.albumItemsAdIsOk = true;
        ((AdListener)EasyPhotos.instance.adListener.get()).onAlbumItemsAdLoaded();
    }

    public static enum StartupType {
        CAMERA,
        ALBUM,
        ALBUM_CAMERA;

    }
}

