/*
 * Decompiled with CFR 0.152.
 */
package utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.os.Build;
import androidx.annotation.NonNull;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import utils.FileUtils;
import utils.bean.ImageConfig;

public class CompressPicker {
    public static final int COMPRESS_SIZE = 150;
    private static final int BYTE_MONAD = 1024;
    private static ImageConfig mImageConfig;

    public static Bitmap compressBitmap(ImageConfig imageConfig) {
        Bitmap bitmap = null;
        if (null != imageConfig) {
            mImageConfig = imageConfig;
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inPreferredConfig = imageConfig.config;
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)imageConfig.imagePath, (BitmapFactory.Options)options);
            options.inSampleSize = (int)((float)options.outWidth * 1.0f / ((float)imageConfig.compressWidth * 1.0f) + (float)options.outHeight * 1.0f / ((float)imageConfig.compressHeight * 1.0f)) / 2;
            options.inJustDecodeBounds = false;
            options.inScaled = true;
            options.inMutable = true;
            if (Build.VERSION.SDK_INT >= 19) {
                options.inPremultiplied = true;
            }
            bitmap = BitmapFactory.decodeFile((String)imageConfig.imagePath, (BitmapFactory.Options)options);
            try {
                ExifInterface exif = new ExifInterface(imageConfig.imagePath);
                int orientation = exif.getAttributeInt("Orientation", 0);
                Matrix matrix = new Matrix();
                switch (orientation) {
                    case 6: {
                        matrix.postRotate(90.0f);
                        break;
                    }
                    case 3: {
                        matrix.postRotate(180.0f);
                        break;
                    }
                    case 8: {
                        matrix.postRotate(270.0f);
                        break;
                    }
                }
                bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            }
            catch (IOException e) {
                e.printStackTrace();
                return bitmap;
            }
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File bitmapToFile(@NonNull Bitmap bitmap) {
        if (mImageConfig == null) {
            mImageConfig = new ImageConfig();
        }
        FileOutputStream fos = null;
        int quality = 100;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        boolean result = bitmap.compress(CompressPicker.mImageConfig.format, quality, (OutputStream)bos);
        if (!result) {
            bitmap = bitmap.copy(Bitmap.Config.ARGB_8888, true);
            bitmap.compress(CompressPicker.mImageConfig.format, quality, (OutputStream)bos);
        }
        while (bos.toByteArray().length / 1024 > CompressPicker.mImageConfig.compressSize) {
            bos.reset();
            bitmap.compress(Bitmap.CompressFormat.JPEG, quality -= 5, (OutputStream)bos);
        }
        File file = new File(CompressPicker.mImageConfig.cachePathDirectory);
        file = FileUtils.outFileDirectory(file.getAbsolutePath());
        File imageFile = new File(file.getAbsoluteFile(), CompressPicker.mImageConfig.imageName);
        try {
            fos = new FileOutputStream(imageFile);
            fos.write(bos.toByteArray(), 0, bos.toByteArray().length);
            fos.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return imageFile;
    }
}

