/*
 * Decompiled with CFR 0.152.
 */
package utils.task;

import android.app.Activity;
import android.support.annotation.NonNull;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ActivityPicker {
    private final Map<String, SoftReference<Activity>> mActivityMap = new HashMap<String, SoftReference<Activity>>();
    private static ActivityPicker mActivityPicker;

    private ActivityPicker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ActivityPicker get() {
        Class<ActivityPicker> clazz = ActivityPicker.class;
        synchronized (ActivityPicker.class) {
            if (mActivityPicker != null) return mActivityPicker;
            Class<ActivityPicker> clazz2 = ActivityPicker.class;
            synchronized (ActivityPicker.class) {
                mActivityPicker = new ActivityPicker();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return mActivityPicker;
            }
        }
    }

    public void addActivity(@NonNull Activity activity) {
        this.mActivityMap.put(activity.getClass().getSimpleName(), new SoftReference<Activity>(activity));
    }

    public void removeActivity(@NonNull String key) {
        if (this.mActivityMap.size() > 0) {
            Activity activity;
            SoftReference<Activity> activitySoft = this.mActivityMap.get(key);
            if (activitySoft != null && (activity = activitySoft.get()) != null) {
                activity.finish();
            }
            this.mActivityMap.remove(key);
        }
    }

    public void clearActivity() {
        if (this.mActivityMap.size() > 0) {
            Set<Map.Entry<String, SoftReference<Activity>>> entrySet = this.mActivityMap.entrySet();
            Iterator<Map.Entry<String, SoftReference<Activity>>> iterator = entrySet.iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, SoftReference<Activity>> next = iterator.next();
                if (next.getValue() != null && next.getValue().get() != null) {
                    next.getValue().get().finish();
                }
                iterator.remove();
            }
        }
    }
}

