/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.view.video;

import android.content.ContentResolver;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.provider.Settings;

public class ScreenRotateUtils {
    public static float orientationDirection;
    private static int DATA_X;
    private static int DATA_Y;
    private static int DATA_Z;
    private static int ORIENTATION_UNKNOWN;
    private static ScreenRotateUtils instance;
    private Context context;
    private OrientationChangeListener changeListener;

    public ScreenRotateUtils(Context context) {
        this.context = context.getApplicationContext();
        SensorManager sm = (SensorManager)context.getSystemService("sensor");
        Sensor sensor = sm.getDefaultSensor(1);
        sm.registerListener((SensorEventListener)new OrientationSensorListener(), sensor, 3);
    }

    public static ScreenRotateUtils getInstance(Context context) {
        if (instance == null) {
            instance = new ScreenRotateUtils(context);
        }
        return instance;
    }

    void setOrientationChangeListener(OrientationChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    static {
        DATA_X = 0;
        DATA_Y = 1;
        DATA_Z = 2;
        ORIENTATION_UNKNOWN = -1;
    }

    class OrientationSensorListener
    implements SensorEventListener {
        OrientationSensorListener() {
        }

        public void onSensorChanged(SensorEvent event) {
            float z;
            float[] values = event.values;
            int orientation = ORIENTATION_UNKNOWN;
            float x = -values[DATA_X];
            orientationDirection = -x;
            float y = -values[DATA_Y];
            float magnitude = x * x + y * y;
            if (magnitude * 4.0f >= (z = -values[DATA_Z]) * z) {
                float oneEightyOverPi = 57.29578f;
                float angle = (float)(Math.atan2(-y, x) * (double)oneEightyOverPi);
                for (orientation = 90 - Math.round(angle); orientation >= 360; orientation -= 360) {
                }
                while (orientation < 0) {
                    orientation += 360;
                }
            }
            try {
                int isRotate = Settings.System.getInt((ContentResolver)ScreenRotateUtils.this.context.getContentResolver(), (String)"accelerometer_rotation");
                if (isRotate == 0) {
                    return;
                }
            }
            catch (Settings.SettingNotFoundException e) {
                e.printStackTrace();
            }
            ScreenRotateUtils.this.changeListener.orientationChange(orientation);
        }

        public void onAccuracyChanged(Sensor sensor, int i) {
        }
    }

    public static interface OrientationChangeListener {
        public void orientationChange(int var1);
    }
}

