/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class EncryptUtils {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private EncryptUtils() {
    }

    private static String bytes2HexString(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        int len = bytes.length;
        if (len <= 0) {
            return "";
        }
        char[] ret = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            ret[j++] = HEX_DIGITS[bytes[i] >>> 4 & 0xF];
            ret[j++] = HEX_DIGITS[bytes[i] & 0xF];
        }
        return new String(ret);
    }

    public static String encryptMD5ToString(String data) {
        if (data == null || data.length() == 0) {
            return "";
        }
        return EncryptUtils.encryptMD5ToString(data.getBytes());
    }

    public static String encryptMD5ToString(byte[] data) {
        return EncryptUtils.bytes2HexString(EncryptUtils.encryptMD5(data));
    }

    public static byte[] encryptMD5(byte[] data) {
        return EncryptUtils.hashTemplate(data, "MD5");
    }

    private static byte[] hashTemplate(byte[] data, String algorithm) {
        if (data == null || data.length <= 0) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(data);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }
}

