/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Color;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.hitomi.tilibrary.style.IIndexIndicator;
import com.hitomi.tilibrary.transfer.DragCloseGesture;
import com.hitomi.tilibrary.transfer.EmptyThumbState;
import com.hitomi.tilibrary.transfer.LocalThumbState;
import com.hitomi.tilibrary.transfer.NoneThumbState;
import com.hitomi.tilibrary.transfer.TransferAdapter;
import com.hitomi.tilibrary.transfer.TransferChangeListener;
import com.hitomi.tilibrary.transfer.TransferConfig;
import com.hitomi.tilibrary.transfer.TransferState;
import com.hitomi.tilibrary.transfer.VideoThumbState;
import com.hitomi.tilibrary.view.image.TransferImage;
import com.hitomi.tilibrary.view.video.ExoVideoView;
import java.util.HashSet;
import java.util.Set;

class TransferLayout
extends FrameLayout {
    private Context context;
    private TransferConfig transConfig;
    private DragCloseGesture dragCloseGesture;
    private TransferChangeListener transChangeListener;
    private OnLayoutResetListener layoutResetListener;
    TransferImage transImage;
    TransferAdapter transAdapter;
    ViewPager transViewPager;
    Set<Integer> loadedIndexSet;
    float alpha;
    boolean isAnimationRunning;
    private DragCloseGesture.DragCloseListener dragCloseListener = new DragCloseGesture.DragCloseListener(){

        @Override
        public void onDragStar() {
            if (TransferLayout.this.transConfig.isEnableDragHide()) {
                TransferLayout.this.hideIndexIndicator();
                TransferLayout.this.hideCustomView();
            }
            if (TransferLayout.this.transConfig.isEnableDragPause() && TransferLayout.this.transConfig.isVideoSource(-1)) {
                TransferLayout.this.transAdapter.getVideoItem(TransferLayout.this.transConfig.getNowThumbnailIndex()).pause();
            }
        }

        @Override
        public void onDragRollback() {
            if (TransferLayout.this.transConfig.isEnableDragHide()) {
                TransferLayout.this.showIndexIndicator(false);
                TransferLayout.this.showCustomView(false);
            }
            if (TransferLayout.this.transConfig.isEnableDragPause() && TransferLayout.this.transConfig.isVideoSource(-1)) {
                TransferLayout.this.transAdapter.getVideoItem(TransferLayout.this.transConfig.getNowThumbnailIndex()).resume();
            }
        }
    };
    private TransferAdapter.OnInstantiateItemListener instantListener = new TransferAdapter.OnInstantiateItemListener(){

        @Override
        public void onComplete() {
            TransferLayout.this.transViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)TransferLayout.this.transChangeListener);
            int position = TransferLayout.this.transConfig.getNowThumbnailIndex();
            if (TransferLayout.this.transConfig.isJustLoadHitPage()) {
                TransferLayout.this.loadSourceViewOffset(position, 0);
            } else {
                TransferLayout.this.loadSourceViewOffset(position, 1);
            }
            TransferLayout.this.transChangeListener.bindOperationListener(position);
            ExoVideoView videoView = TransferLayout.this.transAdapter.getVideoItem(position);
            if (videoView != null) {
                videoView.resume();
            }
        }
    };
    TransferImage.OnTransferListener transListener = new TransferImage.OnTransferListener(){
        private float currentAlpha;

        @Override
        public void onTransferStart(int state, int cate, int stage) {
            ImageView originImage;
            TransferLayout.this.isAnimationRunning = true;
            float f = this.currentAlpha = state == 3 ? TransferLayout.this.alpha : 255.0f;
            if (state == 1 && TransferLayout.this.transConfig.isEnableHideThumb() && (originImage = TransferLayout.this.transConfig.getOriginImageList().get(TransferLayout.this.transConfig.getNowThumbnailIndex())) != null) {
                TransferLayout.this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        originImage.setVisibility(4);
                    }
                }, 15L);
            }
        }

        @Override
        public void onTransferUpdate(int state, float fraction) {
            ImageView originImage;
            TransferLayout.this.alpha = this.currentAlpha * fraction;
            TransferLayout.this.setBackgroundColor(TransferLayout.this.getBackgroundColorByAlpha(TransferLayout.this.alpha));
            if (TransferLayout.this.transConfig.isEnableHideThumb() && (double)fraction <= 0.05 && (state == 2 || state == 3) && (originImage = TransferLayout.this.transConfig.getOriginImageList().get(TransferLayout.this.transConfig.getNowThumbnailIndex())) != null) {
                originImage.setVisibility(0);
            }
        }

        @Override
        public void onTransferComplete(int state, int cate, int stage) {
            if (cate == 100) {
                switch (state) {
                    case 1: {
                        TransferLayout.this.resumeTransfer();
                        break;
                    }
                    case 2: 
                    case 3: {
                        TransferLayout.this.resetTransfer();
                    }
                }
            } else {
                switch (state) {
                    case 1: {
                        if (stage != 201) break;
                        TransferLayout.this.resumeTransfer();
                        break;
                    }
                    case 2: {
                        if (stage != 201) break;
                        TransferLayout.this.resetTransfer();
                    }
                }
            }
        }
    };

    TransferLayout(Context context) {
        super(context);
        this.context = context;
        this.loadedIndexSet = new HashSet<Integer>();
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (ev.getPointerCount() == 1 && this.dragCloseGesture != null && this.dragCloseGesture.onInterceptTouchEvent(ev)) {
            return true;
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.dragCloseGesture != null) {
            this.dragCloseGesture.onTouchEvent(event);
        }
        return super.onTouchEvent(event);
    }

    int getBackgroundColorByAlpha(float alpha) {
        int bgColor = this.transConfig.getBackgroundColor();
        return Color.argb((int)Math.round(alpha), (int)Color.red((int)bgColor), (int)Color.green((int)bgColor), (int)Color.blue((int)bgColor));
    }

    void loadSourceViewOffset(int position, int offset) {
        int left = position - offset;
        int right = position + offset;
        if (!this.loadedIndexSet.contains(position)) {
            this.loadSourceView(position);
            this.loadedIndexSet.add(position);
        }
        if (left >= 0 && !this.loadedIndexSet.contains(left)) {
            this.loadSourceView(left);
            this.loadedIndexSet.add(left);
        }
        if (right < this.transConfig.getSourceUrlList().size() && !this.loadedIndexSet.contains(right)) {
            this.loadSourceView(right);
            this.loadedIndexSet.add(right);
        }
    }

    private void loadSourceView(int position) {
        this.getTransferState(position).transferLoad(position);
    }

    private void resetTransfer() {
        this.isAnimationRunning = false;
        this.loadedIndexSet.clear();
        this.removeIndexIndicator();
        this.removeAllViews();
        this.layoutResetListener.onReset();
    }

    private void resumeTransfer() {
        this.isAnimationRunning = false;
        this.showIndexIndicator(true);
        this.showCustomView(true);
        this.transViewPager.setVisibility(0);
        if (this.transImage != null && !this.transConfig.isVideoSource(-1)) {
            this.removeFromParent((View)this.transImage);
        }
    }

    private void createTransferViewPager(TransferState transferState) {
        this.transAdapter = new TransferAdapter(this, this.transConfig.getSourceUrlList().size(), this.transConfig.getNowThumbnailIndex());
        this.transAdapter.setOnInstantListener(this.instantListener);
        this.transViewPager = new ViewPager(this.context);
        if (transferState instanceof NoneThumbState) {
            this.transViewPager.setVisibility(0);
            this.setBackgroundColor(this.getBackgroundColorByAlpha(255.0f));
        } else {
            this.transViewPager.setVisibility(4);
        }
        this.transViewPager.setOffscreenPageLimit(this.transConfig.getOffscreenPageLimit() + 1);
        this.transViewPager.setAdapter((PagerAdapter)this.transAdapter);
        this.transViewPager.setCurrentItem(this.transConfig.getNowThumbnailIndex());
        this.addView((View)this.transViewPager, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    public void removeFromParent(View view) {
        if (view == null) {
            return;
        }
        ViewGroup vg = (ViewGroup)view.getParent();
        if (vg != null) {
            vg.removeView(view);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.transViewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this.transChangeListener);
    }

    TransferConfig getTransConfig() {
        return this.transConfig;
    }

    TransferImage getCurrentImage() {
        return this.transAdapter.getImageItem(this.transViewPager.getCurrentItem());
    }

    ExoVideoView getCurrentVideo() {
        return this.transAdapter.getVideoItem(this.transViewPager.getCurrentItem());
    }

    void show() {
        int nowThumbnailIndex = this.transConfig.getNowThumbnailIndex();
        TransferState transferState = this.getTransferState(nowThumbnailIndex);
        this.createTransferViewPager(transferState);
        this.transImage = transferState.transferIn(nowThumbnailIndex);
    }

    TransferState getTransferState(int position) {
        TransferState transferState;
        if (this.transConfig.isVideoSource(position)) {
            transferState = new VideoThumbState(this);
        } else if (this.transConfig.getOriginImageList().isEmpty()) {
            transferState = new NoneThumbState(this);
        } else {
            String url = this.transConfig.getSourceUrlList().get(position);
            transferState = this.transConfig.getImageLoader().getCache(url) != null ? new LocalThumbState(this) : new EmptyThumbState(this);
        }
        return transferState;
    }

    boolean dismiss(int pos) {
        if (this.isAnimationRunning || this.transImage != null && this.transImage.getState() == 2) {
            return false;
        }
        this.transImage = this.getTransferState(pos).transferOut(pos);
        if (this.transImage == null) {
            this.diffusionTransfer(pos);
        } else {
            this.transViewPager.setVisibility(4);
        }
        this.hideIndexIndicator();
        return true;
    }

    void displayTransfer() {
        ObjectAnimator alphaAnim = ObjectAnimator.ofFloat((Object)((Object)this), (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scaleX", (float[])new float[]{1.2f, 1.0f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scaleY", (float[])new float[]{1.2f, 1.0f});
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{alphaAnim, scaleX, scaleY});
        animatorSet.setDuration(this.transConfig.getDuration());
        animatorSet.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                TransferLayout.this.isAnimationRunning = true;
            }

            public void onAnimationEnd(Animator animation) {
                TransferLayout.this.resumeTransfer();
                TransferLayout.this.alpha = 255.0f;
            }
        });
        animatorSet.start();
    }

    void diffusionTransfer(int pos) {
        ExoVideoView diffVideoView;
        TransferImage diffTransImage = this.transAdapter.getImageItem(pos);
        if (diffTransImage != null) {
            diffTransImage.disable();
        }
        if ((diffVideoView = this.transAdapter.getVideoItem(pos)) != null) {
            diffVideoView.pause();
        }
        float scale = this.transViewPager.getScaleX();
        PropertyValuesHolder alphaHolder = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{this.alpha, 0.0f});
        PropertyValuesHolder scaleXHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{scale, scale + 0.2f});
        ValueAnimator valueAnimator = new ValueAnimator();
        valueAnimator.setDuration(this.transConfig.getDuration());
        valueAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        valueAnimator.setValues(new PropertyValuesHolder[]{alphaHolder, scaleXHolder});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float alpha = ((Float)animation.getAnimatedValue("alpha")).floatValue();
                float scale = ((Float)animation.getAnimatedValue("scale")).floatValue();
                TransferLayout.this.setBackgroundColor(TransferLayout.this.getBackgroundColorByAlpha(alpha));
                TransferLayout.this.transViewPager.setAlpha(alpha / 255.0f);
                TransferLayout.this.transViewPager.setScaleX(scale);
                TransferLayout.this.transViewPager.setScaleY(scale);
            }
        });
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                TransferLayout.this.isAnimationRunning = true;
            }

            public void onAnimationEnd(Animator animation) {
                TransferLayout.this.resetTransfer();
            }
        });
        valueAnimator.start();
    }

    void apply(TransferConfig config) {
        this.transConfig = config;
        if (this.transChangeListener == null) {
            this.transChangeListener = new TransferChangeListener(this, this.transConfig);
        } else {
            this.transChangeListener.updateConfig(this.transConfig);
        }
        if (this.transConfig.isEnableDragClose()) {
            this.dragCloseGesture = new DragCloseGesture(this, this.dragCloseListener);
        }
    }

    void pauseOrPlayVideo(boolean pause) {
        ExoVideoView videoView = this.transAdapter.getVideoItem(this.transConfig.getNowThumbnailIndex());
        if (videoView != null) {
            if (pause) {
                videoView.pause();
            } else {
                videoView.resume();
            }
        }
    }

    void setOnLayoutResetListener(OnLayoutResetListener listener) {
        this.layoutResetListener = listener;
    }

    private void showIndexIndicator(boolean init) {
        IIndexIndicator indexIndicator = this.transConfig.getIndexIndicator();
        if (indexIndicator != null && this.transConfig.getSourceUrlList().size() >= 2) {
            if (init) {
                indexIndicator.attach(this);
            }
            indexIndicator.onShow(this.transViewPager);
        }
    }

    private void hideIndexIndicator() {
        IIndexIndicator indexIndicator = this.transConfig.getIndexIndicator();
        if (indexIndicator != null && this.transConfig.getSourceUrlList().size() >= 2) {
            indexIndicator.onHide();
        }
    }

    private void showCustomView(boolean init) {
        View customView = this.transConfig.getCustomView();
        if (customView != null) {
            if (init) {
                this.addView(customView);
            }
            customView.setVisibility(0);
        }
    }

    private void hideCustomView() {
        View customView = this.transConfig.getCustomView();
        if (customView != null) {
            customView.setVisibility(8);
        }
    }

    private void removeIndexIndicator() {
        IIndexIndicator indexIndicator = this.transConfig.getIndexIndicator();
        if (indexIndicator != null && this.transConfig.getSourceUrlList().size() >= 2) {
            indexIndicator.onRemove();
        }
    }

    static interface OnLayoutResetListener {
        public void onReset();
    }
}

