/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import com.hitomi.tilibrary.loader.ImageLoader;
import com.hitomi.tilibrary.transfer.TransferConfig;
import com.hitomi.tilibrary.transfer.TransferLayout;
import com.hitomi.tilibrary.transfer.TransferState;
import com.hitomi.tilibrary.utils.ImageUtils;
import com.hitomi.tilibrary.view.image.TransferImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import pl.droidsonroids.gif.GifDrawable;

class LocalThumbState
extends TransferState {
    LocalThumbState(TransferLayout transfer) {
        super(transfer);
    }

    private void loadThumbnail(String imageUrl, TransferImage transImage, boolean in) {
        Bitmap thumbBitmap;
        TransferConfig config = this.transfer.getTransConfig();
        ImageLoader imageLoader = config.getImageLoader();
        File thumbFile = imageLoader.getCache(imageUrl);
        Bitmap bitmap = thumbBitmap = thumbFile != null ? BitmapFactory.decodeFile((String)thumbFile.getAbsolutePath()) : null;
        if (thumbBitmap == null) {
            transImage.setImageDrawable(config.getMissDrawable(this.transfer.getContext()));
        } else {
            transImage.setImageBitmap(thumbBitmap);
        }
        if (in) {
            transImage.transformIn();
        } else {
            transImage.transformOut();
        }
    }

    @Override
    public void prepareTransfer(TransferImage transImage, int position) {
        TransferConfig config = this.transfer.getTransConfig();
        String imgUrl = config.getSourceUrlList().get(position);
        File cache = config.getImageLoader().getCache(imgUrl);
        if (cache == null) {
            return;
        }
        if (ImageUtils.getImageType(cache) == 1) {
            try {
                transImage.setImageDrawable((Drawable)new GifDrawable(cache.getPath()));
            }
            catch (IOException iOException) {}
        } else {
            transImage.setImageBitmap(BitmapFactory.decodeFile((String)cache.getAbsolutePath()));
        }
        transImage.enableGesture();
    }

    @Override
    public TransferImage transferIn(int position) {
        TransferConfig config = this.transfer.getTransConfig();
        TransferImage transImage = this.createTransferImage(config.getOriginImageList().get(position), true);
        this.loadThumbnail(config.getSourceUrlList().get(position), transImage, true);
        this.transfer.addView((View)transImage, 1);
        return transImage;
    }

    @Override
    public void transferLoad(int position) {
        TransferConfig config = this.transfer.getTransConfig();
        String imgUrl = config.getSourceUrlList().get(position);
        TransferImage targetImage = this.transfer.transAdapter.getImageItem(position);
        if (config.isJustLoadHitPage()) {
            this.loadSourceImage(imgUrl, targetImage, position);
        } else {
            String filePath = config.getImageLoader().getCache(imgUrl).getAbsolutePath();
            Bitmap bitmap = BitmapFactory.decodeFile((String)filePath);
            if (bitmap == null) {
                targetImage.setImageDrawable(config.getMissDrawable(this.transfer.getContext()));
            } else {
                targetImage.setImageBitmap(bitmap);
            }
            this.loadSourceImage(imgUrl, targetImage, position);
        }
    }

    private void loadSourceImage(final String imgUrl, final TransferImage targetImage, final int position) {
        TransferConfig config = this.transfer.getTransConfig();
        config.getImageLoader().loadSource(imgUrl, new ImageLoader.SourceCallback(){

            @Override
            public void onStart() {
            }

            @Override
            public void onProgress(int progress) {
            }

            @Override
            public void onDelivered(int status, File source) {
                switch (status) {
                    case 1: {
                        LocalThumbState.this.startPreview(targetImage, source, imgUrl, new TransferState.StartPreviewCallback(){

                            @Override
                            public void invoke() {
                                if (4 == targetImage.getState()) {
                                    targetImage.transformIn(202);
                                }
                            }
                        });
                        break;
                    }
                    case 0: {
                        LocalThumbState.this.loadFailedDrawable(targetImage, position);
                    }
                }
            }
        });
    }

    @Override
    public TransferImage transferOut(int position) {
        TransferImage transImage = null;
        TransferConfig config = this.transfer.getTransConfig();
        List<ImageView> originImageList = config.getOriginImageList();
        if (position <= originImageList.size() - 1 && originImageList.get(position) != null) {
            transImage = this.createTransferImage(originImageList.get(position), true);
            this.loadThumbnail(config.getSourceUrlList().get(position), transImage, false);
            this.transfer.addView((View)transImage, 1);
        }
        return transImage;
    }
}

