/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.style.index;

import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.viewpager.widget.ViewPager;
import com.hitomi.tilibrary.style.IIndexIndicator;
import com.hitomi.tilibrary.view.indicator.CircleIndicator;

public class CircleIndexIndicator
implements IIndexIndicator {
    private CircleIndicator circleIndicator;

    @Override
    public void attach(FrameLayout parent) {
        FrameLayout.LayoutParams indexLp = new FrameLayout.LayoutParams(-2, 48);
        indexLp.gravity = 81;
        indexLp.bottomMargin = 10;
        this.circleIndicator = new CircleIndicator(parent.getContext());
        this.circleIndicator.setGravity(16);
        this.circleIndicator.setLayoutParams((ViewGroup.LayoutParams)indexLp);
        parent.addView((View)this.circleIndicator);
    }

    @Override
    public void onShow(ViewPager viewPager) {
        if (this.circleIndicator == null) {
            return;
        }
        this.circleIndicator.setVisibility(0);
        this.circleIndicator.setViewPager(viewPager);
    }

    @Override
    public void onHide() {
        if (this.circleIndicator == null) {
            return;
        }
        this.circleIndicator.setVisibility(8);
    }

    @Override
    public void onRemove() {
        if (this.circleIndicator == null) {
            return;
        }
        ViewGroup vg = (ViewGroup)this.circleIndicator.getParent();
        if (vg != null) {
            vg.removeView((View)this.circleIndicator);
        }
    }
}

