/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.view.indicator;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.viewpager.widget.ViewPager;
import java.util.Locale;

public class NumberIndicator
extends TextView {
    private static final String STR_NUM_FORMAT = "%s/%s";
    private ViewPager mViewPager;
    private final ViewPager.OnPageChangeListener mInternalPageChangeListener = new ViewPager.OnPageChangeListener(){

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int position) {
            if (NumberIndicator.this.mViewPager.getAdapter() == null || NumberIndicator.this.mViewPager.getAdapter().getCount() <= 0) {
                return;
            }
            NumberIndicator.this.setText(String.format(Locale.getDefault(), NumberIndicator.STR_NUM_FORMAT, position + 1, NumberIndicator.this.mViewPager.getAdapter().getCount()));
        }

        public void onPageScrollStateChanged(int state) {
        }
    };

    public NumberIndicator(Context context) {
        this(context, null);
    }

    public NumberIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NumberIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initNumberIndicator();
    }

    private void initNumberIndicator() {
        this.setTextColor(-1);
        this.setTextSize(18.0f);
    }

    public void setViewPager(ViewPager viewPager) {
        if (viewPager != null && viewPager.getAdapter() != null) {
            this.mViewPager = viewPager;
            this.mViewPager.removeOnPageChangeListener(this.mInternalPageChangeListener);
            this.mViewPager.addOnPageChangeListener(this.mInternalPageChangeListener);
            this.mInternalPageChangeListener.onPageSelected(this.mViewPager.getCurrentItem());
        }
    }
}

