/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.app.Activity;
import android.app.Application;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.KeyEvent;
import android.view.View;
import android.widget.ImageView;
import androidx.appcompat.app.AlertDialog;
import com.gyf.immersionbar.ImmersionBar;
import com.hitomi.tilibrary.style.index.CircleIndexIndicator;
import com.hitomi.tilibrary.style.progress.ProgressBarIndicator;
import com.hitomi.tilibrary.transfer.OriginalViewHelper;
import com.hitomi.tilibrary.transfer.TransferConfig;
import com.hitomi.tilibrary.transfer.TransferLayout;
import com.hitomi.tilibrary.utils.AppManager;
import com.hitomi.tilibrary.utils.FileUtils;
import com.hitomi.tilibrary.view.video.source.ExoSourceManager;
import java.io.File;

public class Transferee
implements DialogInterface.OnShowListener,
DialogInterface.OnKeyListener,
TransferLayout.OnLayoutResetListener,
AppManager.OnAppStateChangeListener {
    private Context context;
    private Dialog transDialog;
    private TransferLayout transLayout;
    private TransferConfig transConfig;
    private OnTransfereeStateChangeListener transListener;
    private boolean shown;

    private Transferee(Context context) {
        this.context = context;
        this.createLayout();
        this.createDialog();
        AppManager.getInstance().init((Application)context.getApplicationContext());
    }

    public static Transferee getDefault(Context context) {
        return new Transferee(context);
    }

    private void createLayout() {
        this.transLayout = new TransferLayout(this.context);
        this.transLayout.setOnLayoutResetListener(this);
    }

    private void createDialog() {
        this.transDialog = new AlertDialog.Builder(this.context, 0x1030011).setView((View)this.transLayout).create();
        this.transDialog.setOnShowListener((DialogInterface.OnShowListener)this);
        this.transDialog.setOnKeyListener((DialogInterface.OnKeyListener)this);
    }

    private void checkConfig() {
        if (this.transConfig == null) {
            throw new IllegalArgumentException("The parameter TransferConfig can't be null");
        }
        if (this.transConfig.isSourceEmpty()) {
            throw new IllegalArgumentException("The parameter sourceUrlList or sourceUriList  can't be empty");
        }
        if (this.transConfig.getImageLoader() == null) {
            throw new IllegalArgumentException("Need to specify an ImageLoader");
        }
        this.transConfig.setNowThumbnailIndex(Math.max(this.transConfig.getNowThumbnailIndex(), 0));
        this.transConfig.setOffscreenPageLimit(this.transConfig.getOffscreenPageLimit() <= 0 ? 1 : this.transConfig.getOffscreenPageLimit());
        this.transConfig.setDuration(this.transConfig.getDuration() <= 0L ? 300L : this.transConfig.getDuration());
        this.transConfig.setProgressIndicator(this.transConfig.getProgressIndicator() == null ? new ProgressBarIndicator() : this.transConfig.getProgressIndicator());
        this.transConfig.setIndexIndicator(this.transConfig.getIndexIndicator() == null ? new CircleIndexIndicator() : this.transConfig.getIndexIndicator());
    }

    public Transferee apply(TransferConfig config) {
        if (!this.shown) {
            this.transConfig = config;
            OriginalViewHelper.getInstance().fillOriginImages(config);
            this.checkConfig();
            this.transLayout.apply(config);
        }
        return this;
    }

    public boolean isShown() {
        return this.shown;
    }

    public void show() {
        if (this.shown) {
            return;
        }
        if (this.context instanceof Activity) {
            ImmersionBar.with((Activity)((Activity)this.context), (Dialog)this.transDialog).init();
        }
        this.transDialog.show();
        if (this.transListener != null) {
            this.transListener.onShow();
        }
        this.shown = true;
    }

    public void show(OnTransfereeStateChangeListener listener) {
        if (this.shown) {
            return;
        }
        this.transDialog.show();
        this.transListener = listener;
        this.transListener.onShow();
        this.shown = true;
    }

    public void dismiss() {
        if (this.shown && this.transLayout.dismiss(this.transConfig.getNowThumbnailIndex())) {
            this.shown = false;
        }
    }

    public File getImageFile(String imageUrl) {
        return this.transConfig.getImageLoader().getCache(imageUrl);
    }

    public void clear() {
        File cacheFile;
        if (this.transConfig != null && this.transConfig.getImageLoader() != null) {
            this.transConfig.getImageLoader().clearCache();
        }
        if ((cacheFile = new File(this.context.getCacheDir(), "TransExo")).exists() && !this.shown) {
            FileUtils.deleteDir(new File(cacheFile, "frame"));
            ExoSourceManager.clearCache(this.context, cacheFile, null);
        }
    }

    public void onShow(DialogInterface dialog) {
        AppManager.getInstance().register(this);
        this.transLayout.show();
    }

    @Override
    public void onReset() {
        AppManager.getInstance().unregister(this);
        this.transDialog.dismiss();
        if (this.transListener != null) {
            this.transListener.onDismiss();
        }
        this.shown = false;
    }

    public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
        if (keyCode == 4 && event.getAction() == 1 && !event.isCanceled()) {
            this.dismiss();
            return true;
        }
        return false;
    }

    @Override
    public void onForeground() {
        this.transLayout.pauseOrPlayVideo(false);
    }

    @Override
    public void onBackground() {
        this.transLayout.pauseOrPlayVideo(true);
    }

    public void setOnTransfereeStateChangeListener(OnTransfereeStateChangeListener listener) {
        this.transListener = listener;
    }

    public static interface OnTransfereeLongClickListener {
        public void onLongClick(ImageView var1, String var2, int var3);
    }

    public static interface OnTransfereeStateChangeListener {
        public void onShow();

        public void onDismiss();
    }
}

