/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.util.Log;
import android.widget.AbsListView;
import android.widget.ImageView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.hitomi.tilibrary.transfer.TransferConfig;
import java.util.ArrayList;
import java.util.List;

class OriginalViewHelper {
    private static final String TAG = "OriginalViewHelper";
    private TransferConfig transConfig;

    private OriginalViewHelper() {
    }

    static OriginalViewHelper getInstance() {
        return SingletonHolder.instance;
    }

    void fillOriginImages(TransferConfig config) {
        this.transConfig = config;
        ArrayList<ImageView> originImageList = new ArrayList<ImageView>();
        if (this.transConfig.getRecyclerView() != null) {
            this.fillByRecyclerView(originImageList);
        } else if (this.transConfig.getListView() != null) {
            this.fillByListView(originImageList);
        } else if (this.transConfig.getImageView() != null) {
            originImageList.add(this.transConfig.getImageView());
            int size = this.transConfig.getSourceUrlList().size();
            for (int i = 0; i < size - 1; ++i) {
                originImageList.add(null);
            }
        }
        this.transConfig.setOriginImageList(originImageList);
    }

    private void fillByRecyclerView(List<ImageView> originImageList) {
        int headerSize = this.transConfig.getHeaderSize();
        int footerSize = this.transConfig.getFooterSize();
        RecyclerView recyclerView = this.transConfig.getRecyclerView();
        int childCount = recyclerView.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ImageView originImage = (ImageView)recyclerView.getChildAt(i).findViewById(this.transConfig.getImageId());
            if (originImage == null) continue;
            originImageList.add(originImage);
        }
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        int firstPos = 0;
        int lastPos = 0;
        int totalCount = layoutManager.getItemCount() - headerSize - footerSize;
        if (layoutManager instanceof LinearLayoutManager) {
            LinearLayoutManager linLayMan = (LinearLayoutManager)layoutManager;
            firstPos = linLayMan.findFirstVisibleItemPosition();
            firstPos = firstPos < headerSize ? 0 : firstPos - headerSize;
            lastPos = linLayMan.findLastVisibleItemPosition();
            lastPos = lastPos > totalCount ? totalCount - 1 : lastPos - headerSize;
        }
        this.fillPlaceHolder(originImageList, totalCount, firstPos, lastPos);
        Log.e((String)TAG, (String)String.format("totalCount = %s, firstPos = %s, lastPos = %s", totalCount, firstPos, lastPos));
    }

    private void fillByListView(List<ImageView> originImageList) {
        int headerSize = this.transConfig.getHeaderSize();
        int footerSize = this.transConfig.getFooterSize();
        AbsListView absListView = this.transConfig.getListView();
        int childCount = absListView.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ImageView originImage = (ImageView)absListView.getChildAt(i).findViewById(this.transConfig.getImageId());
            originImageList.add(originImage);
        }
        int firstPos = absListView.getFirstVisiblePosition() - headerSize;
        int lastPos = absListView.getLastVisiblePosition() - headerSize - footerSize;
        int totalCount = absListView.getCount() - headerSize - footerSize;
        this.fillPlaceHolder(originImageList, totalCount, firstPos, lastPos);
    }

    private void fillPlaceHolder(List<ImageView> originImageList, int totalCount, int firstPos, int lastPos) {
        if (firstPos > 0) {
            for (int pos = firstPos; pos > 0; --pos) {
                originImageList.add(0, null);
            }
        }
        if (lastPos < totalCount) {
            for (int i = totalCount - 1 - lastPos; i > 0; --i) {
                originImageList.add(null);
            }
        }
    }

    private static class SingletonHolder {
        private static final OriginalViewHelper instance = new OriginalViewHelper();

        private SingletonHolder() {
        }
    }
}

