/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.style.progress;

import android.content.Context;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import com.hitomi.tilibrary.style.IProgressIndicator;

public class ProgressBarIndicator
implements IProgressIndicator {
    private SparseArray<ProgressBar> progressBarArray = new SparseArray();

    private int dip2Px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    @Override
    public void attach(int position, FrameLayout parent) {
        Context context = parent.getContext();
        int progressSize = this.dip2Px(context, 50.0f);
        FrameLayout.LayoutParams progressLp = new FrameLayout.LayoutParams(progressSize, progressSize);
        progressLp.gravity = 17;
        ProgressBar progressBar = new ProgressBar(context);
        progressBar.setLayoutParams((ViewGroup.LayoutParams)progressLp);
        parent.addView((View)progressBar, parent.getChildCount());
        this.progressBarArray.put(position, (Object)progressBar);
    }

    @Override
    public void hideView(int position) {
        ProgressBar progressBar = (ProgressBar)this.progressBarArray.get(position);
        if (progressBar != null) {
            progressBar.setVisibility(8);
        }
    }

    @Override
    public void onStart(int position) {
    }

    @Override
    public void onProgress(int position, int progress) {
    }

    @Override
    public void onFinish(int position) {
        ProgressBar progressBar = (ProgressBar)this.progressBarArray.get(position);
        if (progressBar == null) {
            return;
        }
        ViewGroup vg = (ViewGroup)progressBar.getParent();
        if (vg != null) {
            vg.removeView((View)progressBar);
        }
    }
}

