/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.view.indicator;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import androidx.viewpager.widget.ViewPager;
import com.hitomi.tilibrary.R;

public class CircleIndicator
extends LinearLayout {
    private static final int DEFAULT_INDICATOR_WIDTH = 5;
    private ViewPager mViewpager;
    private GradientDrawable mIndicatorBackground;
    private Animator mAnimatorOut;
    private Animator mAnimatorIn;
    private Animator mImmediateAnimatorOut;
    private Animator mImmediateAnimatorIn;
    private int mIndicatorMargin = -1;
    private int mIndicatorWidth = -1;
    private int mIndicatorHeight = -1;
    private int mLastPosition = -1;
    private final ViewPager.OnPageChangeListener mInternalPageChangeListener = new ViewPager.OnPageChangeListener(){

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int position) {
            View selectedIndicator;
            View currentIndicator;
            if (CircleIndicator.this.mViewpager.getAdapter() == null || CircleIndicator.this.mViewpager.getAdapter().getCount() <= 0) {
                return;
            }
            if (CircleIndicator.this.mAnimatorIn.isRunning()) {
                CircleIndicator.this.mAnimatorIn.end();
                CircleIndicator.this.mAnimatorIn.cancel();
            }
            if (CircleIndicator.this.mAnimatorOut.isRunning()) {
                CircleIndicator.this.mAnimatorOut.end();
                CircleIndicator.this.mAnimatorOut.cancel();
            }
            if (CircleIndicator.this.mLastPosition >= 0 && (currentIndicator = CircleIndicator.this.getChildAt(CircleIndicator.this.mLastPosition)) != null) {
                currentIndicator.setBackgroundDrawable((Drawable)CircleIndicator.this.mIndicatorBackground);
                CircleIndicator.this.mAnimatorIn.setTarget((Object)currentIndicator);
                CircleIndicator.this.mAnimatorIn.start();
            }
            if ((selectedIndicator = CircleIndicator.this.getChildAt(position)) != null) {
                selectedIndicator.setBackgroundDrawable((Drawable)CircleIndicator.this.mIndicatorBackground);
                CircleIndicator.this.mAnimatorOut.setTarget((Object)selectedIndicator);
                CircleIndicator.this.mAnimatorOut.start();
            }
            CircleIndicator.this.mLastPosition = position;
        }

        public void onPageScrollStateChanged(int state) {
        }
    };
    private DataSetObserver mInternalDataSetObserver = new DataSetObserver(){

        public void onChanged() {
            int currentCount;
            super.onChanged();
            if (CircleIndicator.this.mViewpager == null) {
                return;
            }
            int newCount = CircleIndicator.this.mViewpager.getAdapter().getCount();
            if (newCount == (currentCount = CircleIndicator.this.getChildCount())) {
                return;
            }
            if (CircleIndicator.this.mLastPosition < newCount) {
                CircleIndicator.this.mLastPosition = CircleIndicator.this.mViewpager.getCurrentItem();
            } else {
                CircleIndicator.this.mLastPosition = -1;
            }
            CircleIndicator.this.createIndicators();
        }
    };

    public CircleIndicator(Context context) {
        this(context, null);
    }

    public CircleIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mIndicatorBackground = new GradientDrawable();
        this.mIndicatorBackground.setShape(1);
        this.mIndicatorBackground.setColor(-1);
        this.handleTypedArray(context, attrs);
        this.checkIndicatorConfig(context);
    }

    private void handleTypedArray(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CircleIndicator);
        this.mIndicatorWidth = typedArray.getDimensionPixelSize(R.styleable.CircleIndicator_ci_width, -1);
        this.mIndicatorHeight = typedArray.getDimensionPixelSize(R.styleable.CircleIndicator_ci_height, -1);
        this.mIndicatorMargin = typedArray.getDimensionPixelSize(R.styleable.CircleIndicator_ci_margin, -1);
        int orientation = typedArray.getInt(R.styleable.CircleIndicator_ci_orientation, -1);
        this.setOrientation(orientation == 1 ? 1 : 0);
        int gravity = typedArray.getInt(R.styleable.CircleIndicator_ci_gravity, -1);
        this.setGravity(gravity >= 0 ? gravity : 17);
        typedArray.recycle();
    }

    public void configureIndicator(int indicatorWidth, int indicatorHeight, int indicatorMargin) {
        this.mIndicatorWidth = indicatorWidth;
        this.mIndicatorHeight = indicatorHeight;
        this.mIndicatorMargin = indicatorMargin;
        this.checkIndicatorConfig(this.getContext());
    }

    private void checkIndicatorConfig(Context context) {
        this.mIndicatorWidth = this.mIndicatorWidth < 0 ? this.dip2px(5.0f) : this.mIndicatorWidth;
        this.mIndicatorHeight = this.mIndicatorHeight < 0 ? this.dip2px(5.0f) : this.mIndicatorHeight;
        this.mIndicatorMargin = this.mIndicatorMargin < 0 ? this.dip2px(5.0f) : this.mIndicatorMargin;
        this.mAnimatorOut = this.createAnimatorOut();
        this.mImmediateAnimatorOut = this.createAnimatorOut();
        this.mImmediateAnimatorOut.setDuration(0L);
        this.mAnimatorIn = this.createAnimatorIn(context);
        this.mImmediateAnimatorIn = this.createAnimatorIn(context);
        this.mImmediateAnimatorIn.setDuration(0L);
    }

    private Animator createAnimatorOut() {
        ObjectAnimator alphaAnima = ObjectAnimator.ofFloat(null, (String)"alpha", (float[])new float[]{0.5f, 1.0f});
        ObjectAnimator scaleX = ObjectAnimator.ofFloat(null, (String)"scaleX", (float[])new float[]{1.0f, 1.8f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat(null, (String)"scaleY", (float[])new float[]{1.0f, 1.8f});
        AnimatorSet animatorOut = new AnimatorSet();
        animatorOut.play((Animator)alphaAnima).with((Animator)scaleX).with((Animator)scaleY);
        return animatorOut;
    }

    private Animator createAnimatorIn(Context context) {
        Animator animatorIn = this.createAnimatorOut();
        animatorIn.setInterpolator((TimeInterpolator)new ReverseInterpolator());
        return animatorIn;
    }

    public void setViewPager(ViewPager viewPager) {
        this.mViewpager = viewPager;
        if (this.mViewpager != null && this.mViewpager.getAdapter() != null) {
            this.mLastPosition = -1;
            this.createIndicators();
            this.mViewpager.removeOnPageChangeListener(this.mInternalPageChangeListener);
            this.mViewpager.addOnPageChangeListener(this.mInternalPageChangeListener);
            this.mInternalPageChangeListener.onPageSelected(this.mViewpager.getCurrentItem());
        }
    }

    public DataSetObserver getDataSetObserver() {
        return this.mInternalDataSetObserver;
    }

    @Deprecated
    public void setOnPageChangeListener(ViewPager.OnPageChangeListener onPageChangeListener) {
        if (this.mViewpager == null) {
            throw new NullPointerException("can not find Viewpager , setViewPager first");
        }
        this.mViewpager.removeOnPageChangeListener(onPageChangeListener);
        this.mViewpager.addOnPageChangeListener(onPageChangeListener);
    }

    private void createIndicators() {
        this.removeAllViews();
        int count = this.mViewpager.getAdapter().getCount();
        if (count <= 0) {
            return;
        }
        int currentItem = this.mViewpager.getCurrentItem();
        int orientation = this.getOrientation();
        for (int i = 0; i < count; ++i) {
            if (currentItem == i) {
                this.addIndicator(orientation, this.mImmediateAnimatorOut);
                continue;
            }
            this.addIndicator(orientation, this.mImmediateAnimatorIn);
        }
    }

    private void addIndicator(int orientation, Animator animator) {
        if (animator.isRunning()) {
            animator.end();
            animator.cancel();
        }
        View indicator = new View(this.getContext());
        indicator.setBackgroundDrawable((Drawable)this.mIndicatorBackground);
        this.addView(indicator, this.mIndicatorWidth, this.mIndicatorHeight);
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)indicator.getLayoutParams();
        if (orientation == 0) {
            lp.leftMargin = this.mIndicatorMargin;
            lp.rightMargin = this.mIndicatorMargin;
        } else {
            lp.topMargin = this.mIndicatorMargin;
            lp.bottomMargin = this.mIndicatorMargin;
        }
        indicator.setLayoutParams((ViewGroup.LayoutParams)lp);
        animator.setTarget((Object)indicator);
        animator.start();
    }

    public int dip2px(float dpValue) {
        float scale = this.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    private class ReverseInterpolator
    implements Interpolator {
        private ReverseInterpolator() {
        }

        public float getInterpolation(float value) {
            return Math.abs(1.0f - value);
        }
    }
}

