/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.view.image;

import android.view.MotionEvent;
import com.hitomi.tilibrary.view.image.OnRotateListener;

public class RotateGestureDetector {
    private static final int MAX_DEGREES_STEP = 120;
    private OnRotateListener mListener;
    private float mPrevSlope;
    private float mCurrSlope;
    private float x1;
    private float y1;
    private float x2;
    private float y2;

    public RotateGestureDetector(OnRotateListener l) {
        this.mListener = l;
    }

    public void onTouchEvent(MotionEvent event) {
        int Action = event.getActionMasked();
        switch (Action) {
            case 5: 
            case 6: {
                if (event.getPointerCount() != 2) break;
                this.mPrevSlope = this.calculateSlope(event);
                break;
            }
            case 2: {
                double prevDegrees;
                if (event.getPointerCount() <= 1) break;
                this.mCurrSlope = this.calculateSlope(event);
                double currDegrees = Math.toDegrees(Math.atan(this.mCurrSlope));
                double deltaSlope = currDegrees - (prevDegrees = Math.toDegrees(Math.atan(this.mPrevSlope)));
                if (Math.abs(deltaSlope) <= 120.0) {
                    this.mListener.onRotate((float)deltaSlope, (this.x2 + this.x1) / 2.0f, (this.y2 + this.y1) / 2.0f);
                }
                this.mPrevSlope = this.mCurrSlope;
                break;
            }
        }
    }

    private float calculateSlope(MotionEvent event) {
        this.x1 = event.getX(0);
        this.y1 = event.getY(0);
        this.x2 = event.getX(1);
        this.y2 = event.getY(1);
        return (this.y2 - this.y1) / (this.x2 - this.x1);
    }
}

