/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Color;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.hitomi.tilibrary.style.IIndexIndicator;
import com.hitomi.tilibrary.transfer.DragCloseGesture;
import com.hitomi.tilibrary.transfer.EmptyThumbState;
import com.hitomi.tilibrary.transfer.LocalThumbState;
import com.hitomi.tilibrary.transfer.RemoteThumbState;
import com.hitomi.tilibrary.transfer.TransferAdapter;
import com.hitomi.tilibrary.transfer.TransferConfig;
import com.hitomi.tilibrary.transfer.TransferState;
import com.hitomi.tilibrary.view.image.TransferImage;
import java.util.HashSet;
import java.util.Set;

class TransferLayout
extends FrameLayout {
    private Context context;
    private TransferImage transImage;
    private TransferConfig transConfig;
    private DragCloseGesture dragCloseGesture;
    private OnLayoutResetListener layoutResetListener;
    private Set<Integer> loadedIndexSet;
    TransferAdapter transAdapter;
    ViewPager transViewPager;
    float alpha;
    private ViewPager.OnPageChangeListener transChangeListener = new ViewPager.SimpleOnPageChangeListener(){

        public void onPageSelected(int position) {
            TransferLayout.this.transConfig.setNowThumbnailIndex(position);
            if (TransferLayout.this.transConfig.isJustLoadHitImage()) {
                TransferLayout.this.loadSourceImageOffset(position, 0);
            } else {
                for (int i = 1; i <= TransferLayout.this.transConfig.getOffscreenPageLimit(); ++i) {
                    TransferLayout.this.loadSourceImageOffset(position, i);
                }
            }
        }
    };
    private TransferAdapter.OnInstantiateItemListener instantListener = new TransferAdapter.OnInstantiateItemListener(){

        @Override
        public void onComplete() {
            TransferLayout.this.transViewPager.addOnPageChangeListener(TransferLayout.this.transChangeListener);
            int position = TransferLayout.this.transConfig.getNowThumbnailIndex();
            if (TransferLayout.this.transConfig.isJustLoadHitImage()) {
                TransferLayout.this.loadSourceImageOffset(position, 0);
            } else {
                TransferLayout.this.loadSourceImageOffset(position, 1);
            }
        }
    };
    TransferImage.OnTransferListener transListener = new TransferImage.OnTransferListener(){

        @Override
        public void onTransferStart(int state, int cate, int stage) {
        }

        @Override
        public void onTransferUpdate(int state, float fraction) {
            TransferLayout.this.alpha = (state == 3 ? TransferLayout.this.alpha : 255.0f) * fraction;
            TransferLayout.this.setBackgroundColor(TransferLayout.this.getBackgroundColorByAlpha(TransferLayout.this.alpha));
        }

        @Override
        public void onTransferComplete(int state, int cate, int stage) {
            if (cate == 100) {
                switch (state) {
                    case 1: {
                        TransferLayout.this.addIndexIndicator();
                        TransferLayout.this.addCustomView();
                        TransferLayout.this.transViewPager.setVisibility(0);
                        TransferLayout.this.removeFromParent((View)TransferLayout.this.transImage);
                        break;
                    }
                    case 2: 
                    case 3: {
                        TransferLayout.this.resetTransfer();
                    }
                }
            } else {
                switch (state) {
                    case 1: {
                        if (stage != 201) break;
                        TransferLayout.this.addIndexIndicator();
                        TransferLayout.this.addCustomView();
                        TransferLayout.this.transViewPager.setVisibility(0);
                        TransferLayout.this.removeFromParent((View)TransferLayout.this.transImage);
                        break;
                    }
                    case 2: {
                        if (stage != 201) break;
                        TransferLayout.this.resetTransfer();
                    }
                }
            }
        }
    };

    TransferLayout(Context context) {
        super(context);
        this.context = context;
        this.loadedIndexSet = new HashSet<Integer>();
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (ev.getPointerCount() == 1 && this.dragCloseGesture != null && this.dragCloseGesture.onInterceptTouchEvent(ev)) {
            return true;
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.dragCloseGesture != null) {
            this.dragCloseGesture.onTouchEvent(event);
        }
        return super.onTouchEvent(event);
    }

    int getBackgroundColorByAlpha(float alpha) {
        int bgColor = this.transConfig.getBackgroundColor();
        return Color.argb((int)Math.round(alpha), (int)Color.red((int)bgColor), (int)Color.green((int)bgColor), (int)Color.blue((int)bgColor));
    }

    private void loadSourceImageOffset(int position, int offset) {
        int left = position - offset;
        int right = position + offset;
        if (!this.loadedIndexSet.contains(position)) {
            this.loadSourceImage(position);
            this.loadedIndexSet.add(position);
        }
        if (left >= 0 && !this.loadedIndexSet.contains(left)) {
            this.loadSourceImage(left);
            this.loadedIndexSet.add(left);
        }
        if (right < this.transConfig.getSourceImageList().size() && !this.loadedIndexSet.contains(right)) {
            this.loadSourceImage(right);
            this.loadedIndexSet.add(right);
        }
    }

    private void loadSourceImage(int position) {
        this.getTransferState(position).transferLoad(position);
    }

    private void resetTransfer() {
        this.loadedIndexSet.clear();
        this.removeIndexIndicator();
        this.removeAllViews();
        this.layoutResetListener.onReset();
    }

    private void createTransferViewPager() {
        this.transAdapter = new TransferAdapter(this, this.transConfig.getSourceImageList().size(), this.transConfig.getNowThumbnailIndex());
        this.transAdapter.setOnInstantListener(this.instantListener);
        this.transViewPager = new ViewPager(this.context);
        this.transViewPager.setVisibility(4);
        this.transViewPager.setOffscreenPageLimit(this.transConfig.getOffscreenPageLimit() + 1);
        this.transViewPager.setAdapter((PagerAdapter)this.transAdapter);
        this.transViewPager.setCurrentItem(this.transConfig.getNowThumbnailIndex());
        this.addView((View)this.transViewPager, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    private void removeFromParent(View view) {
        ViewGroup vg = (ViewGroup)view.getParent();
        if (vg != null) {
            vg.removeView(view);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.transViewPager.removeOnPageChangeListener(this.transChangeListener);
    }

    TransferConfig getTransConfig() {
        return this.transConfig;
    }

    TransferImage getCurrentImage() {
        return this.transAdapter.getImageItem(this.transViewPager.getCurrentItem());
    }

    void show() {
        this.createTransferViewPager();
        int nowThumbnailIndex = this.transConfig.getNowThumbnailIndex();
        TransferState transferState = this.getTransferState(nowThumbnailIndex);
        this.transImage = transferState.createTransferIn(nowThumbnailIndex);
    }

    TransferState getTransferState(int position) {
        TransferState transferState;
        if (!this.transConfig.isThumbnailEmpty()) {
            transferState = new RemoteThumbState(this);
        } else {
            String url = this.transConfig.getSourceImageList().get(position);
            transferState = this.transConfig.getImageLoader().getCache(url) != null ? new LocalThumbState(this) : new EmptyThumbState(this);
        }
        return transferState;
    }

    void bindOnOperationListener(final ImageView imageView, final String imageUri, final int pos) {
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TransferLayout.this.dismiss(pos);
            }
        });
        if (this.transConfig.getLongClickListener() != null) {
            imageView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    TransferLayout.this.transConfig.getLongClickListener().onLongClick(imageView, imageUri, pos);
                    return false;
                }
            });
        }
    }

    void dismiss(int pos) {
        if (this.transImage != null && this.transImage.getState() == 2) {
            return;
        }
        this.transImage = this.getTransferState(pos).transferOut(pos);
        if (this.transImage == null) {
            this.diffusionTransfer(pos);
        } else {
            this.transViewPager.setVisibility(4);
        }
        this.hideIndexIndicator();
    }

    void diffusionTransfer(int pos) {
        this.transImage = this.transAdapter.getImageItem(pos);
        this.transImage.setState(2);
        this.transImage.disable();
        ValueAnimator valueAnimator = new ValueAnimator();
        valueAnimator.setDuration(this.transConfig.getDuration());
        valueAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        PropertyValuesHolder alphaHolder = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{this.alpha, 0.0f});
        PropertyValuesHolder scaleXHolder = PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{1.0f, 1.2f});
        valueAnimator.setValues(new PropertyValuesHolder[]{alphaHolder, scaleXHolder});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float alpha = ((Float)animation.getAnimatedValue("alpha")).floatValue();
                float scale = ((Float)animation.getAnimatedValue("scaleX")).floatValue();
                TransferLayout.this.setBackgroundColor(TransferLayout.this.getBackgroundColorByAlpha(alpha));
                TransferLayout.this.transImage.setAlpha(alpha / 255.0f);
                TransferLayout.this.transImage.setScaleX(scale);
                TransferLayout.this.transImage.setScaleY(scale);
            }
        });
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                TransferLayout.this.resetTransfer();
            }
        });
        valueAnimator.start();
    }

    void apply(TransferConfig config) {
        this.transConfig = config;
        if (this.transConfig.isEnableDragClose()) {
            this.dragCloseGesture = new DragCloseGesture(this);
        }
    }

    void setOnLayoutResetListener(OnLayoutResetListener listener) {
        this.layoutResetListener = listener;
    }

    private void addIndexIndicator() {
        IIndexIndicator indexIndicator = this.transConfig.getIndexIndicator();
        if (indexIndicator != null && this.transConfig.getSourceImageList().size() >= 2) {
            indexIndicator.attach(this);
            indexIndicator.onShow(this.transViewPager);
        }
    }

    private void hideIndexIndicator() {
        IIndexIndicator indexIndicator = this.transConfig.getIndexIndicator();
        if (indexIndicator != null && this.transConfig.getSourceImageList().size() >= 2) {
            indexIndicator.onHide();
        }
    }

    private void addCustomView() {
        View customView = this.transConfig.getCustomView();
        if (customView != null) {
            this.addView(customView);
        }
    }

    private void removeIndexIndicator() {
        IIndexIndicator indexIndicator = this.transConfig.getIndexIndicator();
        if (indexIndicator != null && this.transConfig.getSourceImageList().size() >= 2) {
            indexIndicator.onRemove();
        }
    }

    static interface OnLayoutResetListener {
        public void onReset();
    }
}

