/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.hitomi.tilibrary.loader.ImageLoader;
import com.hitomi.tilibrary.transfer.RemoteThumState;
import com.hitomi.tilibrary.transfer.TransferConfig;
import com.hitomi.tilibrary.transfer.TransferLayout;
import com.hitomi.tilibrary.view.image.TransferImage;
import java.lang.reflect.Field;

abstract class TransferState {
    protected TransferLayout transfer;
    protected Context context;

    TransferState(TransferLayout transfer) {
        this.transfer = transfer;
        this.context = transfer.getContext();
    }

    protected int getTransImageLocalY(int oldY) {
        if (Build.VERSION.SDK_INT > 19) {
            return oldY;
        }
        return oldY - this.getStatusBarHeight();
    }

    protected int getStatusBarHeight() {
        try {
            Class<?> c = Class.forName("com.android.internal.R$dimen");
            Object object = c.newInstance();
            Field field = c.getField("status_bar_height");
            int x = (Integer)field.get(object);
            return this.context.getResources().getDimensionPixelSize(x);
        }
        catch (Exception e) {
            return 0;
        }
    }

    protected int[] getViewLocation(View view) {
        int[] location = new int[2];
        view.getLocationInWindow(location);
        return location;
    }

    @NonNull
    protected TransferImage createTransferImage(ImageView originImage) {
        TransferConfig config = this.transfer.getTransConfig();
        int[] location = this.getViewLocation((View)originImage);
        TransferImage transImage = new TransferImage(this.context);
        transImage.setScaleType(ImageView.ScaleType.FIT_CENTER);
        transImage.setOriginalInfo(location[0], this.getTransImageLocalY(location[1]), originImage.getWidth(), originImage.getHeight());
        transImage.setBackgroundColor(config.getBackgroundColor());
        transImage.setDuration(config.getDuration());
        transImage.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        transImage.setOnTransferListener(this.transfer.getTransListener());
        return transImage;
    }

    protected void transformThumbnail(String imageUrl, TransferImage transImage, boolean in) {
        TransferConfig config = this.transfer.getTransConfig();
        ImageLoader imageLoader = config.getImageLoader();
        if (this instanceof RemoteThumState) {
            if (imageLoader.isLoaded(imageUrl)) {
                this.loadThunbnail(imageUrl, transImage, in);
            } else {
                transImage.setImageDrawable(config.getMissDrawable(this.context));
                if (in) {
                    transImage.transformIn();
                } else {
                    transImage.transformOut();
                }
            }
        } else {
            this.loadThunbnail(imageUrl, transImage, in);
        }
    }

    private void loadThunbnail(String imageUrl, final TransferImage transImage, final boolean in) {
        final TransferConfig config = this.transfer.getTransConfig();
        config.getImageLoader().loadThumbnailAsync(imageUrl, transImage, new ImageLoader.ThumbnailCallback(){

            @Override
            public void onFinish(Drawable drawable) {
                if (drawable == null) {
                    transImage.setImageDrawable(config.getMissDrawable(TransferState.this.context));
                } else {
                    transImage.setImageDrawable(drawable);
                }
                if (in) {
                    transImage.transformIn();
                } else {
                    transImage.transformOut();
                }
            }
        });
    }

    public abstract void prepareTransfer(TransferImage var1, int var2);

    public abstract TransferImage createTransferIn(int var1);

    public abstract void transferLoad(int var1);

    public abstract TransferImage transferOut(int var1);
}

