/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.support.v7.app.AlertDialog;
import android.view.KeyEvent;
import android.view.View;
import com.hitomi.tilibrary.loader.ImageLoader;
import com.hitomi.tilibrary.loader.NoneImageLoader;
import com.hitomi.tilibrary.style.index.CircleIndexIndicator;
import com.hitomi.tilibrary.style.progress.ProgressBarIndicator;
import com.hitomi.tilibrary.transfer.TransferConfig;
import com.hitomi.tilibrary.transfer.TransferLayout;

public class Transferee
implements DialogInterface.OnShowListener,
DialogInterface.OnKeyListener,
TransferLayout.OnLayoutResetListener {
    static volatile Transferee defaultInstance;
    private Context context;
    private Dialog transDialog;
    private TransferLayout transLayout;
    private TransferConfig transConfig;
    private OnTransfereeStateChangeListener transListener;
    private boolean shown;

    private Transferee(Context context) {
        this.context = context;
        this.creatLayout();
        this.createDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Transferee getDefault(Context context) {
        if (defaultInstance != null) return defaultInstance;
        Class<Transferee> clazz = Transferee.class;
        synchronized (Transferee.class) {
            if (defaultInstance != null) return defaultInstance;
            defaultInstance = new Transferee(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defaultInstance;
        }
    }

    private void creatLayout() {
        this.transLayout = new TransferLayout(this.context);
        this.transLayout.setOnLayoutResetListener(this);
    }

    private void createDialog() {
        this.transDialog = new AlertDialog.Builder(this.context, this.getDialogStyle()).setView((View)this.transLayout).create();
        this.transDialog.setOnShowListener((DialogInterface.OnShowListener)this);
        this.transDialog.setOnKeyListener((DialogInterface.OnKeyListener)this);
    }

    private int getDialogStyle() {
        int dialogStyle = Build.VERSION.SDK_INT > 19 ? 0x1030011 : 0x1030010;
        return dialogStyle;
    }

    private void checkConfig() {
        if (this.transConfig.isSourceEmpty()) {
            throw new IllegalArgumentException("the parameter sourceImageList can't be empty");
        }
        if (this.transConfig.getNowThumbnailIndex() >= this.transConfig.getOriginImageList().size()) {
            throw new IllegalArgumentException("the parameter nowThumbnailIndex will generate an IndexOutOfBoundsException error");
        }
        this.transConfig.setNowThumbnailIndex(this.transConfig.getNowThumbnailIndex() < 0 ? 0 : this.transConfig.getNowThumbnailIndex());
        this.transConfig.setOffscreenPageLimit(this.transConfig.getOffscreenPageLimit() <= 0 ? 1 : this.transConfig.getOffscreenPageLimit());
        this.transConfig.setDuration(this.transConfig.getDuration() <= 0L ? 300L : this.transConfig.getDuration());
        this.transConfig.setProgressIndicator(this.transConfig.getProgressIndicator() == null ? new ProgressBarIndicator() : this.transConfig.getProgressIndicator());
        this.transConfig.setIndexIndicator(this.transConfig.getIndexIndicator() == null ? new CircleIndexIndicator() : this.transConfig.getIndexIndicator());
        this.transConfig.setImageLoader(this.transConfig.getImageLoader() == null ? new NoneImageLoader() : this.transConfig.getImageLoader());
    }

    public Transferee apply(TransferConfig config) {
        if (!this.shown) {
            this.transConfig = config;
            this.checkConfig();
            this.transLayout.apply(config);
        }
        return defaultInstance;
    }

    public boolean isShown() {
        return this.shown;
    }

    public void show() {
        if (this.shown) {
            return;
        }
        this.transDialog.show();
        if (this.transListener != null) {
            this.transListener.onShow();
        }
        this.shown = true;
    }

    public void show(OnTransfereeStateChangeListener listener) {
        if (this.shown) {
            return;
        }
        this.transDialog.show();
        this.transListener = listener;
        this.transListener.onShow();
        this.shown = true;
    }

    public void dismiss() {
        if (!this.shown) {
            return;
        }
        this.transLayout.dismiss(this.transConfig.getNowThumbnailIndex());
        this.shown = false;
    }

    public void destroy() {
        defaultInstance = null;
    }

    public static void clear(ImageLoader imageLoader) {
        imageLoader.clearCache();
    }

    public void onShow(DialogInterface dialog) {
        this.transLayout.show();
    }

    @Override
    public void onReset() {
        this.transDialog.dismiss();
        if (this.transListener != null) {
            this.transListener.onDismiss();
        }
        this.shown = false;
    }

    public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
        if (keyCode == 4 && event.getAction() == 1 && !event.isCanceled()) {
            this.dismiss();
        }
        return true;
    }

    public void setOnTransfereeStateChangeListener(OnTransfereeStateChangeListener listener) {
        this.transListener = listener;
    }

    public static interface OnTransfereeStateChangeListener {
        public void onShow();

        public void onDismiss();
    }
}

