/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.hitomi.tilibrary.style.IIndexIndicator;
import com.hitomi.tilibrary.transfer.EmptyThumState;
import com.hitomi.tilibrary.transfer.LocalThumState;
import com.hitomi.tilibrary.transfer.RemoteThumState;
import com.hitomi.tilibrary.transfer.TransferAdapter;
import com.hitomi.tilibrary.transfer.TransferConfig;
import com.hitomi.tilibrary.transfer.TransferState;
import com.hitomi.tilibrary.view.image.TransferImage;
import java.util.HashSet;
import java.util.Set;

class TransferLayout
extends FrameLayout {
    private Context context;
    private TransferImage transImage;
    private ViewPager transViewPager;
    private TransferAdapter transAdapter;
    private TransferConfig transConfig;
    private OnLayoutResetListener layoutResetListener;
    private Set<Integer> loadedIndexSet;
    private ViewPager.OnPageChangeListener transChangeListener = new ViewPager.SimpleOnPageChangeListener(){

        public void onPageSelected(int position) {
            TransferLayout.this.transConfig.setNowThumbnailIndex(position);
            if (TransferLayout.this.transConfig.isJustLoadHitImage()) {
                TransferLayout.this.loadSourceImageOffset(position, 0);
            } else {
                for (int i = 1; i <= TransferLayout.this.transConfig.getOffscreenPageLimit(); ++i) {
                    TransferLayout.this.loadSourceImageOffset(position, i);
                }
            }
        }
    };
    private TransferAdapter.OnInstantiateItemListener instantListener = new TransferAdapter.OnInstantiateItemListener(){

        @Override
        public void onComplete() {
            TransferLayout.this.transViewPager.addOnPageChangeListener(TransferLayout.this.transChangeListener);
            int position = TransferLayout.this.transConfig.getNowThumbnailIndex();
            if (TransferLayout.this.transConfig.isJustLoadHitImage()) {
                TransferLayout.this.loadSourceImageOffset(position, 0);
            } else {
                TransferLayout.this.loadSourceImageOffset(position, 1);
            }
        }
    };
    private TransferImage.OnTransferListener transListener = new TransferImage.OnTransferListener(){

        @Override
        public void onTransferComplete(int state, int cate, int stage) {
            if (cate == 100) {
                switch (state) {
                    case 1: {
                        TransferLayout.this.addIndexIndicator();
                        TransferLayout.this.transViewPager.setVisibility(0);
                        TransferLayout.this.removeFromParent((View)TransferLayout.this.transImage);
                        break;
                    }
                    case 2: {
                        TransferLayout.this.resetTransfer();
                    }
                }
            } else {
                switch (state) {
                    case 1: {
                        if (stage != 201) break;
                        TransferLayout.this.addIndexIndicator();
                        TransferLayout.this.transViewPager.setVisibility(0);
                        TransferLayout.this.removeFromParent((View)TransferLayout.this.transImage);
                        break;
                    }
                    case 2: {
                        if (stage != 201) break;
                        TransferLayout.this.resetTransfer();
                    }
                }
            }
        }
    };

    TransferLayout(Context context) {
        super(context);
        this.context = context;
        this.loadedIndexSet = new HashSet<Integer>();
    }

    private void loadSourceImageOffset(int position, int offset) {
        int left = position - offset;
        int right = position + offset;
        if (!this.loadedIndexSet.contains(position)) {
            this.loadSourceImage(position);
            this.loadedIndexSet.add(position);
        }
        if (left >= 0 && !this.loadedIndexSet.contains(left)) {
            this.loadSourceImage(left);
            this.loadedIndexSet.add(left);
        }
        if (right < this.transConfig.getSourceImageList().size() && !this.loadedIndexSet.contains(right)) {
            this.loadSourceImage(right);
            this.loadedIndexSet.add(right);
        }
    }

    private void loadSourceImage(int position) {
        this.getTransferState(position).transferLoad(position);
    }

    private void resetTransfer() {
        this.loadedIndexSet.clear();
        this.removeIndexIndicator();
        this.removeAllViews();
        this.layoutResetListener.onReset();
    }

    private void createTransferViewPager() {
        this.transAdapter = new TransferAdapter(this, this.transConfig.getSourceImageList().size(), this.transConfig.getNowThumbnailIndex());
        this.transAdapter.setOnInstantListener(this.instantListener);
        this.transViewPager = new ViewPager(this.context);
        this.transViewPager.setVisibility(4);
        this.transViewPager.setOffscreenPageLimit(this.transConfig.getOffscreenPageLimit() + 1);
        this.transViewPager.setAdapter((PagerAdapter)this.transAdapter);
        this.transViewPager.setCurrentItem(this.transConfig.getNowThumbnailIndex());
        this.addView((View)this.transViewPager, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    private void removeFromParent(View view) {
        ViewGroup vg = (ViewGroup)view.getParent();
        if (vg != null) {
            vg.removeView(view);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.transViewPager.removeOnPageChangeListener(this.transChangeListener);
    }

    public TransferAdapter getTransAdapter() {
        return this.transAdapter;
    }

    public TransferConfig getTransConfig() {
        return this.transConfig;
    }

    public TransferImage.OnTransferListener getTransListener() {
        return this.transListener;
    }

    public void show() {
        this.createTransferViewPager();
        int nowThumbnailIndex = this.transConfig.getNowThumbnailIndex();
        TransferState transferState = this.getTransferState(nowThumbnailIndex);
        this.transImage = transferState.createTransferIn(nowThumbnailIndex);
    }

    TransferState getTransferState(int position) {
        TransferState transferState;
        if (!this.transConfig.isThumbnailEmpty()) {
            transferState = new RemoteThumState(this);
        } else {
            String url = this.transConfig.getSourceImageList().get(position);
            transferState = this.transConfig.getImageLoader().isLoaded(url) ? new LocalThumState(this) : new EmptyThumState(this);
        }
        return transferState;
    }

    public void bindOnDismissListener(ImageView imageView, final int pos) {
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TransferLayout.this.dismiss(pos);
            }
        });
    }

    public void dismiss(int pos) {
        if (this.transImage != null && this.transImage.getState() == 2) {
            return;
        }
        this.hideIndexIndicator();
        this.transImage = this.getTransferState(pos).transferOut(pos);
        if (this.transImage == null) {
            this.diffusionTransfer(pos);
        }
    }

    private void diffusionTransfer(int pos) {
        final TransferImage targetImage = this.transAdapter.getImageItem(pos);
        ValueAnimator valueAnimator = new ValueAnimator();
        valueAnimator.setDuration(this.transConfig.getDuration());
        valueAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        PropertyValuesHolder alphaHolder = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{1.0f, 0.0f});
        PropertyValuesHolder scaleXHolder = PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{1.0f, 1.2f});
        valueAnimator.setValues(new PropertyValuesHolder[]{alphaHolder, scaleXHolder});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float alpha = ((Float)animation.getAnimatedValue("alpha")).floatValue();
                float scale = ((Float)animation.getAnimatedValue("scaleX")).floatValue();
                targetImage.setAlpha(alpha);
                targetImage.setScaleX(scale);
                targetImage.setScaleY(scale);
            }
        });
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                TransferLayout.this.resetTransfer();
            }
        });
        valueAnimator.start();
    }

    public void apply(TransferConfig config) {
        this.transConfig = config;
    }

    public void setOnLayoutResetListener(OnLayoutResetListener listener) {
        this.layoutResetListener = listener;
    }

    private void addIndexIndicator() {
        IIndexIndicator indexIndicator = this.transConfig.getIndexIndicator();
        if (indexIndicator != null && this.transConfig.getSourceImageList().size() >= 2) {
            indexIndicator.attach(this);
            indexIndicator.onShow(this.transViewPager);
        }
    }

    private void hideIndexIndicator() {
        IIndexIndicator indexIndicator = this.transConfig.getIndexIndicator();
        if (indexIndicator != null && this.transConfig.getSourceImageList().size() >= 2) {
            indexIndicator.onHide();
        }
    }

    private void removeIndexIndicator() {
        IIndexIndicator indexIndicator = this.transConfig.getIndexIndicator();
        if (indexIndicator != null && this.transConfig.getSourceImageList().size() >= 2) {
            indexIndicator.onRemove();
        }
    }

    static interface OnLayoutResetListener {
        public void onReset();
    }
}

