/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.view.PagerAdapter;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.hitomi.tilibrary.transfer.TransferConfig;
import com.hitomi.tilibrary.transfer.TransferLayout;
import com.hitomi.tilibrary.view.image.TransferImage;

class TransferAdapter
extends PagerAdapter {
    private TransferLayout transfer;
    private int showIndex;
    private int imageSize;
    private OnInstantiateItemListener onInstantListener;
    private SparseArray<FrameLayout> containLayoutArray;

    TransferAdapter(TransferLayout transfer, int imageSize, int nowThumbnailIndex) {
        this.transfer = transfer;
        this.imageSize = imageSize;
        this.showIndex = nowThumbnailIndex + 1 == imageSize ? nowThumbnailIndex - 1 : nowThumbnailIndex + 1;
        this.showIndex = this.showIndex < 0 ? 0 : this.showIndex;
        this.containLayoutArray = new SparseArray();
    }

    public int getCount() {
        return this.imageSize;
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
    }

    TransferImage getImageItem(int position) {
        TransferImage transImage = null;
        FrameLayout parentLayout = (FrameLayout)this.containLayoutArray.get(position);
        if (parentLayout != null) {
            int childCount = parentLayout.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View view = parentLayout.getChildAt(i);
                if (!(view instanceof ImageView)) continue;
                transImage = (TransferImage)view;
                break;
            }
        }
        return transImage;
    }

    FrameLayout getParentItem(int position) {
        return (FrameLayout)this.containLayoutArray.get(position);
    }

    void setOnInstantListener(OnInstantiateItemListener listener) {
        this.onInstantListener = listener;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        FrameLayout parentLayout = (FrameLayout)this.containLayoutArray.get(position);
        if (parentLayout == null) {
            parentLayout = this.newParentLayout(container, position);
            this.containLayoutArray.put(position, (Object)parentLayout);
            if (position == this.showIndex && this.onInstantListener != null) {
                this.onInstantListener.onComplete();
            }
        }
        container.addView((View)parentLayout);
        return parentLayout;
    }

    @NonNull
    private FrameLayout newParentLayout(ViewGroup container, int pos) {
        Context context = container.getContext();
        TransferConfig config = this.transfer.getTransConfig();
        TransferImage imageView = new TransferImage(context);
        imageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
        imageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        imageView.setDuration(config.getDuration());
        FrameLayout parentLayout = new FrameLayout(context);
        parentLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        parentLayout.addView((View)imageView);
        if (config.isJustLoadHitImage()) {
            this.transfer.getTransferState(pos).prepareTransfer(imageView, pos);
        }
        return parentLayout;
    }

    static interface OnInstantiateItemListener {
        public void onComplete();
    }
}

