/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import com.hitomi.tilibrary.loader.ImageLoader;
import com.hitomi.tilibrary.style.IProgressIndicator;
import com.hitomi.tilibrary.transfer.TransferAdapter;
import com.hitomi.tilibrary.transfer.TransferConfig;
import com.hitomi.tilibrary.transfer.TransferLayout;
import com.hitomi.tilibrary.transfer.TransferState;
import com.hitomi.tilibrary.view.image.TransferImage;
import java.util.List;

class RemoteThumState
extends TransferState {
    RemoteThumState(TransferLayout transfer) {
        super(transfer);
    }

    @Override
    public void prepareTransfer(final TransferImage transImage, int position) {
        String imgUrl;
        final TransferConfig config = this.transfer.getTransConfig();
        ImageLoader imageLoader = config.getImageLoader();
        if (imageLoader.isLoaded(imgUrl = config.getThumbnailImageList().get(position))) {
            imageLoader.loadThumbnailAsync(imgUrl, transImage, new ImageLoader.ThumbnailCallback(){

                @Override
                public void onFinish(Drawable drawable) {
                    transImage.setImageDrawable(drawable == null ? config.getMissDrawable(RemoteThumState.this.context) : drawable);
                }
            });
        } else {
            transImage.setImageDrawable(config.getMissDrawable(this.context));
        }
    }

    @Override
    public TransferImage createTransferIn(int position) {
        TransferConfig config = this.transfer.getTransConfig();
        TransferImage transImage = this.createTransferImage(config.getOriginImageList().get(position));
        this.transformThumbnail(config.getThumbnailImageList().get(position), transImage, true);
        this.transfer.addView((View)transImage, 1);
        return transImage;
    }

    @Override
    public void transferLoad(final int position) {
        TransferAdapter adapter = this.transfer.getTransAdapter();
        final TransferConfig config = this.transfer.getTransConfig();
        final TransferImage targetImage = this.transfer.getTransAdapter().getImageItem(position);
        ImageLoader imageLoader = config.getImageLoader();
        final IProgressIndicator progressIndicator = config.getProgressIndicator();
        progressIndicator.attach(position, adapter.getParentItem(position));
        if (config.isJustLoadHitImage()) {
            this.loadSourceImage(targetImage.getDrawable(), position, targetImage, progressIndicator);
        } else {
            String thumUrl = config.getThumbnailImageList().get(position);
            if (imageLoader.isLoaded(thumUrl)) {
                imageLoader.loadThumbnailAsync(thumUrl, targetImage, new ImageLoader.ThumbnailCallback(){

                    @Override
                    public void onFinish(Drawable drawable) {
                        if (drawable == null) {
                            drawable = config.getMissDrawable(RemoteThumState.this.context);
                        }
                        RemoteThumState.this.loadSourceImage(drawable, position, targetImage, progressIndicator);
                    }
                });
            } else {
                this.loadSourceImage(config.getMissDrawable(this.context), position, targetImage, progressIndicator);
            }
        }
    }

    private void loadSourceImage(Drawable drawable, final int position, final TransferImage targetImage, final IProgressIndicator progressIndicator) {
        final TransferConfig config = this.transfer.getTransConfig();
        config.getImageLoader().showSourceImage(config.getSourceImageList().get(position), targetImage, drawable, new ImageLoader.SourceCallback(){

            @Override
            public void onStart() {
                progressIndicator.onStart(position);
            }

            @Override
            public void onProgress(int progress) {
                progressIndicator.onProgress(position, progress);
            }

            @Override
            public void onFinish() {
            }

            @Override
            public void onDelivered(int status) {
                switch (status) {
                    case 1: {
                        progressIndicator.onFinish(position);
                        targetImage.enable();
                        RemoteThumState.this.transfer.bindOnDismissListener(targetImage, position);
                        break;
                    }
                    case 0: {
                        targetImage.setImageDrawable(config.getErrorDrawable(RemoteThumState.this.context));
                    }
                }
            }
        });
    }

    @Override
    public TransferImage transferOut(int position) {
        TransferImage transImage = null;
        TransferConfig config = this.transfer.getTransConfig();
        List<ImageView> originImageList = config.getOriginImageList();
        if (position < originImageList.size()) {
            transImage = this.createTransferImage(originImageList.get(position));
            this.transformThumbnail(config.getThumbnailImageList().get(position), transImage, false);
            this.transfer.addView((View)transImage, 1);
        }
        return transImage;
    }
}

