/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.view.video;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.TextureView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.source.LoopingMediaSource;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.video.VideoListener;
import com.hitomi.tilibrary.view.video.AdaptiveTextureView;
import com.hitomi.tilibrary.view.video.source.ExoSourceManager;
import java.io.File;

public class ExoVideoView
extends AdaptiveTextureView {
    private static final String TAG = "ExoVideoView";
    public static final String CACHE_DIR = "TransExo";
    private String url;
    private boolean requestLayout;
    private boolean invalidate;
    private SimpleExoPlayer exoPlayer;
    private ExoSourceManager exoSourceManager;
    private File cacheFile;
    private VideoStateChangeListener videoStateChangeListener;

    public ExoVideoView(@NonNull Context context) {
        this(context, null);
    }

    public ExoVideoView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ExoVideoView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setAlpha(0.0f);
        this.cacheFile = this.getCacheDir();
        this.exoSourceManager = ExoSourceManager.newInstance(context, null);
        this.newExoPlayer(context);
    }

    private void newExoPlayer(@NonNull Context context) {
        this.exoPlayer = ExoPlayerFactory.newSimpleInstance((Context)context);
        this.exoPlayer.setVideoTextureView((TextureView)this);
        this.exoPlayer.addVideoListener(new VideoListener(){

            public void onVideoSizeChanged(int width, int height, int unAppliedRotationDegrees, float pixelWidthHeightRatio) {
                if (ExoVideoView.this.currentVideoWidth != width && ExoVideoView.this.currentVideoHeight != height) {
                    Log.e((String)ExoVideoView.TAG, (String)"ExoVideoView.invoke()");
                    ExoVideoView.this.currentVideoWidth = width;
                    ExoVideoView.this.currentVideoHeight = height;
                    ExoVideoView.this.requestLayout();
                    ExoVideoView.this.requestLayout = true;
                }
            }
        });
        this.exoPlayer.addListener(new Player.EventListener(){

            public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
                if (2 == playbackState) {
                    if (ExoVideoView.this.videoStateChangeListener != null) {
                        ExoVideoView.this.videoStateChangeListener.onVideoBuffering();
                    }
                } else if (3 == playbackState && ExoVideoView.this.videoStateChangeListener != null) {
                    ExoVideoView.this.videoStateChangeListener.onVideoReady();
                }
            }
        });
        this.invalidate = false;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.requestLayout) {
            this.requestLayout = false;
            Log.e((String)TAG, (String)"ExoVideoView.onVideoRendered()");
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ExoVideoView.this.setAlpha(1.0f);
                    if (ExoVideoView.this.videoStateChangeListener != null) {
                        ExoVideoView.this.videoStateChangeListener.onVideoRendered();
                    }
                }
            }, 15L);
            this.setAlpha(1.0f);
        }
    }

    private File getCacheDir() {
        File cacheDir = new File(this.getContext().getCacheDir(), CACHE_DIR);
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        return cacheDir;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.destroy();
    }

    public void setSource(String url, boolean autoPlay) {
        this.url = url;
        if (!this.exoPlayer.isLoading()) {
            MediaSource videoSource = this.exoSourceManager.getMediaSource(url, true, true, true, this.cacheFile, null);
            this.exoPlayer.prepare((MediaSource)new LoopingMediaSource(videoSource));
        }
        this.exoPlayer.setPlayWhenReady(autoPlay);
    }

    public void play() {
        if (this.invalidate) {
            this.newExoPlayer(this.getContext());
            this.setSource(this.url, true);
        } else {
            this.exoPlayer.setPlayWhenReady(true);
        }
    }

    public void pause() {
        this.exoPlayer.setPlayWhenReady(false);
    }

    public void resume() {
        this.exoPlayer.setPlayWhenReady(true);
    }

    public void reset() {
        this.exoPlayer.seekTo(0L);
        this.exoPlayer.setPlayWhenReady(false);
    }

    public void destroy() {
        this.invalidate = true;
        this.exoPlayer.release();
    }

    public void setVideoStateChangeListener(VideoStateChangeListener listener) {
        this.videoStateChangeListener = listener;
    }

    public static interface VideoStateChangeListener {
        public void onVideoBuffering();

        public void onVideoReady();

        public void onVideoRendered();
    }
}

