/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.view.image;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.hitomi.tilibrary.view.image.PhotoView;

public class TransferImage
extends PhotoView {
    public static final int STATE_TRANS_NORMAL = 0;
    public static final int STATE_TRANS_IN = 1;
    public static final int STATE_TRANS_OUT = 2;
    public static final int STATE_TRANS_SPEC_OUT = 3;
    public static final int STATE_TRANS_CLIP = 4;
    public static final int CATE_ANIMA_TOGETHER = 100;
    public static final int CATE_ANIMA_APART = 200;
    public static final int STAGE_TRANSLATE = 201;
    public static final int STAGE_SCALE = 202;
    private int state = 0;
    private int cate = 100;
    private int stage = 201;
    private int originalWidth;
    private int originalHeight;
    private int originalLocationX;
    private int originalLocationY;
    private long duration = 300L;
    private boolean transformStart = false;
    private Paint paint;
    private Matrix transMatrix;
    private RectF specSizeF;
    private float specScale;
    private Transform transform;
    private OnTransferListener transformListener;

    public TransferImage(Context context) {
        this(context, null);
    }

    public TransferImage(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TransferImage(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.transMatrix = new Matrix();
        this.paint = new Paint();
        this.paint.setAlpha(0);
    }

    public void setOriginalInfo(int locationX, int locationY, int width, int height) {
        this.originalLocationX = locationX;
        this.originalLocationY = locationY;
        this.originalWidth = width;
        this.originalHeight = height;
    }

    public void setOriginalInfo(Drawable targetDrawable, int originWidth, int originHeight, int width, int height) {
        Rect rect = this.getClipOriginalInfo(targetDrawable, originWidth, originHeight, width, height);
        this.originalLocationX = rect.left;
        this.originalLocationY = rect.top;
        this.originalWidth = rect.width();
        this.originalHeight = rect.height();
    }

    private Rect getClipOriginalInfo(Drawable targetDrawable, int originWidth, int originHeight, int width, int height) {
        Rect rect = new Rect();
        float xSScale = (float)originWidth / (float)targetDrawable.getIntrinsicWidth();
        float ySScale = (float)originHeight / (float)targetDrawable.getIntrinsicHeight();
        float endScale = Math.max(xSScale, ySScale);
        float drawableEndWidth = (float)targetDrawable.getIntrinsicWidth() * endScale;
        float drawableEndHeight = (float)targetDrawable.getIntrinsicHeight() * endScale;
        rect.left = (int)(((float)width - drawableEndWidth) / 2.0f);
        rect.top = (int)(((float)height - drawableEndHeight) / 2.0f);
        rect.right = (int)drawableEndWidth + rect.left;
        rect.bottom = (int)drawableEndHeight + rect.top;
        return rect;
    }

    public void transClip() {
        this.state = 4;
        this.transformStart = true;
    }

    public void transformIn() {
        this.cate = 100;
        this.state = 1;
        this.transformStart = true;
        this.invalidate();
    }

    public void transformIn(int animaStage) {
        this.cate = 200;
        this.state = 1;
        this.stage = animaStage;
        this.transformStart = true;
        this.invalidate();
    }

    public void transformOut() {
        this.cate = 100;
        this.state = 2;
        this.transformStart = true;
        this.invalidate();
    }

    public void transformSpecOut(RectF specSizeF, float scale) {
        this.cate = 100;
        this.state = 3;
        this.transformStart = true;
        this.specSizeF = specSizeF;
        this.specScale = scale;
        this.invalidate();
    }

    public void transformOut(int animaStage) {
        this.cate = 200;
        this.state = 2;
        this.stage = animaStage;
        this.transformStart = true;
        this.invalidate();
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public float[] getAfterTransferSize() {
        float[] deformedSize = new float[]{0.0f, 0.0f};
        Drawable transDrawable = this.getDrawable();
        if (transDrawable == null) {
            return deformedSize;
        }
        float xEScale = (float)this.getWidth() / (float)transDrawable.getIntrinsicWidth();
        float yEScale = (float)this.getHeight() / (float)transDrawable.getIntrinsicHeight();
        float minScale = Math.min(xEScale, yEScale);
        deformedSize[0] = (float)transDrawable.getIntrinsicWidth() * minScale;
        deformedSize[1] = (float)transDrawable.getIntrinsicHeight() * minScale;
        return deformedSize;
    }

    public float[] getBeforeTransferSize(int originWidth, int originHeight) {
        float[] stableSize = new float[]{0.0f, 0.0f};
        Drawable transDrawable = this.getDrawable();
        if (transDrawable == null) {
            return stableSize;
        }
        float xSScale = (float)originWidth / (float)transDrawable.getIntrinsicWidth();
        float ySScale = (float)originHeight / (float)transDrawable.getIntrinsicHeight();
        float maxScale = Math.max(xSScale, ySScale);
        stableSize[0] = (float)transDrawable.getIntrinsicWidth() * maxScale;
        stableSize[1] = (float)transDrawable.getIntrinsicHeight() * maxScale;
        return stableSize;
    }

    private void initTransform() {
        float startScale;
        Drawable transDrawable = this.getDrawable();
        if (transDrawable == null) {
            return;
        }
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        this.transform = new Transform();
        float xSScale = (float)this.originalWidth / (float)transDrawable.getIntrinsicWidth();
        float ySScale = (float)this.originalHeight / (float)transDrawable.getIntrinsicHeight();
        this.transform.startScale = startScale = Math.max(xSScale, ySScale);
        float xEScale = (float)this.getWidth() / (float)transDrawable.getIntrinsicWidth();
        float yEScale = (float)this.getHeight() / (float)transDrawable.getIntrinsicHeight();
        float endScale = Math.min(xEScale, yEScale);
        endScale = this.state == 3 ? endScale * this.specScale : endScale;
        this.transform.endScale = this.cate == 200 && this.stage == 201 ? startScale : endScale;
        this.transform.startRect = new LocationSizeF();
        this.transform.startRect.left = this.originalLocationX;
        this.transform.startRect.top = this.originalLocationY;
        this.transform.startRect.width = this.originalWidth;
        this.transform.startRect.height = this.originalHeight;
        this.transform.endRect = new LocationSizeF();
        float bitmapEndWidth = (float)transDrawable.getIntrinsicWidth() * this.transform.endScale;
        float bitmapEndHeight = (float)transDrawable.getIntrinsicHeight() * this.transform.endScale;
        if (this.state == 3) {
            this.transform.endRect.left = this.specSizeF.left;
            this.transform.endRect.top = this.specSizeF.top;
            this.transform.endRect.width = this.specSizeF.width();
            this.transform.endRect.height = this.specSizeF.height();
        } else {
            this.transform.endRect.left = ((float)this.getWidth() - bitmapEndWidth) / 2.0f;
            this.transform.endRect.top = ((float)this.getHeight() - bitmapEndHeight) / 2.0f;
            this.transform.endRect.width = bitmapEndWidth;
            this.transform.endRect.height = bitmapEndHeight;
        }
        this.transform.rect = new LocationSizeF();
    }

    private void calcBmpMatrix() {
        Drawable transDrawable = this.getDrawable();
        if (transDrawable == null || this.transform == null) {
            return;
        }
        this.transMatrix.setScale(this.transform.scale, this.transform.scale);
        this.transMatrix.postTranslate(-(this.transform.scale * (float)transDrawable.getIntrinsicWidth() / 2.0f - this.transform.rect.width / 2.0f), -(this.transform.scale * (float)transDrawable.getIntrinsicHeight() / 2.0f - this.transform.rect.height / 2.0f));
    }

    protected void onDraw(Canvas canvas) {
        if (this.getDrawable() == null) {
            return;
        }
        if (this.state != 0) {
            if (this.transformStart) {
                this.initTransform();
            }
            if (this.transform == null) {
                super.onDraw(canvas);
                return;
            }
            if (this.transformStart) {
                switch (this.state) {
                    case 1: {
                        this.transform.initStartIn();
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.transform.initStartOut();
                        break;
                    }
                    case 4: {
                        this.transform.initStartClip();
                    }
                }
            }
            canvas.drawPaint(this.paint);
            int saveCount = canvas.getSaveCount();
            canvas.save();
            this.calcBmpMatrix();
            canvas.translate(this.transform.rect.left, this.transform.rect.top);
            canvas.clipRect(0.0f, 0.0f, this.transform.rect.width, this.transform.rect.height);
            canvas.concat(this.transMatrix);
            this.getDrawable().draw(canvas);
            canvas.restoreToCount(saveCount);
            if (this.transformStart && this.state != 4) {
                this.transformStart = false;
                switch (this.cate) {
                    case 100: {
                        this.startTogetherTrans();
                        break;
                    }
                    case 200: {
                        this.startApartTrans();
                    }
                }
            }
        } else {
            canvas.drawPaint(this.paint);
            super.onDraw(canvas);
        }
    }

    private void startApartTrans() {
        if (this.transform == null) {
            return;
        }
        ValueAnimator valueAnimator = new ValueAnimator();
        valueAnimator.setDuration(this.duration);
        valueAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        if (this.stage == 201) {
            PropertyValuesHolder leftHolder = PropertyValuesHolder.ofFloat((String)"left", (float[])new float[]{this.transform.startRect.left, this.transform.endRect.left});
            PropertyValuesHolder topHolder = PropertyValuesHolder.ofFloat((String)"top", (float[])new float[]{this.transform.startRect.top, this.transform.endRect.top});
            PropertyValuesHolder widthHolder = PropertyValuesHolder.ofFloat((String)"width", (float[])new float[]{this.transform.startRect.width, this.transform.endRect.width});
            PropertyValuesHolder heightHolder = PropertyValuesHolder.ofFloat((String)"height", (float[])new float[]{this.transform.startRect.height, this.transform.endRect.height});
            valueAnimator.setValues(new PropertyValuesHolder[]{leftHolder, topHolder, widthHolder, heightHolder});
            valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public synchronized void onAnimationUpdate(ValueAnimator animation) {
                    if (TransferImage.this.transformListener != null) {
                        TransferImage.this.transformListener.onTransferUpdate(TransferImage.this.state, animation.getAnimatedFraction());
                    }
                    ((TransferImage)TransferImage.this).transform.rect.left = ((Float)animation.getAnimatedValue("left")).floatValue();
                    ((TransferImage)TransferImage.this).transform.rect.top = ((Float)animation.getAnimatedValue("top")).floatValue();
                    ((TransferImage)TransferImage.this).transform.rect.width = ((Float)animation.getAnimatedValue("width")).floatValue();
                    ((TransferImage)TransferImage.this).transform.rect.height = ((Float)animation.getAnimatedValue("height")).floatValue();
                    TransferImage.this.invalidate();
                }
            });
        } else {
            PropertyValuesHolder leftHolder = PropertyValuesHolder.ofFloat((String)"left", (float[])new float[]{this.transform.startRect.left, this.transform.endRect.left});
            PropertyValuesHolder topHolder = PropertyValuesHolder.ofFloat((String)"top", (float[])new float[]{this.transform.startRect.top, this.transform.endRect.top});
            PropertyValuesHolder widthHolder = PropertyValuesHolder.ofFloat((String)"width", (float[])new float[]{this.transform.startRect.width, this.transform.endRect.width});
            PropertyValuesHolder heightHolder = PropertyValuesHolder.ofFloat((String)"height", (float[])new float[]{this.transform.startRect.height, this.transform.endRect.height});
            PropertyValuesHolder scaleHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{this.transform.startScale, this.transform.endScale});
            valueAnimator.setValues(new PropertyValuesHolder[]{scaleHolder, leftHolder, topHolder, widthHolder, heightHolder});
            valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public synchronized void onAnimationUpdate(ValueAnimator animation) {
                    ((TransferImage)TransferImage.this).transform.rect.left = ((Float)animation.getAnimatedValue("left")).floatValue();
                    ((TransferImage)TransferImage.this).transform.rect.top = ((Float)animation.getAnimatedValue("top")).floatValue();
                    ((TransferImage)TransferImage.this).transform.rect.width = ((Float)animation.getAnimatedValue("width")).floatValue();
                    ((TransferImage)TransferImage.this).transform.rect.height = ((Float)animation.getAnimatedValue("height")).floatValue();
                    ((TransferImage)TransferImage.this).transform.scale = ((Float)animation.getAnimatedValue("scale")).floatValue();
                    TransferImage.this.invalidate();
                }
            });
        }
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                if (TransferImage.this.transformListener != null) {
                    TransferImage.this.transformListener.onTransferStart(TransferImage.this.state, TransferImage.this.cate, TransferImage.this.stage);
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (TransferImage.this.stage == 201) {
                    TransferImage.this.originalLocationX = (int)((TransferImage)TransferImage.this).transform.endRect.left;
                    TransferImage.this.originalLocationY = (int)((TransferImage)TransferImage.this).transform.endRect.top;
                    TransferImage.this.originalWidth = (int)((TransferImage)TransferImage.this).transform.endRect.width;
                    TransferImage.this.originalHeight = (int)((TransferImage)TransferImage.this).transform.endRect.height;
                }
                if (TransferImage.this.state == 1 && TransferImage.this.stage == 202) {
                    TransferImage.this.state = 0;
                }
                if (TransferImage.this.transformListener != null) {
                    TransferImage.this.transformListener.onTransferComplete(TransferImage.this.state, TransferImage.this.cate, TransferImage.this.stage);
                }
            }
        });
        if (this.state == 1) {
            valueAnimator.start();
        } else {
            valueAnimator.reverse();
        }
    }

    private void startTogetherTrans() {
        if (this.transform == null) {
            return;
        }
        ValueAnimator valueAnimator = new ValueAnimator();
        valueAnimator.setDuration(this.duration);
        valueAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        PropertyValuesHolder scaleHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{this.transform.startScale, this.transform.endScale});
        PropertyValuesHolder leftHolder = PropertyValuesHolder.ofFloat((String)"left", (float[])new float[]{this.transform.startRect.left, this.transform.endRect.left});
        PropertyValuesHolder topHolder = PropertyValuesHolder.ofFloat((String)"top", (float[])new float[]{this.transform.startRect.top, this.transform.endRect.top});
        PropertyValuesHolder widthHolder = PropertyValuesHolder.ofFloat((String)"width", (float[])new float[]{this.transform.startRect.width, this.transform.endRect.width});
        PropertyValuesHolder heightHolder = PropertyValuesHolder.ofFloat((String)"height", (float[])new float[]{this.transform.startRect.height, this.transform.endRect.height});
        valueAnimator.setValues(new PropertyValuesHolder[]{scaleHolder, leftHolder, topHolder, widthHolder, heightHolder});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public synchronized void onAnimationUpdate(ValueAnimator animation) {
                if (TransferImage.this.transformListener != null) {
                    TransferImage.this.transformListener.onTransferUpdate(TransferImage.this.state, animation.getAnimatedFraction());
                }
                ((TransferImage)TransferImage.this).transform.scale = ((Float)animation.getAnimatedValue("scale")).floatValue();
                ((TransferImage)TransferImage.this).transform.rect.left = ((Float)animation.getAnimatedValue("left")).floatValue();
                ((TransferImage)TransferImage.this).transform.rect.top = ((Float)animation.getAnimatedValue("top")).floatValue();
                ((TransferImage)TransferImage.this).transform.rect.width = ((Float)animation.getAnimatedValue("width")).floatValue();
                ((TransferImage)TransferImage.this).transform.rect.height = ((Float)animation.getAnimatedValue("height")).floatValue();
                TransferImage.this.invalidate();
            }
        });
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                if (TransferImage.this.transformListener != null) {
                    TransferImage.this.transformListener.onTransferStart(TransferImage.this.state, TransferImage.this.cate, TransferImage.this.stage);
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (TransferImage.this.transformListener != null) {
                    TransferImage.this.transformListener.onTransferComplete(TransferImage.this.state, TransferImage.this.cate, TransferImage.this.stage);
                }
                if (TransferImage.this.state == 1) {
                    TransferImage.this.state = 0;
                }
            }
        });
        if (this.state == 1) {
            valueAnimator.start();
        } else {
            valueAnimator.reverse();
        }
    }

    public void setOnTransferListener(OnTransferListener listener) {
        this.transformListener = listener;
    }

    private class LocationSizeF
    implements Cloneable {
        float left;
        float top;
        float width;
        float height;

        private LocationSizeF() {
        }

        public String toString() {
            return "[left:" + this.left + " top:" + this.top + " width:" + this.width + " height:" + this.height + "]";
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    private class Transform {
        float startScale;
        float endScale;
        float scale;
        LocationSizeF startRect;
        LocationSizeF endRect;
        LocationSizeF rect;

        private Transform() {
        }

        void initStartIn() {
            this.scale = this.startScale;
            try {
                this.rect = (LocationSizeF)this.startRect.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }

        void initStartOut() {
            this.scale = this.endScale;
            try {
                this.rect = (LocationSizeF)this.endRect.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }

        void initStartClip() {
            this.scale = this.startScale;
            try {
                this.rect = (LocationSizeF)this.endRect.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
    }

    public static interface OnTransferListener {
        public void onTransferStart(int var1, int var2, int var3);

        public void onTransferUpdate(int var1, float var2);

        public void onTransferComplete(int var1, int var2, int var3);
    }
}

