/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.content.Context;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import com.hitomi.tilibrary.transfer.TransferConfig;
import com.hitomi.tilibrary.transfer.TransferLayout;
import com.hitomi.tilibrary.view.image.TransferImage;
import com.hitomi.tilibrary.view.video.ExoVideoView;

class TransferAdapter
extends PagerAdapter {
    private TransferLayout transfer;
    private int showIndex;
    private int imageSize;
    private OnInstantiateItemListener onInstantListener;
    private SparseArray<FrameLayout> containLayoutArray;

    TransferAdapter(TransferLayout transfer, int imageSize, int nowThumbnailIndex) {
        this.transfer = transfer;
        this.imageSize = imageSize;
        this.showIndex = nowThumbnailIndex + 1 == imageSize ? nowThumbnailIndex - 1 : nowThumbnailIndex + 1;
        this.showIndex = Math.max(this.showIndex, 0);
        this.containLayoutArray = new SparseArray();
    }

    public int getCount() {
        return this.imageSize;
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
        this.containLayoutArray.remove(position);
        this.transfer.loadedIndexSet.remove(position);
    }

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        FrameLayout parentLayout = (FrameLayout)this.containLayoutArray.get(position);
        if (parentLayout == null) {
            parentLayout = this.newParentLayout(container, position);
            this.containLayoutArray.append(position, (Object)parentLayout);
            if (position == this.showIndex && this.onInstantListener != null) {
                this.onInstantListener.onComplete();
            }
        }
        container.addView((View)parentLayout);
        return parentLayout;
    }

    @NonNull
    private FrameLayout newParentLayout(ViewGroup container, int pos) {
        Object contentView;
        Context context = container.getContext();
        TransferConfig config = this.transfer.getTransConfig();
        if (config.isVideoSource(pos)) {
            FrameLayout.LayoutParams centerLp = new FrameLayout.LayoutParams(-1, -2);
            centerLp.gravity = 17;
            contentView = new ExoVideoView(context);
            contentView.setLayoutParams((ViewGroup.LayoutParams)centerLp);
        } else {
            TransferImage imageView = new TransferImage(context);
            imageView.setDuration(config.getDuration());
            imageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
            imageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            if (config.isJustLoadHitPage()) {
                this.transfer.getTransferState(pos).prepareTransfer(imageView, pos);
            }
            contentView = imageView;
        }
        FrameLayout parentLayout = new FrameLayout(context);
        parentLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        parentLayout.addView((View)contentView);
        return parentLayout;
    }

    TransferImage getImageItem(int position) {
        FrameLayout parentLayout = (FrameLayout)this.containLayoutArray.get(position);
        if (parentLayout != null && parentLayout.getChildAt(0) instanceof TransferImage) {
            return (TransferImage)parentLayout.getChildAt(0);
        }
        return null;
    }

    ExoVideoView getVideoItem(int position) {
        FrameLayout parentLayout = (FrameLayout)this.containLayoutArray.get(position);
        if (parentLayout != null && parentLayout.getChildAt(0) instanceof ExoVideoView) {
            return (ExoVideoView)parentLayout.getChildAt(0);
        }
        return null;
    }

    SparseArray<FrameLayout> getCacheItems() {
        return this.containLayoutArray;
    }

    FrameLayout getParentItem(int position) {
        return (FrameLayout)this.containLayoutArray.get(position);
    }

    void setOnInstantListener(OnInstantiateItemListener listener) {
        this.onInstantListener = listener;
    }

    static interface OnInstantiateItemListener {
        public void onComplete();
    }
}

