/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import com.hitomi.tilibrary.loader.ImageLoader;
import com.hitomi.tilibrary.style.IProgressIndicator;
import com.hitomi.tilibrary.transfer.TransferAdapter;
import com.hitomi.tilibrary.transfer.TransferConfig;
import com.hitomi.tilibrary.transfer.TransferLayout;
import com.hitomi.tilibrary.transfer.TransferState;
import com.hitomi.tilibrary.view.image.TransferImage;
import java.io.File;
import java.util.List;

class EmptyThumbState
extends TransferState {
    EmptyThumbState(TransferLayout transfer) {
        super(transfer);
    }

    @Override
    public void prepareTransfer(TransferImage transImage, int position) {
        transImage.setImageDrawable(this.clipAndGetPlaceHolder(transImage, position));
    }

    @Override
    public TransferImage transferIn(int position) {
        ImageView originImage = this.transfer.getTransConfig().getOriginImageList().get(position);
        TransferImage transImage = this.createTransferImage(originImage, true);
        transImage.setImageDrawable(originImage.getDrawable());
        transImage.transformIn(201);
        this.transfer.addView((View)transImage, 1);
        return transImage;
    }

    @Override
    public void transferLoad(final int position) {
        TransferAdapter adapter = this.transfer.transAdapter;
        TransferConfig config = this.transfer.getTransConfig();
        final String imgUrl = config.getSourceUrlList().get(position);
        final TransferImage targetImage = adapter.getImageItem(position);
        Drawable placeHolder = config.isJustLoadHitPage() ? this.getPlaceHolder(position) : this.clipAndGetPlaceHolder(targetImage, position);
        targetImage.setImageDrawable(placeHolder);
        final IProgressIndicator progressIndicator = config.getProgressIndicator();
        progressIndicator.attach(position, adapter.getParentItem(position));
        config.getImageLoader().loadSource(imgUrl, new ImageLoader.SourceCallback(){

            @Override
            public void onStart() {
                progressIndicator.onStart(position);
            }

            @Override
            public void onProgress(int progress) {
                progressIndicator.onProgress(position, progress);
            }

            @Override
            public void onDelivered(int status, File source) {
                switch (status) {
                    case 1: {
                        EmptyThumbState.this.startPreview(targetImage, source, imgUrl, new TransferState.StartPreviewCallback(){

                            @Override
                            public void invoke() {
                                progressIndicator.onFinish(position);
                                targetImage.transformIn(202);
                            }
                        });
                        break;
                    }
                    case 0: {
                        EmptyThumbState.this.loadFailedDrawable(targetImage, position);
                    }
                }
            }
        });
    }

    @Override
    public TransferImage transferOut(int position) {
        TransferImage transImage = null;
        TransferConfig config = this.transfer.getTransConfig();
        List<ImageView> originImageList = config.getOriginImageList();
        if (position <= originImageList.size() - 1 && originImageList.get(position) != null) {
            transImage = this.createTransferImage(originImageList.get(position), true);
            Drawable thumbnailDrawable = this.transfer.transAdapter.getImageItem(config.getNowThumbnailIndex()).getDrawable();
            transImage.setImageDrawable(thumbnailDrawable);
            transImage.transformOut(201);
            this.transfer.addView((View)transImage, 1);
        }
        return transImage;
    }

    private Drawable getPlaceHolder(int position) {
        Drawable placeHolder = null;
        TransferConfig config = this.transfer.getTransConfig();
        ImageView originImage = config.getOriginImageList().get(position);
        if (originImage != null) {
            placeHolder = originImage.getDrawable();
        }
        if (placeHolder == null) {
            placeHolder = config.getMissDrawable(this.transfer.getContext());
        }
        return placeHolder;
    }

    private Drawable clipAndGetPlaceHolder(TransferImage targetImage, int position) {
        Drawable placeHolder = this.getPlaceHolder(position);
        this.clipTargetImage(targetImage, placeHolder, this.getPlaceholderClipSize(position, 1));
        return placeHolder;
    }
}

