/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import com.hitomi.tilibrary.loader.ImageLoader;
import com.hitomi.tilibrary.style.IProgressIndicator;
import com.hitomi.tilibrary.transfer.TransferAdapter;
import com.hitomi.tilibrary.transfer.TransferConfig;
import com.hitomi.tilibrary.transfer.TransferLayout;
import com.hitomi.tilibrary.transfer.TransferState;
import com.hitomi.tilibrary.view.image.TransferImage;
import java.io.File;

public class NoneThumbState
extends TransferState {
    NoneThumbState(TransferLayout transfer) {
        super(transfer);
    }

    @Override
    public void prepareTransfer(TransferImage transImage, int position) {
    }

    @Override
    public TransferImage createTransferIn(int position) {
        this.transfer.displayTransfer();
        return null;
    }

    @Override
    public void transferLoad(final int position) {
        TransferAdapter adapter = this.transfer.transAdapter;
        final TransferConfig transConfig = this.transfer.getTransConfig();
        final String imgUrl = transConfig.getSourceImageList().get(position);
        final TransferImage targetImage = adapter.getImageItem(position);
        File cache = transConfig.getImageLoader().getCache(imgUrl);
        if (cache == null) {
            Drawable placeholder = transConfig.getMissDrawable(this.transfer.getContext());
            int[] clipSize = new int[]{placeholder.getIntrinsicWidth(), placeholder.getIntrinsicHeight()};
            this.clipTargetImage(targetImage, placeholder, clipSize);
            IProgressIndicator progressIndicator = transConfig.getProgressIndicator();
            progressIndicator.attach(position, adapter.getParentItem(position));
            this.loadSourceImage(targetImage, progressIndicator, imgUrl, placeholder, position);
        } else {
            transConfig.getImageLoader().loadImageAsync(imgUrl, new ImageLoader.ThumbnailCallback(){

                @Override
                public void onFinish(Bitmap bitmap) {
                    Object placeholder = bitmap == null ? transConfig.getMissDrawable(NoneThumbState.this.transfer.getContext()) : new BitmapDrawable(NoneThumbState.this.transfer.getContext().getResources(), bitmap);
                    NoneThumbState.this.loadSourceImage(targetImage, null, imgUrl, placeholder, position);
                }
            });
        }
    }

    private void loadSourceImage(final TransferImage targetImage, final IProgressIndicator progressIndicator, final String imgUrl, Drawable placeHolder, final int position) {
        long startTime = System.currentTimeMillis();
        final TransferConfig transConfig = this.transfer.getTransConfig();
        transConfig.getImageLoader().showImage(imgUrl, (ImageView)targetImage, placeHolder, new ImageLoader.SourceCallback(){

            @Override
            public void onStart() {
                if (progressIndicator != null) {
                    progressIndicator.onStart(position);
                }
            }

            @Override
            public void onProgress(int progress) {
                if (progressIndicator != null) {
                    progressIndicator.onProgress(position, progress);
                }
            }

            @Override
            public void onDelivered(int status, File source) {
                if (progressIndicator != null) {
                    progressIndicator.onFinish(position);
                }
                switch (status) {
                    case 1: {
                        if (progressIndicator != null) {
                            targetImage.transformIn();
                        }
                        NoneThumbState.this.startPreview(targetImage, source, imgUrl, transConfig, position);
                        break;
                    }
                    case -1: {
                        if (targetImage.getDrawable() == null) break;
                        NoneThumbState.this.startPreview(targetImage, source, imgUrl, transConfig, position);
                        break;
                    }
                    case 0: {
                        targetImage.setImageDrawable(transConfig.getErrorDrawable(NoneThumbState.this.transfer.getContext()));
                    }
                }
            }
        });
    }

    @Override
    public TransferImage transferOut(int position) {
        return null;
    }
}

