/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import com.hitomi.tilibrary.loader.ImageLoader;
import com.hitomi.tilibrary.transfer.RemoteThumbState;
import com.hitomi.tilibrary.transfer.TransferConfig;
import com.hitomi.tilibrary.transfer.TransferLayout;
import com.hitomi.tilibrary.view.image.TransferImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import pl.droidsonroids.gif.GifDrawable;

abstract class TransferState {
    protected TransferLayout transfer;

    TransferState(TransferLayout transfer) {
        this.transfer = transfer;
    }

    int getTransImageLocalY(int oldY) {
        return oldY - this.getStatusBarHeight();
    }

    private int getStatusBarHeight() {
        try {
            Class<?> c = Class.forName("com.android.internal.R$dimen");
            Object object = c.newInstance();
            Field field = c.getField("status_bar_height");
            int x = (Integer)field.get(object);
            return this.transfer.getContext().getResources().getDimensionPixelSize(x);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private int[] getViewLocation(View view) {
        int[] location = new int[2];
        view.getLocationInWindow(location);
        return location;
    }

    @NonNull
    TransferImage createTransferImage(ImageView originImage) {
        TransferConfig config = this.transfer.getTransConfig();
        int[] location = this.getViewLocation((View)originImage);
        TransferImage transImage = new TransferImage(this.transfer.getContext());
        transImage.setScaleType(ImageView.ScaleType.FIT_CENTER);
        transImage.setOriginalInfo(location[0], this.getTransImageLocalY(location[1]), originImage.getWidth(), originImage.getHeight());
        transImage.setDuration(config.getDuration());
        transImage.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        transImage.setOnTransferListener(this.transfer.transListener);
        return transImage;
    }

    void transformThumbnail(String imageUrl, TransferImage transImage, boolean in) {
        TransferConfig config = this.transfer.getTransConfig();
        ImageLoader imageLoader = config.getImageLoader();
        if (this instanceof RemoteThumbState) {
            if (imageLoader.getCache(imageUrl) != null) {
                this.loadThumbnail(imageUrl, transImage, in);
            } else {
                transImage.setImageDrawable(config.getMissDrawable(this.transfer.getContext()));
                if (in) {
                    transImage.transformIn();
                } else {
                    transImage.transformOut();
                }
            }
        } else {
            this.loadThumbnail(imageUrl, transImage, in);
        }
    }

    void startPreview(TransferImage targetImage, File source, String imgUrl, TransferConfig config, int position) {
        targetImage.enable();
        if (imgUrl.endsWith("gif")) {
            File cache;
            File file = cache = source == null ? config.getImageLoader().getCache(imgUrl) : source;
            if (cache != null) {
                try {
                    targetImage.setImageDrawable((Drawable)new GifDrawable(cache.getPath()));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.transfer.bindOnOperationListener((ImageView)targetImage, imgUrl, position);
    }

    void clipTargetImage(TransferImage targetImage, Drawable originDrawable, int[] clipSize) {
        DisplayMetrics displayMetrics = this.transfer.getContext().getResources().getDisplayMetrics();
        int width = displayMetrics.widthPixels;
        int height = this.getTransImageLocalY(displayMetrics.heightPixels);
        targetImage.setOriginalInfo(originDrawable, clipSize[0], clipSize[1], width, height);
        targetImage.transClip();
    }

    private void loadThumbnail(String imageUrl, TransferImage transImage, boolean in) {
        Bitmap thumbBitmap;
        TransferConfig config = this.transfer.getTransConfig();
        ImageLoader imageLoader = config.getImageLoader();
        File thumbFile = imageLoader.getCache(imageUrl);
        Bitmap bitmap = thumbBitmap = thumbFile != null ? BitmapFactory.decodeFile((String)thumbFile.getAbsolutePath()) : null;
        if (thumbBitmap == null) {
            transImage.setImageDrawable(config.getMissDrawable(this.transfer.getContext()));
        } else {
            transImage.setImageBitmap(thumbBitmap);
        }
        if (in) {
            transImage.transformIn();
        } else {
            transImage.transformOut();
        }
    }

    public abstract void prepareTransfer(TransferImage var1, int var2);

    public abstract TransferImage createTransferIn(int var1);

    public abstract void transferLoad(int var1);

    public abstract TransferImage transferOut(int var1);
}

