/*
 * Decompiled with CFR 0.152.
 */
package com.hitomi.tilibrary.transfer;

import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import com.hitomi.tilibrary.loader.ImageLoader;
import com.hitomi.tilibrary.transfer.TransferConfig;
import com.hitomi.tilibrary.transfer.TransferLayout;
import com.hitomi.tilibrary.transfer.TransferState;
import com.hitomi.tilibrary.view.image.TransferImage;
import java.util.List;

class LocalThumState
extends TransferState {
    LocalThumState(TransferLayout transfer) {
        super(transfer);
    }

    @Override
    public void prepareTransfer(final TransferImage transImage, int position) {
        final TransferConfig config = this.transfer.getTransConfig();
        ImageLoader imageLoader = config.getImageLoader();
        String imgUrl = config.getSourceImageList().get(position);
        imageLoader.loadThumbnailAsync(imgUrl, transImage, new ImageLoader.ThumbnailCallback(){

            @Override
            public void onFinish(Drawable drawable) {
                transImage.setImageDrawable(drawable == null ? config.getMissDrawable(LocalThumState.this.context) : drawable);
            }
        });
    }

    @Override
    public TransferImage createTransferIn(int position) {
        TransferConfig config = this.transfer.getTransConfig();
        TransferImage transImage = this.createTransferImage(config.getOriginImageList().get(position));
        this.transformThumbnail(config.getSourceImageList().get(position), transImage, true);
        this.transfer.addView((View)transImage, 1);
        return transImage;
    }

    @Override
    public void transferLoad(final int position) {
        final TransferConfig config = this.transfer.getTransConfig();
        final String imgUrl = config.getSourceImageList().get(position);
        final TransferImage targetImage = this.transfer.getTransAdapter().getImageItem(position);
        if (config.isJustLoadHitImage()) {
            this.loadSourceImage(imgUrl, targetImage, targetImage.getDrawable(), position);
        } else {
            config.getImageLoader().loadThumbnailAsync(imgUrl, targetImage, new ImageLoader.ThumbnailCallback(){

                @Override
                public void onFinish(Drawable drawable) {
                    if (drawable == null) {
                        drawable = config.getMissDrawable(LocalThumState.this.context);
                    }
                    LocalThumState.this.loadSourceImage(imgUrl, targetImage, drawable, position);
                }
            });
        }
    }

    private void loadSourceImage(String imgUrl, final TransferImage targetImage, Drawable drawable, final int position) {
        final TransferConfig config = this.transfer.getTransConfig();
        config.getImageLoader().showSourceImage(imgUrl, targetImage, drawable, new ImageLoader.SourceCallback(){

            @Override
            public void onStart() {
            }

            @Override
            public void onProgress(int progress) {
            }

            @Override
            public void onFinish() {
            }

            @Override
            public void onDelivered(int status) {
                switch (status) {
                    case 1: {
                        if (3 == targetImage.getState()) {
                            targetImage.transformIn(202);
                        }
                        targetImage.enable();
                        LocalThumState.this.transfer.bindOnOperationListener(targetImage, position);
                        break;
                    }
                    case 0: {
                        targetImage.setImageDrawable(config.getErrorDrawable(LocalThumState.this.context));
                    }
                }
            }
        });
    }

    @Override
    public TransferImage transferOut(int position) {
        TransferImage transImage = null;
        TransferConfig config = this.transfer.getTransConfig();
        List<ImageView> originImageList = config.getOriginImageList();
        if (position < originImageList.size()) {
            transImage = this.createTransferImage(originImageList.get(position));
            this.transformThumbnail(config.getSourceImageList().get(position), transImage, false);
            this.transfer.addView((View)transImage, 1);
        }
        return transImage;
    }
}

