/*
 * Decompiled with CFR 0.152.
 */
package com.potyvideo.library.utils;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.webkit.MimeTypeMap;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.potyvideo.library.utils.PublicValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/potyvideo/library/utils/PublicFunctions;", "", "()V", "Companion", "library_release"})
public final class PublicFunctions {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0007J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u0006\u0010\u0013\u001a\u00020\bJ\u0006\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0010\u00a8\u0006\u0016"}, d2={"Lcom/potyvideo/library/utils/PublicFunctions$Companion;", "", "()V", "checkAccessStoragePermission", "", "activity", "Landroid/app/Activity;", "convertDpToPixel", "", "context", "Landroid/content/Context;", "dp", "", "convertPixelsToDp", "px", "getMimeType", "", "source", "getMimeTypeV2", "getScreenHeight", "getScreenWidth", "isThisSourceSupported", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isThisSourceSupported(@NotNull String source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            String mimeType = this.getMimeTypeV2(source);
            return PublicValues.Companion.getSUPPORTED_MEDIAS().contains(mimeType);
        }

        @Deprecated(message="This method is depricated use getMimeTypeV2()")
        @NotNull
        public final String getMimeType(@NotNull String source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            String string = StringsKt.substringAfterLast((String)source, (String)".", (String)PublicValues.Companion.getKEY_UNKNOWN()).toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
            return string;
        }

        @NotNull
        public final String getMimeTypeV2(@NotNull String source) {
            String string;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            String mimeType = null;
            String extension = MimeTypeMap.getFileExtensionFromUrl((String)source);
            if (extension != null) {
                String string2;
                String string3 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
                if (string3 != null) {
                    String string4 = string3.toLowerCase(Locale.ROOT);
                    string2 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                } else {
                    string2 = mimeType = null;
                }
            }
            if ((string = mimeType) == null) {
                string = PublicValues.Companion.getKEY_UNKNOWN();
            }
            return string;
        }

        public final int getScreenWidth() {
            return Resources.getSystem().getDisplayMetrics().widthPixels;
        }

        public final int getScreenHeight() {
            return Resources.getSystem().getDisplayMetrics().heightPixels;
        }

        public final int convertDpToPixel(@NotNull Context context, float dp) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return (Integer)((Object)Float.valueOf(dp * (float)(context.getResources().getDisplayMetrics().densityDpi / 160)));
        }

        public final int convertPixelsToDp(@NotNull Context context, float px) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return (Integer)((Object)Float.valueOf(px / (float)(context.getResources().getDisplayMetrics().densityDpi / 160)));
        }

        public final boolean checkAccessStoragePermission(@Nullable Activity activity) {
            if (Build.VERSION.SDK_INT >= 23) {
                List listPermissionsNeeded = new ArrayList();
                Activity activity2 = activity;
                Intrinsics.checkNotNull((Object)activity2);
                if (ContextCompat.checkSelfPermission((Context)((Context)activity2), (String)"android.permission.READ_EXTERNAL_STORAGE") != 0) {
                    listPermissionsNeeded.add("android.permission.READ_EXTERNAL_STORAGE");
                }
                if (ContextCompat.checkSelfPermission((Context)((Context)activity), (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                    listPermissionsNeeded.add("android.permission.WRITE_EXTERNAL_STORAGE");
                }
                if (!((Collection)listPermissionsNeeded).isEmpty()) {
                    Collection $this$toTypedArray$iv = listPermissionsNeeded;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    ActivityCompat.requestPermissions((Activity)activity, (String[])stringArray, (int)10002);
                    return false;
                }
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

