/*
 * Decompiled with CFR 0.152.
 */
package com.potyvideo.library.utils;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import java.util.ArrayList;

public class PublicFunctions {
    public static int convertDpToPixel(Context context, float dp) {
        return (int)(dp * (float)(context.getResources().getDisplayMetrics().densityDpi / 160));
    }

    public static int convertPixelsToDp(Context context, float px) {
        return (int)(px / (float)(context.getResources().getDisplayMetrics().densityDpi / 160));
    }

    public static boolean checkAccessStoragePermission(Activity activity) {
        if (Build.VERSION.SDK_INT >= 23) {
            ArrayList<String> listPermissionsNeeded = new ArrayList<String>();
            if (ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.READ_EXTERNAL_STORAGE") != 0) {
                listPermissionsNeeded.add("android.permission.READ_EXTERNAL_STORAGE");
            }
            if (ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                listPermissionsNeeded.add("android.permission.WRITE_EXTERNAL_STORAGE");
            }
            if (!listPermissionsNeeded.isEmpty()) {
                ActivityCompat.requestPermissions((Activity)activity, (String[])listPermissionsNeeded.toArray(new String[listPermissionsNeeded.size()]), (int)1);
                return false;
            }
        }
        return true;
    }

    public static int getScreenWidth() {
        return Resources.getSystem().getDisplayMetrics().widthPixels;
    }

    public static int getScreenHeight() {
        return Resources.getSystem().getDisplayMetrics().heightPixels;
    }
}

