/*
 * Decompiled with CFR 0.152.
 */
package com.potyvideo.library;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.net.Uri;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.URLUtil;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatButton;
import androidx.appcompat.widget.AppCompatImageButton;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.source.LoopingMediaSource;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.ProgressiveMediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.dash.DashChunkSource;
import com.google.android.exoplayer2.source.dash.DashMediaSource;
import com.google.android.exoplayer2.source.dash.DefaultDashChunkSource;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.ui.PlayerView;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSourceFactory;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.potyvideo.library.R;
import com.potyvideo.library.globalEnums.EnumAspectRatio;
import com.potyvideo.library.globalEnums.EnumLoop;
import com.potyvideo.library.globalEnums.EnumResizeMode;
import com.potyvideo.library.globalInterfaces.ExoPlayerCallBack;
import com.potyvideo.library.utils.PublicFunctions;
import java.util.HashMap;
import java.util.Map;

public class AndExoPlayerView
extends LinearLayout
implements View.OnClickListener {
    private Context context;
    private String currSource = "";
    private int currentWindow = 0;
    private long playbackPosition = 0L;
    private boolean isPreparing = false;
    private TypedArray typedArray = null;
    private boolean currPlayWhenReady = false;
    private boolean showController = true;
    private EnumResizeMode currResizeMode = EnumResizeMode.FILL;
    private EnumAspectRatio currAspectRatio = EnumAspectRatio.ASPECT_16_9;
    private EnumLoop currLoop = EnumLoop.Finite;
    private SimpleExoPlayer simpleExoPlayer;
    private PlayerView playerView;
    private ComponentListener componentListener;
    private LinearLayout linearLayoutRetry;
    private LinearLayout linearLayoutLoading;
    private AppCompatButton buttonRetry;
    private FrameLayout frameLayoutFullScreenContainer;
    private AppCompatImageButton imageViewEnterFullScreen;
    private AppCompatImageButton imageViewExitFullScreen;
    private BandwidthMeter bandwidthMeter;
    private ExtractorsFactory extractorsFactory;
    private TrackSelection.Factory trackSelectionFactory;
    private TrackSelector trackSelector;
    private ExoPlayerCallBack exoPlayerCallBack;

    public AndExoPlayerView(Context context) {
        super(context);
        this.initializeView(context);
    }

    public AndExoPlayerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.AndExoPlayerView, 0, 0);
        this.initializeView(context);
    }

    public AndExoPlayerView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.AndExoPlayerView, 0, 0);
        this.initializeView(context);
    }

    private void initializeView(Context context) {
        this.context = context;
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.layout_player_base, (ViewGroup)this, true);
        this.playerView = (PlayerView)view.findViewById(R.id.simpleExoPlayerView);
        this.linearLayoutLoading = (LinearLayout)this.findViewById(R.id.linearLayoutLoading);
        this.linearLayoutRetry = (LinearLayout)this.findViewById(R.id.linearLayoutRetry);
        this.buttonRetry = (AppCompatButton)this.findViewById(R.id.appCompatButton_try_again);
        this.frameLayoutFullScreenContainer = (FrameLayout)this.playerView.findViewById(R.id.container_fullscreen);
        this.imageViewEnterFullScreen = (AppCompatImageButton)this.playerView.findViewById(R.id.exo_enter_fullscreen);
        this.imageViewExitFullScreen = (AppCompatImageButton)this.playerView.findViewById(R.id.exo_exit_fullscreen);
        this.componentListener = new ComponentListener();
        this.linearLayoutRetry.setOnClickListener((View.OnClickListener)this);
        this.imageViewEnterFullScreen.setOnClickListener((View.OnClickListener)this);
        this.imageViewExitFullScreen.setOnClickListener((View.OnClickListener)this);
        this.buttonRetry.setOnClickListener((View.OnClickListener)this);
        if (this.typedArray != null) {
            if (this.typedArray.hasValue(R.styleable.AndExoPlayerView_andexo_resize_mode)) {
                int resizeMode = this.typedArray.getInteger(R.styleable.AndExoPlayerView_andexo_resize_mode, EnumResizeMode.FILL.getValue().intValue());
                this.setResizeMode(EnumResizeMode.get(resizeMode));
            }
            if (this.typedArray.hasValue(R.styleable.AndExoPlayerView_andexo_aspect_ratio)) {
                int aspectRatio = this.typedArray.getInteger(R.styleable.AndExoPlayerView_andexo_aspect_ratio, EnumAspectRatio.ASPECT_16_9.getValue().intValue());
                this.setAspectRatio(EnumAspectRatio.get(aspectRatio));
            }
            if (this.typedArray.hasValue(R.styleable.AndExoPlayerView_andexo_full_screen)) {
                this.setShowFullScreen(this.typedArray.getBoolean(R.styleable.AndExoPlayerView_andexo_full_screen, false));
            }
            if (this.typedArray.hasValue(R.styleable.AndExoPlayerView_andexo_play_when_ready)) {
                this.setPlayWhenReady(this.typedArray.getBoolean(R.styleable.AndExoPlayerView_andexo_play_when_ready, false));
            }
            if (this.typedArray.hasValue(R.styleable.AndExoPlayerView_andexo_show_controller)) {
                this.setShowController(this.typedArray.getBoolean(R.styleable.AndExoPlayerView_andexo_show_controller, true));
            }
            if (this.typedArray.hasValue(R.styleable.AndExoPlayerView_andexo_loop)) {
                EnumLoop enumLoop = EnumLoop.get(this.typedArray.getInteger(R.styleable.AndExoPlayerView_andexo_loop, EnumLoop.Finite.getValue().intValue()));
                this.setLoopMode(enumLoop);
            }
            this.typedArray.recycle();
        }
        this.initializePlayer();
    }

    public SimpleExoPlayer getPlayer() {
        return this.simpleExoPlayer;
    }

    private void initializePlayer() {
        if (this.simpleExoPlayer == null) {
            this.bandwidthMeter = new DefaultBandwidthMeter();
            this.extractorsFactory = new DefaultExtractorsFactory();
            this.trackSelectionFactory = new AdaptiveTrackSelection.Factory();
            this.trackSelector = new DefaultTrackSelector();
            this.simpleExoPlayer = ExoPlayerFactory.newSimpleInstance((Context)this.context, (TrackSelector)this.trackSelector);
            this.playerView.setPlayer((Player)this.simpleExoPlayer);
            this.simpleExoPlayer.setPlayWhenReady(this.currPlayWhenReady);
            this.simpleExoPlayer.seekTo(this.currentWindow, this.playbackPosition);
            this.simpleExoPlayer.addListener((Player.EventListener)this.componentListener);
        }
    }

    public void setSource(String source) {
        MediaSource mediaSource = this.buildMediaSource(source, null);
        if (mediaSource != null && this.simpleExoPlayer != null) {
            this.showProgress();
            switch (this.currLoop) {
                case INFINITE: {
                    LoopingMediaSource loopingSource = new LoopingMediaSource(mediaSource);
                    this.simpleExoPlayer.prepare((MediaSource)loopingSource, true, false);
                    break;
                }
                default: {
                    this.simpleExoPlayer.prepare(mediaSource, true, false);
                }
            }
        }
    }

    public void setSource(String source, HashMap<String, String> extraHeaders) {
        MediaSource mediaSource = this.buildMediaSource(source, extraHeaders);
        if (mediaSource != null && this.simpleExoPlayer != null) {
            this.showProgress();
            switch (this.currLoop) {
                case INFINITE: {
                    LoopingMediaSource loopingSource = new LoopingMediaSource(mediaSource);
                    this.simpleExoPlayer.prepare((MediaSource)loopingSource, true, false);
                    break;
                }
                default: {
                    this.simpleExoPlayer.prepare(mediaSource, true, false);
                }
            }
        }
    }

    private MediaSource buildMediaSource(String source, HashMap<String, String> extraHeaders) {
        if (source == null) {
            Toast.makeText((Context)this.context, (CharSequence)"Input Is Invalid.", (int)0).show();
            return null;
        }
        this.currSource = source;
        boolean validUrl = URLUtil.isValidUrl((String)source);
        Uri uri = Uri.parse((String)source);
        if (uri == null || uri.getLastPathSegment() == null) {
            Toast.makeText((Context)this.context, (CharSequence)"Uri Converter Failed, Input Is Invalid.", (int)0).show();
            return null;
        }
        if (validUrl && uri.getLastPathSegment().contains("mp4")) {
            DefaultHttpDataSourceFactory sourceFactory = new DefaultHttpDataSourceFactory("exoplayer-codelab");
            if (extraHeaders != null) {
                for (Map.Entry<String, String> entry : extraHeaders.entrySet()) {
                    sourceFactory.getDefaultRequestProperties().set(entry.getKey(), entry.getValue());
                }
            }
            return new ProgressiveMediaSource.Factory((DataSource.Factory)sourceFactory).createMediaSource(uri);
        }
        if (!validUrl && uri.getLastPathSegment().contains("mp4")) {
            return new ProgressiveMediaSource.Factory((DataSource.Factory)new DefaultDataSourceFactory(this.context, "exoplayer-codelab")).createMediaSource(uri);
        }
        if (uri.getLastPathSegment().contains("m3u8")) {
            DefaultHttpDataSourceFactory sourceFactory = new DefaultHttpDataSourceFactory("exoplayer-codelab");
            if (extraHeaders != null) {
                for (Map.Entry<String, String> entry : extraHeaders.entrySet()) {
                    sourceFactory.getDefaultRequestProperties().set(entry.getKey(), entry.getValue());
                }
            }
            return new HlsMediaSource.Factory((DataSource.Factory)sourceFactory).createMediaSource(uri);
        }
        if (uri.getLastPathSegment().contains("mp3")) {
            DefaultHttpDataSourceFactory sourceFactory = new DefaultHttpDataSourceFactory("exoplayer-codelab");
            if (extraHeaders != null) {
                for (Map.Entry<String, String> entry : extraHeaders.entrySet()) {
                    sourceFactory.getDefaultRequestProperties().set(entry.getKey(), entry.getValue());
                }
            }
            return new ProgressiveMediaSource.Factory((DataSource.Factory)sourceFactory).createMediaSource(uri);
        }
        DefaultDashChunkSource.Factory dashChunkSourceFactory = new DefaultDashChunkSource.Factory((DataSource.Factory)new DefaultHttpDataSourceFactory("ua", (TransferListener)new DefaultBandwidthMeter()));
        DefaultHttpDataSourceFactory manifestDataSourceFactory = new DefaultHttpDataSourceFactory("exoplayer-codelab");
        return new DashMediaSource.Factory((DashChunkSource.Factory)dashChunkSourceFactory, (DataSource.Factory)manifestDataSourceFactory).createMediaSource(uri);
    }

    private void releasePlayer() {
        if (this.simpleExoPlayer != null) {
            this.playbackPosition = this.simpleExoPlayer.getCurrentPosition();
            this.currentWindow = this.simpleExoPlayer.getCurrentWindowIndex();
            this.currPlayWhenReady = this.simpleExoPlayer.getPlayWhenReady();
            this.simpleExoPlayer.removeListener((Player.EventListener)this.componentListener);
            this.simpleExoPlayer.release();
            this.simpleExoPlayer = null;
        }
    }

    public void setPlayWhenReady(boolean playWhenReady) {
        this.currPlayWhenReady = playWhenReady;
        if (this.simpleExoPlayer != null) {
            this.simpleExoPlayer.setPlayWhenReady(playWhenReady);
        }
    }

    public void stopPlayer() {
        if (this.simpleExoPlayer != null) {
            this.simpleExoPlayer.stop();
        }
    }

    public void pausePlayer() {
        if (this.simpleExoPlayer != null) {
            this.simpleExoPlayer.setPlayWhenReady(false);
        }
    }

    public void setShowController(boolean showController) {
        if (this.playerView == null) {
            return;
        }
        if (showController) {
            this.playerView.showController();
            this.playerView.setUseController(true);
        } else {
            this.playerView.hideController();
            this.playerView.setUseController(false);
        }
    }

    public void setResizeMode(EnumResizeMode resizeMode) {
        switch (resizeMode) {
            case FIT: {
                this.playerView.setResizeMode(0);
                break;
            }
            case FILL: {
                this.playerView.setResizeMode(3);
                break;
            }
            case ZOOM: {
                this.playerView.setResizeMode(4);
                break;
            }
            default: {
                this.playerView.setResizeMode(0);
            }
        }
    }

    public void setShowFullScreen(boolean showFullScreen) {
        if (showFullScreen) {
            this.frameLayoutFullScreenContainer.setVisibility(0);
        } else {
            this.frameLayoutFullScreenContainer.setVisibility(8);
        }
    }

    public void setAspectRatio(EnumAspectRatio aspectRatio) {
        this.currAspectRatio = aspectRatio;
        int value = PublicFunctions.getScreenWidth();
        switch (aspectRatio) {
            case ASPECT_1_1: {
                this.playerView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(value, value));
                break;
            }
            case ASPECT_4_3: {
                this.playerView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(value, 3 * value / 4));
                break;
            }
            case ASPECT_16_9: {
                this.playerView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(value, 9 * value / 16));
                break;
            }
            case ASPECT_MATCH: {
                this.playerView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                break;
            }
            case ASPECT_MP3: {
                this.playerView.setControllerShowTimeoutMs(0);
                this.playerView.setControllerHideOnTouch(false);
                int mp3Height = this.getContext().getResources().getDimensionPixelSize(R.dimen.player_controller_base_height);
                this.playerView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, mp3Height));
                break;
            }
            default: {
                int baseHeight = (int)this.getResources().getDimension(R.dimen.player_base_height);
                this.playerView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, baseHeight));
            }
        }
    }

    private void setLoopMode(EnumLoop loopMode) {
        this.currLoop = loopMode;
    }

    private Activity getActivity() {
        Context context = this.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.releasePlayer();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (newConfig.orientation == 2) {
            this.hideSystemUi();
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.playerView.getLayoutParams();
            params.width = -1;
            params.height = -1;
            this.playerView.setLayoutParams((ViewGroup.LayoutParams)params);
        } else if (newConfig.orientation == 1) {
            this.showSystemUi();
            this.setAspectRatio(this.currAspectRatio);
        }
    }

    @SuppressLint(value={"InlinedApi"})
    private void hideSystemUi() {
        if (this.playerView == null) {
            return;
        }
        this.playerView.setSystemUiVisibility(4871);
    }

    @SuppressLint(value={"InlinedApi"})
    private void showSystemUi() {
        if (this.playerView == null) {
            return;
        }
        this.playerView.setSystemUiVisibility(257);
    }

    public void onClick(View v) {
        int targetViewId = v.getId();
        if (targetViewId == R.id.appCompatButton_try_again) {
            this.hideRetry();
            this.setSource(this.currSource);
        } else if (targetViewId == R.id.exo_enter_fullscreen) {
            this.enterFullScreen();
        } else if (targetViewId == R.id.exo_exit_fullscreen) {
            this.exitFullScreen();
        }
    }

    public void setExoPlayerCallBack(ExoPlayerCallBack exoPlayerCallBack) {
        this.exoPlayerCallBack = exoPlayerCallBack;
    }

    private void enterFullScreen() {
        this.imageViewExitFullScreen.setVisibility(0);
        this.imageViewEnterFullScreen.setVisibility(8);
        if (this.getActivity() != null) {
            this.getActivity().setRequestedOrientation(0);
        }
    }

    private void exitFullScreen() {
        this.imageViewExitFullScreen.setVisibility(8);
        this.imageViewEnterFullScreen.setVisibility(0);
        if (this.getActivity() != null) {
            this.getActivity().setRequestedOrientation(1);
        }
    }

    private void showProgress() {
        this.hideAll();
        if (this.linearLayoutLoading != null) {
            this.linearLayoutLoading.setVisibility(0);
        }
    }

    private void hideProgress() {
        if (this.linearLayoutLoading != null) {
            this.linearLayoutLoading.setVisibility(8);
        }
    }

    private void showRetry() {
        this.hideAll();
        if (this.linearLayoutRetry != null) {
            this.linearLayoutRetry.setVisibility(0);
        }
    }

    private void hideRetry() {
        if (this.linearLayoutRetry != null) {
            this.linearLayoutRetry.setVisibility(8);
        }
    }

    private void hideAll() {
        if (this.linearLayoutRetry != null) {
            this.linearLayoutRetry.setVisibility(8);
        }
        if (this.linearLayoutLoading != null) {
            this.linearLayoutLoading.setVisibility(8);
        }
    }

    public class ComponentListener
    implements Player.EventListener {
        String TAG = ComponentListener.class.getSimpleName();

        public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
            String stateString;
            switch (playbackState) {
                case 1: {
                    stateString = "ExoPlayer.STATE_IDLE      -";
                    break;
                }
                case 2: {
                    stateString = "ExoPlayer.STATE_BUFFERING -";
                    break;
                }
                case 3: {
                    if (AndExoPlayerView.this.isPreparing) {
                        AndExoPlayerView.this.isPreparing = false;
                    }
                    AndExoPlayerView.this.hideProgress();
                    stateString = "ExoPlayer.STATE_READY     -";
                    break;
                }
                case 4: {
                    stateString = "ExoPlayer.STATE_ENDED     -";
                    break;
                }
                default: {
                    stateString = "UNKNOWN_STATE             -";
                }
            }
            Log.d((String)this.TAG, (String)("changed state to " + stateString + " playWhenReady: " + playWhenReady));
        }

        public void onRepeatModeChanged(int repeatMode) {
        }

        public void onShuffleModeEnabledChanged(boolean shuffleModeEnabled) {
        }

        public void onTracksChanged(TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
        }

        public void onLoadingChanged(boolean isLoading) {
        }

        public void onPlayerError(ExoPlaybackException error) {
            AndExoPlayerView.this.showRetry();
            if (AndExoPlayerView.this.exoPlayerCallBack != null) {
                AndExoPlayerView.this.exoPlayerCallBack.onError();
            }
        }

        public void onPositionDiscontinuity(int reason) {
        }

        public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
        }

        public void onSeekProcessed() {
        }
    }
}

