/*
 * Decompiled with CFR 0.152.
 */
package studio.carbonylgroup.textfieldboxes;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.Space;
import android.support.v7.widget.AppCompatImageButton;
import android.support.v7.widget.AppCompatTextView;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.lang.reflect.Field;
import studio.carbonylgroup.textfieldboxes.ExtendedEditText;
import studio.carbonylgroup.textfieldboxes.R;
import studio.carbonylgroup.textfieldboxes.SimpleTextChangedWatcher;

public class TextFieldBoxes
extends FrameLayout {
    public int DEFAULT_ERROR_COLOR;
    public int DEFAULT_PRIMARY_COLOR;
    public int DEFAULT_TEXT_COLOR;
    public int DEFAULT_DISABLED_TEXT_COLOR;
    public int DEFAULT_BG_COLOR;
    public int DEFAULT_FG_COLOR;
    protected boolean enabled;
    protected String labelText;
    protected String helperText;
    protected int maxCharacters;
    protected int minCharacters;
    protected int helperTextColor;
    protected int counterTextColor;
    protected int errorColor;
    protected int primaryColor;
    protected int secondaryColor;
    protected int panelBackgroundColor;
    protected int iconSignifierResourceId;
    protected int endIconResourceId;
    protected boolean isResponsiveIconColor;
    protected boolean hasClearButton;
    protected boolean hasFocus;
    protected boolean alwaysShowHint;
    protected boolean useDenseSpacing;
    protected int labelColor = -1;
    protected int labelTopMargin = -1;
    protected int ANIMATION_DURATION = 100;
    protected boolean onError = false;
    protected boolean activated = false;
    protected boolean isManualValidateError = false;
    protected View panel;
    protected View bottomLine;
    protected Space labelSpace;
    protected Space labelSpaceBelow;
    protected ViewGroup editTextLayout;
    protected ExtendedEditText editText;
    protected RelativeLayout rightShell;
    protected RelativeLayout upperPanel;
    protected RelativeLayout bottomPart;
    protected RelativeLayout inputLayout;
    protected AppCompatTextView helperLabel;
    protected AppCompatTextView counterLabel;
    protected AppCompatTextView floatingLabel;
    protected AppCompatImageButton clearButton;
    protected AppCompatImageButton iconImageButton;
    protected AppCompatImageButton endIconImageButton;
    protected InputMethodManager inputMethodManager;
    protected SimpleTextChangedWatcher textChangeListener;

    public TextFieldBoxes(Context context) {
        super(context);
        this.init();
    }

    public TextFieldBoxes(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
        this.handleAttributes(context, attrs);
    }

    public TextFieldBoxes(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
        this.handleAttributes(context, attrs);
    }

    protected void init() {
        this.initDefaultColor();
        this.inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
    }

    protected void initDefaultColor() {
        Resources.Theme theme = this.getContext().getTheme();
        this.DEFAULT_ERROR_COLOR = ContextCompat.getColor((Context)this.getContext(), (int)R.color.A400red);
        TypedArray themeArray = theme.obtainStyledAttributes(new int[]{0x1010030});
        this.DEFAULT_BG_COLOR = TextFieldBoxes.adjustAlpha(themeArray.getColor(0, 0), 0.06f);
        themeArray = theme.obtainStyledAttributes(new int[]{0x1010031});
        this.DEFAULT_FG_COLOR = themeArray.getColor(0, 0);
        themeArray = theme.obtainStyledAttributes(new int[]{R.attr.colorPrimary});
        this.DEFAULT_PRIMARY_COLOR = TextFieldBoxes.isLight(this.DEFAULT_BG_COLOR) ? TextFieldBoxes.lighter(themeArray.getColor(0, 0), 0.2f) : themeArray.getColor(0, 0);
        themeArray = theme.obtainStyledAttributes(new int[]{0x1010212});
        this.DEFAULT_TEXT_COLOR = themeArray.getColor(0, 0);
        themeArray = theme.obtainStyledAttributes(new int[]{0x1010033});
        float disabledAlpha = themeArray.getFloat(0, 0.0f);
        themeArray = theme.obtainStyledAttributes(new int[]{0x1010212});
        this.DEFAULT_DISABLED_TEXT_COLOR = TextFieldBoxes.adjustAlpha(themeArray.getColor(0, 0), disabledAlpha);
        themeArray.recycle();
    }

    protected ExtendedEditText findEditTextChild() {
        if (this.getChildCount() > 0 && this.getChildAt(0) instanceof ExtendedEditText) {
            return (ExtendedEditText)this.getChildAt(0);
        }
        return null;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.initViews();
        this.triggerSetters();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (widthMode == 0x40000000) {
            this.inputLayout.getLayoutParams().width = -1;
            this.upperPanel.getLayoutParams().width = -1;
            this.editTextLayout.getLayoutParams().width = -1;
            if (this.endIconImageButton.getVisibility() == 0) {
                ((RelativeLayout.LayoutParams)this.clearButton.getLayoutParams()).addRule(1, 0);
                ((RelativeLayout.LayoutParams)this.clearButton.getLayoutParams()).addRule(0, R.id.text_field_boxes_end_icon_button);
                if (Build.VERSION.SDK_INT >= 17) {
                    ((RelativeLayout.LayoutParams)this.clearButton.getLayoutParams()).addRule(17, 0);
                    ((RelativeLayout.LayoutParams)this.clearButton.getLayoutParams()).addRule(16, R.id.text_field_boxes_end_icon_button);
                }
                ((RelativeLayout.LayoutParams)this.endIconImageButton.getLayoutParams()).addRule(1, 0);
                ((RelativeLayout.LayoutParams)this.endIconImageButton.getLayoutParams()).addRule(11);
                if (Build.VERSION.SDK_INT >= 17) {
                    ((RelativeLayout.LayoutParams)this.endIconImageButton.getLayoutParams()).addRule(17, 0);
                    ((RelativeLayout.LayoutParams)this.endIconImageButton.getLayoutParams()).addRule(21);
                }
                if (this.hasClearButton) {
                    ((RelativeLayout.LayoutParams)this.inputLayout.getLayoutParams()).addRule(0, R.id.text_field_boxes_clear_button);
                } else {
                    ((RelativeLayout.LayoutParams)this.inputLayout.getLayoutParams()).addRule(0, R.id.text_field_boxes_end_icon_button);
                }
            } else {
                ((RelativeLayout.LayoutParams)this.clearButton.getLayoutParams()).addRule(1, 0);
                ((RelativeLayout.LayoutParams)this.clearButton.getLayoutParams()).addRule(11);
                if (Build.VERSION.SDK_INT >= 17) {
                    ((RelativeLayout.LayoutParams)this.clearButton.getLayoutParams()).addRule(17, 0);
                    ((RelativeLayout.LayoutParams)this.clearButton.getLayoutParams()).addRule(21);
                }
                ((RelativeLayout.LayoutParams)this.inputLayout.getLayoutParams()).addRule(0, R.id.text_field_boxes_clear_button);
            }
        } else if (widthMode == Integer.MIN_VALUE) {
            this.inputLayout.getLayoutParams().width = -2;
            this.upperPanel.getLayoutParams().width = -2;
            this.editTextLayout.getLayoutParams().width = -2;
        }
        if (heightMode == 0x40000000) {
            this.panel.getLayoutParams().height = -1;
            this.rightShell.getLayoutParams().height = -1;
            this.upperPanel.getLayoutParams().height = -1;
            ((RelativeLayout.LayoutParams)this.bottomPart.getLayoutParams()).addRule(3, 0);
            ((RelativeLayout.LayoutParams)this.bottomLine.getLayoutParams()).addRule(3, 0);
            ((RelativeLayout.LayoutParams)this.bottomPart.getLayoutParams()).addRule(12);
            ((RelativeLayout.LayoutParams)this.bottomLine.getLayoutParams()).addRule(12);
            ((RelativeLayout.LayoutParams)this.panel.getLayoutParams()).addRule(2, R.id.text_field_boxes_bottom);
        } else if (heightMode == Integer.MIN_VALUE) {
            this.panel.getLayoutParams().height = -2;
            this.rightShell.getLayoutParams().height = -2;
            this.upperPanel.getLayoutParams().height = -2;
            ((RelativeLayout.LayoutParams)this.bottomPart.getLayoutParams()).addRule(3, R.id.text_field_boxes_panel);
            ((RelativeLayout.LayoutParams)this.bottomLine.getLayoutParams()).addRule(3, R.id.text_field_boxes_upper_panel);
            ((RelativeLayout.LayoutParams)this.bottomPart.getLayoutParams()).addRule(12, 0);
            ((RelativeLayout.LayoutParams)this.bottomLine.getLayoutParams()).addRule(12, 0);
            ((RelativeLayout.LayoutParams)this.panel.getLayoutParams()).addRule(2, 0);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private void initViews() {
        this.editText = this.findEditTextChild();
        if (this.editText == null) {
            return;
        }
        this.addView(LayoutInflater.from((Context)this.getContext()).inflate(R.layout.text_field_boxes_layout, (ViewGroup)this, false));
        this.removeView((View)this.editText);
        this.editText.setBackgroundColor(0);
        this.editText.setDropDownBackgroundDrawable((Drawable)new ColorDrawable(this.DEFAULT_FG_COLOR));
        this.editText.setMinimumWidth(10);
        this.inputLayout = (RelativeLayout)this.findViewById(R.id.text_field_boxes_input_layout);
        this.floatingLabel = (AppCompatTextView)this.findViewById(R.id.text_field_boxes_label);
        this.panel = this.findViewById(R.id.text_field_boxes_panel);
        this.labelSpace = (Space)this.findViewById(R.id.text_field_boxes_label_space);
        this.labelSpaceBelow = (Space)this.findViewById(R.id.text_field_boxes_label_space_below);
        this.bottomLine = this.findViewById(R.id.bg_bottom_line);
        this.rightShell = (RelativeLayout)this.findViewById(R.id.text_field_boxes_right_shell);
        this.upperPanel = (RelativeLayout)this.findViewById(R.id.text_field_boxes_upper_panel);
        this.bottomPart = (RelativeLayout)this.findViewById(R.id.text_field_boxes_bottom);
        this.clearButton = (AppCompatImageButton)this.findViewById(R.id.text_field_boxes_clear_button);
        this.endIconImageButton = (AppCompatImageButton)this.findViewById(R.id.text_field_boxes_end_icon_button);
        this.helperLabel = (AppCompatTextView)this.findViewById(R.id.text_field_boxes_helper);
        this.counterLabel = (AppCompatTextView)this.findViewById(R.id.text_field_boxes_counter);
        this.iconImageButton = (AppCompatImageButton)this.findViewById(R.id.text_field_boxes_imageView);
        this.editTextLayout = (ViewGroup)this.findViewById(R.id.text_field_boxes_editTextLayout);
        this.inputLayout.addView((View)this.editText);
        this.editTextLayout.setAlpha(0.0f);
        this.floatingLabel.setPivotX(0.0f);
        this.floatingLabel.setPivotY(0.0f);
        this.labelColor = this.floatingLabel.getCurrentTextColor();
        this.clearButton.setColorFilter(this.DEFAULT_TEXT_COLOR);
        this.clearButton.setAlpha(0.35f);
        this.endIconImageButton.setColorFilter(this.DEFAULT_TEXT_COLOR);
        this.endIconImageButton.setAlpha(0.54f);
        this.labelTopMargin = ((RelativeLayout.LayoutParams)RelativeLayout.LayoutParams.class.cast((Object)this.floatingLabel.getLayoutParams())).topMargin;
        this.initOnClick();
        this.setUseDenseSpacing(this.useDenseSpacing);
        this.updateDimens(this.useDenseSpacing);
        if (!this.editText.getText().toString().isEmpty() || this.hasFocus) {
            this.activate(false);
        }
    }

    private void initOnClick() {
        final TextFieldBoxes mainBody = this;
        this.panel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!TextFieldBoxes.this.isActivated()) {
                    TextFieldBoxes.this.activate(true);
                }
                TextFieldBoxes.this.setHasFocus(true);
                TextFieldBoxes.this.inputMethodManager.showSoftInput((View)TextFieldBoxes.this.editText, 1);
                mainBody.performClick();
            }
        });
        this.iconImageButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!TextFieldBoxes.this.isActivated()) {
                    TextFieldBoxes.this.activate(true);
                }
                TextFieldBoxes.this.setHasFocus(true);
                TextFieldBoxes.this.inputMethodManager.showSoftInput((View)TextFieldBoxes.this.editText, 1);
                mainBody.performClick();
            }
        });
        this.editText.setDefaultOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean b) {
                if (b) {
                    TextFieldBoxes.this.setHasFocus(true);
                } else {
                    TextFieldBoxes.this.setHasFocus(false);
                }
            }
        });
        this.editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                if (!TextFieldBoxes.this.activated && !editable.toString().isEmpty()) {
                    TextFieldBoxes.this.activate(true);
                }
                if (TextFieldBoxes.this.activated && editable.toString().isEmpty() && !TextFieldBoxes.this.hasFocus) {
                    TextFieldBoxes.this.deactivate();
                }
                if (TextFieldBoxes.this.isManualValidateError) {
                    TextFieldBoxes.this.updateCounterText(false);
                } else {
                    TextFieldBoxes.this.validateError();
                }
                if (TextFieldBoxes.this.textChangeListener != null) {
                    TextFieldBoxes.this.textChangeListener.onTextChanged(editable.toString(), TextFieldBoxes.this.onError);
                }
            }
        });
        this.clearButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TextFieldBoxes.this.editText.setText("");
            }
        });
    }

    protected void handleAttributes(Context context, AttributeSet attrs) {
        try {
            TypedArray styledAttrs = context.obtainStyledAttributes(attrs, R.styleable.TextFieldBoxes);
            this.labelText = styledAttrs.getString(R.styleable.TextFieldBoxes_labelText) == null ? "" : styledAttrs.getString(R.styleable.TextFieldBoxes_labelText);
            this.helperText = styledAttrs.getString(R.styleable.TextFieldBoxes_helperText) == null ? "" : styledAttrs.getString(R.styleable.TextFieldBoxes_helperText);
            this.helperTextColor = styledAttrs.getInt(R.styleable.TextFieldBoxes_helperTextColor, this.DEFAULT_TEXT_COLOR);
            this.counterTextColor = styledAttrs.getInt(R.styleable.TextFieldBoxes_counterTextColor, this.DEFAULT_TEXT_COLOR);
            this.errorColor = styledAttrs.getInt(R.styleable.TextFieldBoxes_errorColor, this.DEFAULT_ERROR_COLOR);
            this.primaryColor = styledAttrs.getColor(R.styleable.TextFieldBoxes_primaryColor, this.DEFAULT_PRIMARY_COLOR);
            this.secondaryColor = styledAttrs.getColor(R.styleable.TextFieldBoxes_secondaryColor, this.DEFAULT_TEXT_COLOR);
            this.panelBackgroundColor = styledAttrs.getColor(R.styleable.TextFieldBoxes_panelBackgroundColor, this.DEFAULT_BG_COLOR);
            this.maxCharacters = styledAttrs.getInt(R.styleable.TextFieldBoxes_maxCharacters, 0);
            this.minCharacters = styledAttrs.getInt(R.styleable.TextFieldBoxes_minCharacters, 0);
            this.isManualValidateError = styledAttrs.getBoolean(R.styleable.TextFieldBoxes_manualValidateError, false);
            this.enabled = styledAttrs.getBoolean(R.styleable.TextFieldBoxes_enabled, true);
            this.iconSignifierResourceId = styledAttrs.getResourceId(R.styleable.TextFieldBoxes_iconSignifier, 0);
            this.endIconResourceId = styledAttrs.getResourceId(R.styleable.TextFieldBoxes_endIcon, 0);
            this.isResponsiveIconColor = styledAttrs.getBoolean(R.styleable.TextFieldBoxes_isResponsiveIconColor, true);
            this.hasClearButton = styledAttrs.getBoolean(R.styleable.TextFieldBoxes_hasClearButton, false);
            this.hasFocus = styledAttrs.getBoolean(R.styleable.TextFieldBoxes_hasFocus, false);
            this.alwaysShowHint = styledAttrs.getBoolean(R.styleable.TextFieldBoxes_alwaysShowHint, false);
            this.useDenseSpacing = styledAttrs.getBoolean(R.styleable.TextFieldBoxes_useDenseSpacing, false);
            styledAttrs.recycle();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSimpleTextChangeWatcher(SimpleTextChangedWatcher textChangeListener) {
        this.textChangeListener = textChangeListener;
    }

    protected void deactivate() {
        if (this.editText.getText().toString().isEmpty()) {
            if (this.alwaysShowHint && !this.editText.getHint().toString().isEmpty()) {
                this.editTextLayout.setAlpha(1.0f);
                this.floatingLabel.setScaleX(0.75f);
                this.floatingLabel.setScaleY(0.75f);
                this.floatingLabel.setTranslationY((float)(-this.labelTopMargin + this.getContext().getResources().getDimensionPixelOffset(R.dimen.label_active_margin_top)));
            } else {
                this.editTextLayout.setAlpha(0.0f);
                ViewCompat.animate((View)this.floatingLabel).alpha(1.0f).scaleX(1.0f).scaleY(1.0f).translationY(0.0f).setDuration((long)this.ANIMATION_DURATION);
            }
            if (this.editText.hasFocus()) {
                this.inputMethodManager.hideSoftInputFromWindow(this.editText.getWindowToken(), 0);
                this.editText.clearFocus();
            }
        }
        this.activated = false;
    }

    protected void activate(boolean animated) {
        boolean keepHint;
        this.editText.setAlpha(1.0f);
        if (this.editText.getText().toString().isEmpty() && !this.isActivated()) {
            this.editTextLayout.setAlpha(0.0f);
            this.floatingLabel.setScaleX(1.0f);
            this.floatingLabel.setScaleY(1.0f);
            this.floatingLabel.setTranslationY(0.0f);
        }
        boolean bl = keepHint = this.alwaysShowHint && !this.editText.getHint().toString().isEmpty();
        if (animated && !keepHint) {
            ViewCompat.animate((View)this.editTextLayout).alpha(1.0f).setDuration((long)this.ANIMATION_DURATION);
            ViewCompat.animate((View)this.floatingLabel).scaleX(0.75f).scaleY(0.75f).translationY((float)(-this.labelTopMargin + this.getContext().getResources().getDimensionPixelOffset(R.dimen.label_active_margin_top))).setDuration((long)this.ANIMATION_DURATION);
        } else {
            this.editTextLayout.setAlpha(1.0f);
            this.floatingLabel.setScaleX(0.75f);
            this.floatingLabel.setScaleY(0.75f);
            this.floatingLabel.setTranslationY((float)(-this.labelTopMargin + this.getContext().getResources().getDimensionPixelOffset(R.dimen.label_active_margin_top)));
        }
        this.activated = true;
    }

    protected void makeCursorBlink() {
        CharSequence hintCache = this.editText.getHint();
        this.editText.setHint(" ");
        this.editText.setHint(hintCache);
    }

    protected void setHighlightColor(int colorRes) {
        this.floatingLabel.setTextColor(colorRes);
        TextFieldBoxes.setCursorDrawableColor((EditText)this.editText, colorRes);
        if (this.getIsResponsiveIconColor()) {
            this.iconImageButton.setColorFilter(colorRes);
            if (colorRes == this.secondaryColor) {
                this.iconImageButton.setAlpha(0.54f);
            } else {
                this.iconImageButton.setAlpha(1.0f);
            }
        }
        if (colorRes == this.DEFAULT_DISABLED_TEXT_COLOR) {
            this.iconImageButton.setAlpha(0.35f);
        }
        this.bottomLine.setBackgroundColor(colorRes);
    }

    protected void setManualValidateError(boolean isManualValidateError) {
        this.isManualValidateError = isManualValidateError;
    }

    public boolean validateError() {
        this.removeError();
        this.updateCounterText(true);
        if (this.onError) {
            this.setError(null, false);
        }
        return !this.onError;
    }

    protected void updateDimens(boolean useDenseSpacing) {
        Resources res = this.getContext().getResources();
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.floatingLabel.getLayoutParams();
        lp.topMargin = res.getDimensionPixelOffset(useDenseSpacing ? R.dimen.dense_label_idle_margin_top : R.dimen.label_idle_margin_top);
        this.floatingLabel.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.editTextLayout.setPadding(0, res.getDimensionPixelOffset(useDenseSpacing ? R.dimen.dense_editTextLayout_padding_top : R.dimen.editTextLayout_padding_top), 0, res.getDimensionPixelOffset(R.dimen.editTextLayout_padding_bottom));
        lp = (RelativeLayout.LayoutParams)this.bottomPart.getLayoutParams();
        lp.topMargin = res.getDimensionPixelOffset(useDenseSpacing ? R.dimen.dense_bottom_marginTop : R.dimen.bottom_marginTop);
        this.bottomPart.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.editText.setTextSize(0, res.getDimension(useDenseSpacing ? R.dimen.dense_edittext_text_size : R.dimen.edittext_text_size));
        this.labelTopMargin = ((RelativeLayout.LayoutParams)RelativeLayout.LayoutParams.class.cast((Object)this.floatingLabel.getLayoutParams())).topMargin;
        this.requestLayout();
    }

    protected void updateCounterText(boolean performValidation) {
        if (this.hasClearButton) {
            if (this.editText.getText().toString().length() == 0) {
                this.showClearButton(false);
            } else {
                this.showClearButton(true);
            }
        }
        int length = this.editText.getText().toString().replaceAll(" ", "").replaceAll("\n", "").length();
        String lengthStr = Integer.toString(length) + " / ";
        String counterLabelResourceStr = this.getResources().getString(R.string.counter_label_text_constructor);
        if (this.maxCharacters > 0) {
            if (this.minCharacters > 0) {
                this.counterLabel.setText((CharSequence)String.format(counterLabelResourceStr, lengthStr, Integer.toString(this.minCharacters), "-", Integer.toString(this.maxCharacters)));
                if (performValidation) {
                    if (length < this.minCharacters || length > this.maxCharacters) {
                        this.setCounterError();
                    } else {
                        this.removeCounterError();
                    }
                }
            } else {
                this.counterLabel.setText((CharSequence)String.format(counterLabelResourceStr, lengthStr, Integer.toString(this.maxCharacters), "", ""));
                if (performValidation) {
                    if (length > this.maxCharacters) {
                        this.setCounterError();
                    } else {
                        this.removeCounterError();
                    }
                }
            }
        } else if (this.minCharacters > 0) {
            this.counterLabel.setText((CharSequence)String.format(counterLabelResourceStr, lengthStr, Integer.toString(this.minCharacters), "+", ""));
            if (performValidation) {
                if (length < this.minCharacters) {
                    this.setCounterError();
                } else {
                    this.removeCounterError();
                }
            }
        } else {
            this.counterLabel.setText((CharSequence)"");
            if (performValidation) {
                this.removeCounterError();
            }
        }
    }

    protected void updateBottomViewVisibility() {
        if (this.helperLabel.getText().toString().isEmpty() && this.counterLabel.getText().toString().isEmpty()) {
            this.bottomPart.setVisibility(8);
        } else {
            this.bottomPart.setVisibility(0);
        }
    }

    protected void setCounterError() {
        this.onError = true;
        this.setHighlightColor(this.errorColor);
        this.counterLabel.setTextColor(this.errorColor);
    }

    protected void removeCounterError() {
        this.onError = false;
        if (this.hasFocus) {
            this.setHighlightColor(this.primaryColor);
        } else {
            this.setHighlightColor(this.secondaryColor);
        }
        this.counterLabel.setTextColor(this.counterTextColor);
    }

    public void setError(@Nullable String errorText, boolean giveFocus) {
        if (this.enabled) {
            this.onError = true;
            this.activate(true);
            this.setHighlightColor(this.errorColor);
            this.helperLabel.setTextColor(this.errorColor);
            if (errorText != null) {
                this.helperLabel.setText((CharSequence)errorText);
                this.updateBottomViewVisibility();
            }
            if (giveFocus) {
                this.setHasFocus(true);
            }
            this.makeCursorBlink();
        }
    }

    public void removeError() {
        this.onError = false;
        if (this.hasFocus) {
            this.setHighlightColor(this.primaryColor);
        } else {
            this.setHighlightColor(this.secondaryColor);
        }
        this.helperLabel.setTextColor(this.helperTextColor);
        this.helperLabel.setText((CharSequence)this.helperText);
        this.updateBottomViewVisibility();
    }

    protected void showClearButton(boolean show) {
        if (show) {
            this.clearButton.setVisibility(0);
        } else {
            this.clearButton.setVisibility(8);
        }
    }

    private void triggerSetters() {
        this.setLabelText(this.labelText);
        this.setHelperText(this.helperText);
        this.setHelperTextColor(this.helperTextColor);
        this.setCounterTextColor(this.counterTextColor);
        this.setErrorColor(this.errorColor);
        this.setPrimaryColor(this.primaryColor);
        this.setSecondaryColor(this.secondaryColor);
        this.setPanelBackgroundColor(this.panelBackgroundColor);
        this.setMaxCharacters(this.maxCharacters);
        this.setMinCharacters(this.minCharacters);
        this.setEnabled(this.enabled);
        this.setIconSignifier(this.iconSignifierResourceId);
        this.setEndIcon(this.endIconResourceId);
        this.setIsResponsiveIconColor(this.isResponsiveIconColor);
        this.setHasClearButton(this.hasClearButton);
        this.setHasFocus(this.hasFocus);
        this.setAlwaysShowHint(this.alwaysShowHint);
        this.updateCounterText(!this.isManualValidateError);
        this.updateBottomViewVisibility();
    }

    public void setLabelText(String labelText) {
        this.labelText = labelText;
        this.floatingLabel.setText((CharSequence)this.labelText);
        if (labelText.isEmpty()) {
            this.floatingLabel.setVisibility(8);
            this.labelSpace.setVisibility(8);
            this.labelSpaceBelow.setVisibility(0);
        } else {
            this.floatingLabel.setVisibility(0);
            this.labelSpace.setVisibility(0);
            this.labelSpaceBelow.setVisibility(8);
        }
    }

    public void setHelperText(String helperText) {
        this.helperText = helperText;
        this.helperLabel.setText((CharSequence)this.helperText);
    }

    public void setHelperTextColor(int colorRes) {
        this.helperTextColor = colorRes;
        this.helperLabel.setTextColor(this.helperTextColor);
    }

    public void setCounterTextColor(int colorRes) {
        this.counterTextColor = colorRes;
        this.counterLabel.setTextColor(this.counterTextColor);
    }

    public void setErrorColor(int colorRes) {
        this.errorColor = colorRes;
    }

    public void setPrimaryColor(int colorRes) {
        this.primaryColor = colorRes;
        if (this.hasFocus) {
            this.setHighlightColor(this.primaryColor);
        }
    }

    public void setSecondaryColor(int colorRes) {
        this.secondaryColor = colorRes;
        if (!this.hasFocus) {
            this.setHighlightColor(this.secondaryColor);
        }
    }

    public void setPanelBackgroundColor(int colorRes) {
        this.panelBackgroundColor = colorRes;
        this.panel.getBackground().setColorFilter((ColorFilter)new PorterDuffColorFilter(colorRes, PorterDuff.Mode.SRC_IN));
    }

    public void setMaxCharacters(int maxCharacters) {
        this.maxCharacters = maxCharacters;
        this.updateCounterText(!this.isManualValidateError);
    }

    public void removeMaxCharacters() {
        this.maxCharacters = 0;
        this.updateCounterText(!this.isManualValidateError);
    }

    public void setMinCharacters(int minCharacters) {
        this.minCharacters = minCharacters;
        this.updateCounterText(!this.isManualValidateError);
    }

    public void removeMinCharacters() {
        this.minCharacters = 0;
        this.updateCounterText(!this.isManualValidateError);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.enabled) {
            this.editText.setEnabled(true);
            this.editText.setFocusableInTouchMode(true);
            this.editText.setFocusable(true);
            this.helperLabel.setVisibility(0);
            this.counterLabel.setVisibility(0);
            this.bottomLine.setVisibility(0);
            this.panel.setEnabled(true);
            this.iconImageButton.setEnabled(true);
            this.iconImageButton.setClickable(true);
            this.setHighlightColor(this.secondaryColor);
            this.updateCounterText(!this.isManualValidateError);
        } else {
            this.removeError();
            this.setHasFocus(false);
            this.editText.setEnabled(false);
            this.editText.setFocusableInTouchMode(false);
            this.editText.setFocusable(false);
            this.iconImageButton.setClickable(false);
            this.iconImageButton.setEnabled(false);
            this.helperLabel.setVisibility(4);
            this.counterLabel.setVisibility(4);
            this.bottomLine.setVisibility(4);
            this.panel.setEnabled(false);
            this.setHighlightColor(this.DEFAULT_DISABLED_TEXT_COLOR);
        }
    }

    public void setIconSignifier(int resourceID) {
        this.iconSignifierResourceId = resourceID;
        if (this.iconSignifierResourceId != 0) {
            this.iconImageButton.setImageResource(this.iconSignifierResourceId);
            this.iconImageButton.setVisibility(0);
        } else {
            this.removeIconSignifier();
        }
    }

    public void setIconSignifier(Drawable drawable) {
        this.removeIconSignifier();
        this.iconImageButton.setImageDrawable(drawable);
        this.iconImageButton.setVisibility(0);
    }

    public void removeIconSignifier() {
        this.iconSignifierResourceId = 0;
        this.iconImageButton.setVisibility(8);
    }

    public void setEndIcon(int resourceID) {
        this.endIconResourceId = resourceID;
        if (this.endIconResourceId != 0) {
            this.endIconImageButton.setImageResource(this.endIconResourceId);
            this.endIconImageButton.setVisibility(0);
        } else {
            this.removeEndIcon();
        }
    }

    public void setEndIcon(Drawable drawable) {
        this.removeEndIcon();
        this.endIconImageButton.setImageDrawable(drawable);
        this.endIconImageButton.setVisibility(0);
    }

    public void removeEndIcon() {
        this.endIconResourceId = 0;
        this.endIconImageButton.setVisibility(8);
    }

    public void setIsResponsiveIconColor(boolean isResponsiveIconColor) {
        this.isResponsiveIconColor = isResponsiveIconColor;
        if (this.isResponsiveIconColor) {
            if (this.hasFocus) {
                this.iconImageButton.setColorFilter(this.primaryColor);
                this.iconImageButton.setAlpha(1.0f);
            } else {
                this.iconImageButton.setColorFilter(this.secondaryColor);
                this.iconImageButton.setAlpha(0.54f);
            }
        } else {
            this.iconImageButton.setColorFilter(this.primaryColor);
            this.iconImageButton.setAlpha(1.0f);
        }
    }

    public void setHasClearButton(boolean hasClearButton) {
        this.hasClearButton = hasClearButton;
    }

    public void setHasFocus(boolean hasFocus) {
        this.hasFocus = hasFocus;
        if (this.hasFocus) {
            this.activate(true);
            this.editText.requestFocus();
            this.makeCursorBlink();
            if (!this.onError && this.enabled) {
                this.setHighlightColor(this.primaryColor);
            }
        } else {
            this.deactivate();
            if (!this.onError && this.enabled) {
                this.setHighlightColor(this.secondaryColor);
            }
        }
    }

    public void setAlwaysShowHint(boolean alwaysShowHint) {
        this.alwaysShowHint = alwaysShowHint;
    }

    public void setUseDenseSpacing(boolean useDenseSpacing) {
        this.useDenseSpacing = useDenseSpacing;
    }

    public String getLabelText() {
        return this.labelText;
    }

    public String getHelperText() {
        return this.helperText;
    }

    public String getCounterText() {
        return this.counterLabel.getText().toString();
    }

    public int getHelperTextColor() {
        return this.helperTextColor;
    }

    public int getCounterTextColor() {
        return this.counterTextColor;
    }

    public int getErrorColor() {
        return this.errorColor;
    }

    public int getPrimaryColor() {
        return this.primaryColor;
    }

    public int getSecondaryColor() {
        return this.secondaryColor;
    }

    public int getPanelBackgroundColor() {
        return this.panelBackgroundColor;
    }

    public int getMaxCharacters() {
        return this.maxCharacters;
    }

    public int getMinCharacters() {
        return this.minCharacters;
    }

    public View getPanel() {
        return this.panel;
    }

    public View getBottomLine() {
        return this.bottomLine;
    }

    public AppCompatTextView getHelperLabel() {
        return this.helperLabel;
    }

    public AppCompatTextView getCounterLabel() {
        return this.counterLabel;
    }

    public AppCompatTextView getFloatingLabel() {
        return this.floatingLabel;
    }

    public AppCompatImageButton getIconImageButton() {
        return this.iconImageButton;
    }

    public AppCompatImageButton getEndIconImageButton() {
        return this.endIconImageButton;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isOnError() {
        return this.onError;
    }

    public int getIconSignifierResourceId() {
        return this.iconSignifierResourceId;
    }

    public int getEndIconResourceId() {
        return this.endIconResourceId;
    }

    public boolean getIsResponsiveIconColor() {
        return this.isResponsiveIconColor;
    }

    public boolean getHasClearButton() {
        return this.hasClearButton;
    }

    public boolean getHasFocus() {
        return this.hasFocus;
    }

    public boolean getAlwaysShowHint() {
        return this.alwaysShowHint;
    }

    public boolean getUseDenseSpacing() {
        return this.useDenseSpacing;
    }

    protected static void setCursorDrawableColor(EditText _editText, int _colorRes) {
        try {
            Field fCursorDrawableRes = TextView.class.getDeclaredField("mCursorDrawableRes");
            fCursorDrawableRes.setAccessible(true);
            int mCursorDrawableRes = fCursorDrawableRes.getInt(_editText);
            Field fEditor = TextView.class.getDeclaredField("mEditor");
            fEditor.setAccessible(true);
            Object editor = fEditor.get(_editText);
            Class<?> clazz = editor.getClass();
            Field fCursorDrawable = clazz.getDeclaredField("mCursorDrawable");
            fCursorDrawable.setAccessible(true);
            Drawable[] drawables = new Drawable[]{ContextCompat.getDrawable((Context)_editText.getContext(), (int)mCursorDrawableRes), ContextCompat.getDrawable((Context)_editText.getContext(), (int)mCursorDrawableRes)};
            drawables[0].setColorFilter(_colorRes, PorterDuff.Mode.SRC_IN);
            drawables[1].setColorFilter(_colorRes, PorterDuff.Mode.SRC_IN);
            fCursorDrawable.set(editor, drawables);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected static int lighter(int color2, float factor) {
        int red = (int)(((float)Color.red((int)color2) * (1.0f - factor) / 255.0f + factor) * 255.0f);
        int green = (int)(((float)Color.green((int)color2) * (1.0f - factor) / 255.0f + factor) * 255.0f);
        int blue = (int)(((float)Color.blue((int)color2) * (1.0f - factor) / 255.0f + factor) * 255.0f);
        return Color.argb((int)Color.alpha((int)color2), (int)red, (int)green, (int)blue);
    }

    protected static boolean isLight(int color2) {
        return Math.sqrt((double)(Color.red((int)color2) * Color.red((int)color2)) * 0.241 + (double)(Color.green((int)color2) * Color.green((int)color2)) * 0.691 + (double)(Color.blue((int)color2) * Color.blue((int)color2)) * 0.068) > 130.0;
    }

    protected static int adjustAlpha(int color2, float _toAlpha) {
        int alpha = Math.round(255.0f * _toAlpha);
        int red = Color.red((int)color2);
        int green = Color.green((int)color2);
        int blue = Color.blue((int)color2);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }
}

