/*
 * Decompiled with CFR 0.152.
 */
package studio.carbonylgroup.textfieldboxes;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.AppCompatTextView;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import studio.carbonylgroup.textfieldboxes.ExtendedEditText;
import studio.carbonylgroup.textfieldboxes.R;
import studio.carbonylgroup.textfieldboxes.Utils;

public class TextFieldBoxes
extends FrameLayout {
    public int DEFAULT_ERROR_COLOR;
    public int DEFAULT_PRIMARY_COLOR;
    public int DEFAULT_TEXT_COLOR;
    public int DEFAULT_DISABLED_TEXT_COLOR;
    public int DEFAULT_BG_COLOR;
    protected boolean enabled;
    protected String text;
    protected String hint;
    protected String helperText;
    protected String prefix;
    protected String suffix;
    protected boolean singleLine;
    protected int maxLines;
    protected int maxCharacters;
    protected int minCharacters;
    protected int helperTextColor;
    protected int errorColor;
    protected int primaryColor;
    protected int prefixTextColor;
    protected int suffixTextColor;
    protected int panelBackgroundColor;
    protected int iconSignifierResourceId;
    protected boolean hasFocus;
    protected View panel;
    protected FrameLayout bottomLine;
    protected ViewGroup editTextLayout;
    protected ExtendedEditText editText;
    protected AppCompatTextView hintLabel;
    protected AppCompatTextView helperLabel;
    protected AppCompatTextView counterLabel;
    protected AppCompatImageView iconImageView;
    protected InputMethodManager inputMethodManager;
    protected int labelColor = -1;
    protected int labelTopMargin = -1;
    protected int ANIMATION_DURATION = 100;
    protected boolean onError = false;
    protected boolean activated = false;

    public TextFieldBoxes(Context context) {
        super(context);
        this.init();
    }

    public TextFieldBoxes(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
        this.handleAttributes(context, attrs);
    }

    public TextFieldBoxes(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
        this.handleAttributes(context, attrs);
    }

    protected void init() {
        this.initDefaultColor();
        this.inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
    }

    protected void initDefaultColor() {
        Resources.Theme theme = this.getContext().getTheme();
        this.DEFAULT_ERROR_COLOR = this.getContext().getResources().getColor(R.color.A400red);
        TypedArray themeArray = theme.obtainStyledAttributes(new int[]{0x1010030});
        this.DEFAULT_BG_COLOR = Utils.adjustAlpha(themeArray.getColor(0, 0), 0.06f);
        themeArray = theme.obtainStyledAttributes(new int[]{R.attr.colorPrimary});
        this.DEFAULT_PRIMARY_COLOR = Utils.isLight(this.DEFAULT_BG_COLOR) ? Utils.lighter(themeArray.getColor(0, 0), 0.2f) : themeArray.getColor(0, 0);
        themeArray = theme.obtainStyledAttributes(new int[]{0x1010212});
        this.DEFAULT_TEXT_COLOR = themeArray.getColor(0, 0);
        themeArray = theme.obtainStyledAttributes(new int[]{0x1010033});
        float disabledAlpha = themeArray.getFloat(0, 0.0f);
        themeArray = theme.obtainStyledAttributes(new int[]{0x1010212});
        this.DEFAULT_DISABLED_TEXT_COLOR = Utils.adjustAlpha(themeArray.getColor(0, 0), disabledAlpha);
        themeArray.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.addView(LayoutInflater.from((Context)this.getContext()).inflate(R.layout.text_field_boxes_layout, (ViewGroup)this, false));
        this.panel = this.findViewById(R.id.text_field_boxes_panel);
        this.editTextLayout = (ViewGroup)this.findViewById(R.id.text_field_boxes_editTextLayout);
        this.editText = (ExtendedEditText)this.findViewById(R.id.text_field_boxes_editText);
        this.editText.setBackgroundColor(0);
        this.editText.setAlpha(0.0f);
        this.hintLabel = (AppCompatTextView)this.findViewById(R.id.text_field_boxes_label);
        this.hintLabel.setPivotX(0.0f);
        this.hintLabel.setPivotY(0.0f);
        this.labelColor = this.hintLabel.getCurrentTextColor();
        this.labelTopMargin = ((RelativeLayout.LayoutParams)RelativeLayout.LayoutParams.class.cast((Object)this.hintLabel.getLayoutParams())).topMargin;
        this.helperLabel = (AppCompatTextView)this.findViewById(R.id.text_field_boxes_helper);
        this.counterLabel = (AppCompatTextView)this.findViewById(R.id.text_field_boxes_counter);
        this.iconImageView = (AppCompatImageView)this.findViewById(R.id.text_field_boxes_imageView);
        this.bottomLine = (FrameLayout)this.findViewById(R.id.bg_bottom_line);
        this.panel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!TextFieldBoxes.this.isActivated()) {
                    TextFieldBoxes.this.activate(true);
                }
                TextFieldBoxes.this.setHasFocus(true);
                TextFieldBoxes.this.inputMethodManager.showSoftInput((View)TextFieldBoxes.this.editText, 1);
            }
        });
        this.iconImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!TextFieldBoxes.this.isActivated()) {
                    TextFieldBoxes.this.activate(true);
                }
                TextFieldBoxes.this.setHasFocus(true);
                TextFieldBoxes.this.inputMethodManager.showSoftInput((View)TextFieldBoxes.this.editText, 1);
            }
        });
        this.editText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean b) {
                if (b) {
                    TextFieldBoxes.this.setHasFocus(true);
                } else {
                    TextFieldBoxes.this.setHasFocus(false);
                }
            }
        });
        this.editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                TextFieldBoxes.this.text = TextFieldBoxes.this.editText.getText().toString();
                TextFieldBoxes.this.removeError();
                TextFieldBoxes.this.updateCounterText();
            }
        });
        this.setText(this.text);
        this.setHint(this.hint);
        this.setHelperText(this.helperText);
        this.setPrefix(this.prefix);
        this.setSuffix(this.suffix);
        this.setHelperTextColor(this.helperTextColor);
        this.setErrorColor(this.errorColor);
        this.setPrimaryColor(this.primaryColor);
        this.setPrefixTextColor(this.prefixTextColor);
        this.setSuffixTextColor(this.suffixTextColor);
        this.setPanelBackgroundColor(this.panelBackgroundColor);
        this.setMaxCharacters(this.maxCharacters);
        this.setMinCharacters(this.minCharacters);
        this.setEnabled(this.enabled);
        this.setSingleLine(this.singleLine);
        this.setMaxLines(this.maxLines);
        this.setIconSignifier(this.iconSignifierResourceId);
        this.setHasFocus(this.hasFocus);
        this.updateCounterText();
    }

    protected void handleAttributes(Context context, AttributeSet attrs) {
        try {
            TypedArray styledAttrs = context.obtainStyledAttributes(attrs, R.styleable.TextFieldBoxes);
            this.text = styledAttrs.getString(R.styleable.TextFieldBoxes_text) == null ? "" : styledAttrs.getString(R.styleable.TextFieldBoxes_text);
            this.hint = styledAttrs.getString(R.styleable.TextFieldBoxes_hint) == null ? "" : styledAttrs.getString(R.styleable.TextFieldBoxes_hint);
            this.helperText = styledAttrs.getString(R.styleable.TextFieldBoxes_helperText) == null ? "" : styledAttrs.getString(R.styleable.TextFieldBoxes_helperText);
            this.prefix = styledAttrs.getString(R.styleable.TextFieldBoxes_prefix) == null ? "" : styledAttrs.getString(R.styleable.TextFieldBoxes_prefix);
            this.suffix = styledAttrs.getString(R.styleable.TextFieldBoxes_suffix) == null ? "" : styledAttrs.getString(R.styleable.TextFieldBoxes_suffix);
            this.helperTextColor = styledAttrs.getInt(R.styleable.TextFieldBoxes_helperTextColor, this.DEFAULT_TEXT_COLOR);
            this.errorColor = styledAttrs.getInt(R.styleable.TextFieldBoxes_errorColor, this.DEFAULT_ERROR_COLOR);
            this.primaryColor = styledAttrs.getColor(R.styleable.TextFieldBoxes_primaryColor, this.DEFAULT_PRIMARY_COLOR);
            this.prefixTextColor = styledAttrs.getInt(R.styleable.TextFieldBoxes_prefixTextColor, this.DEFAULT_TEXT_COLOR);
            this.suffixTextColor = styledAttrs.getInt(R.styleable.TextFieldBoxes_suffixTextColor, this.DEFAULT_TEXT_COLOR);
            this.panelBackgroundColor = styledAttrs.getColor(R.styleable.TextFieldBoxes_panelBackgroundColor, this.DEFAULT_BG_COLOR);
            this.maxCharacters = styledAttrs.getInt(R.styleable.TextFieldBoxes_maxCharacters, 0);
            this.minCharacters = styledAttrs.getInt(R.styleable.TextFieldBoxes_minCharacters, 0);
            this.enabled = styledAttrs.getBoolean(R.styleable.TextFieldBoxes_enabled, true);
            this.singleLine = styledAttrs.getBoolean(R.styleable.TextFieldBoxes_singleLine, false);
            this.maxLines = styledAttrs.getInt(R.styleable.TextFieldBoxes_maxLines, Integer.MAX_VALUE);
            this.iconSignifierResourceId = styledAttrs.getResourceId(R.styleable.TextFieldBoxes_iconSignifier, 0);
            this.hasFocus = styledAttrs.getBoolean(R.styleable.TextFieldBoxes_hasFocus, false);
            styledAttrs.recycle();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void deactivate() {
        if (this.editText.getText().toString().equals("")) {
            ViewCompat.animate((View)this.hintLabel).alpha(1.0f).scaleX(1.0f).scaleY(1.0f).translationY(0.0f).setDuration((long)this.ANIMATION_DURATION);
            this.editText.setVisibility(8);
            if (this.editText.hasFocus()) {
                this.inputMethodManager.hideSoftInputFromWindow(this.editText.getWindowToken(), 0);
                this.editText.clearFocus();
            }
        }
        this.activated = false;
    }

    protected void activate(boolean animated) {
        this.editText.setVisibility(0);
        if (animated) {
            if (this.editText.getText().toString().equals("") && !this.isActivated()) {
                this.editText.setAlpha(0.0f);
                this.hintLabel.setScaleX(1.0f);
                this.hintLabel.setScaleY(1.0f);
                this.hintLabel.setTranslationY(0.0f);
            }
            ViewCompat.animate((View)this.editText).alpha(1.0f).setDuration((long)this.ANIMATION_DURATION);
            ViewCompat.animate((View)this.hintLabel).scaleX(0.75f).scaleY(0.75f).translationY((float)(-this.labelTopMargin + this.getContext().getResources().getDimensionPixelOffset(R.dimen.text_field_boxes_margin_top))).setDuration((long)this.ANIMATION_DURATION);
        } else {
            this.editText.setAlpha(1.0f);
            this.hintLabel.setScaleX(0.75f);
            this.hintLabel.setScaleY(0.75f);
            this.hintLabel.setTranslationY((float)(-this.labelTopMargin + this.getContext().getResources().getDimensionPixelOffset(R.dimen.text_field_boxes_margin_top)));
        }
        this.activated = true;
    }

    protected void setHighlightColor(int colorRes) {
        this.hintLabel.setTextColor(colorRes);
        Utils.setCursorDrawableColor((EditText)this.editText, colorRes);
        this.iconImageView.setColorFilter(colorRes);
        if (colorRes == this.DEFAULT_TEXT_COLOR) {
            this.iconImageView.setAlpha(0.54f);
        } else {
            this.iconImageView.setAlpha(1.0f);
        }
        if (colorRes == this.DEFAULT_DISABLED_TEXT_COLOR) {
            this.iconImageView.setAlpha(0.35f);
        }
        this.bottomLine.setBackgroundColor(colorRes);
    }

    protected void updateCounterText() {
        int length = this.getText().replaceAll(" ", "").replaceAll("\n", "").length();
        String lengthStr = Integer.toString(length) + " / ";
        if (this.maxCharacters > 0) {
            if (this.minCharacters > 0) {
                this.counterLabel.setText((CharSequence)(lengthStr + Integer.toString(this.minCharacters) + "-" + Integer.toString(this.maxCharacters)));
                if (length < this.minCharacters || length > this.maxCharacters) {
                    this.setCounterError();
                } else {
                    this.removeCounterError();
                }
            } else {
                this.counterLabel.setText((CharSequence)(lengthStr + Integer.toString(this.maxCharacters)));
                if (length > this.maxCharacters) {
                    this.setCounterError();
                } else {
                    this.removeCounterError();
                }
            }
        } else if (this.minCharacters > 0) {
            this.counterLabel.setText((CharSequence)(lengthStr + Integer.toString(this.minCharacters) + "+"));
            if (length < this.minCharacters) {
                this.setCounterError();
            } else {
                this.removeCounterError();
            }
        } else {
            this.counterLabel.setText((CharSequence)"");
        }
    }

    protected void setCounterError() {
        this.onError = true;
        this.setHighlightColor(this.errorColor);
        this.counterLabel.setTextColor(this.errorColor);
    }

    protected void removeCounterError() {
        this.onError = false;
        if (this.hasFocus) {
            this.setHighlightColor(this.primaryColor);
        } else {
            this.setHighlightColor(this.DEFAULT_TEXT_COLOR);
        }
        this.counterLabel.setTextColor(this.DEFAULT_TEXT_COLOR);
    }

    public void setError(String _errorText) {
        if (this.enabled) {
            this.onError = true;
            this.setHighlightColor(this.errorColor);
            this.helperLabel.setTextColor(this.errorColor);
            this.helperLabel.setText((CharSequence)_errorText);
        }
    }

    public void removeError() {
        this.onError = false;
        if (this.hasFocus) {
            this.setHighlightColor(this.primaryColor);
        } else {
            this.setHighlightColor(this.DEFAULT_TEXT_COLOR);
        }
        this.helperLabel.setTextColor(this.helperTextColor);
        this.helperLabel.setText((CharSequence)this.helperText);
    }

    public void setText(String _text) {
        if (_text != null) {
            this.text = _text;
            this.editText.setText(this.text);
            if (!_text.equals("")) {
                this.activate(false);
            }
        }
    }

    public void setHint(String _hint) {
        this.hint = _hint;
        this.hintLabel.setText((CharSequence)this.hint);
    }

    public void setHelperText(String _helperText) {
        this.helperText = _helperText;
        this.helperLabel.setText((CharSequence)this.helperText);
    }

    public void setPrefix(String _prefix) {
        this.prefix = _prefix;
        this.editText.setPrefix(this.prefix);
    }

    public void setSuffix(String _suffix) {
        this.suffix = _suffix;
        this.editText.setSuffix(this.suffix);
    }

    public void setHelperTextColor(int _colorRes) {
        this.helperTextColor = _colorRes;
        this.helperLabel.setTextColor(this.helperTextColor);
    }

    public void setErrorColor(int _colorRes) {
        this.errorColor = _colorRes;
    }

    public void setPrimaryColor(int _colorRes) {
        this.primaryColor = _colorRes;
        if (this.hasFocus) {
            this.setHighlightColor(this.primaryColor);
        }
    }

    public void setPrefixTextColor(int _colorRes) {
        this.prefixTextColor = _colorRes;
        this.editText.setPrefixTextColor(this.prefixTextColor);
    }

    public void setSuffixTextColor(int _colorRes) {
        this.suffixTextColor = _colorRes;
        this.editText.setSuffixTextColor(this.suffixTextColor);
    }

    public void setPanelBackgroundColor(int _colorRes) {
        this.panelBackgroundColor = _colorRes;
        ((GradientDrawable)((LayerDrawable)this.panel.getBackground()).findDrawableByLayerId(R.id.bg_cover)).setColor(this.panelBackgroundColor);
    }

    public void setMaxCharacters(int _maxCharacters) {
        this.maxCharacters = _maxCharacters;
    }

    public void removeMaxCharacters() {
        this.maxCharacters = 0;
    }

    public void setMinCharacters(int _minCharacters) {
        this.minCharacters = _minCharacters;
    }

    public void removeMinCharacters() {
        this.minCharacters = 0;
    }

    public void setEnabled(boolean _enabled) {
        this.enabled = _enabled;
        if (this.enabled) {
            this.editText.setEnabled(true);
            this.editText.setFocusableInTouchMode(true);
            this.editText.setFocusable(true);
            this.helperLabel.setVisibility(0);
            this.counterLabel.setVisibility(0);
            this.bottomLine.setVisibility(0);
            this.panel.setEnabled(true);
            this.iconImageView.setEnabled(true);
            this.iconImageView.setClickable(true);
            this.setHighlightColor(this.DEFAULT_TEXT_COLOR);
            this.updateCounterText();
        } else {
            this.removeError();
            this.setHasFocus(false);
            this.editText.setEnabled(false);
            this.editText.setFocusableInTouchMode(false);
            this.editText.setFocusable(false);
            this.iconImageView.setClickable(false);
            this.iconImageView.setEnabled(false);
            this.setHighlightColor(this.DEFAULT_DISABLED_TEXT_COLOR);
            this.helperLabel.setVisibility(4);
            this.counterLabel.setVisibility(4);
            this.bottomLine.setVisibility(4);
            this.panel.setEnabled(false);
        }
    }

    public void setSingleLine(boolean _singleLine) {
        this.singleLine = _singleLine;
        this.editText.setSingleLine(this.singleLine);
    }

    public void setMaxLines(int _maxLines) {
        this.maxLines = _maxLines;
        this.editText.setMaxLines(this.maxLines);
    }

    public void removeMaxLines() {
        this.maxLines = Integer.MAX_VALUE;
        this.editText.setMaxLines(this.maxLines);
    }

    public void setIconSignifier(int resourceID) {
        this.iconSignifierResourceId = resourceID;
        if (this.iconSignifierResourceId != 0) {
            this.iconImageView.setImageResource(this.iconSignifierResourceId);
            this.iconImageView.setVisibility(0);
        } else {
            this.removeIconSignifier();
        }
    }

    public void removeIconSignifier() {
        this.iconSignifierResourceId = 0;
        this.iconImageView.setVisibility(8);
    }

    public void setHasFocus(boolean _hasFocus) {
        this.hasFocus = _hasFocus;
        if (_hasFocus) {
            this.activate(false);
            this.editText.requestFocus();
            if (!this.onError && this.enabled) {
                this.setHighlightColor(this.primaryColor);
            }
        } else {
            this.deactivate();
            if (!this.onError && this.enabled) {
                this.setHighlightColor(this.DEFAULT_TEXT_COLOR);
            }
        }
    }

    public EditText getEditText() {
        return this.editText;
    }

    public String getText() {
        return this.text;
    }

    public String getHint() {
        return this.hint;
    }

    public String getHelperText() {
        return this.helperText;
    }

    public String getCounterText() {
        return this.counterLabel.getText().toString();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public int getHelperTextColor() {
        return this.helperTextColor;
    }

    public int getErrorColor() {
        return this.errorColor;
    }

    public int getPrimaryColor() {
        return this.primaryColor;
    }

    public int getPrefixTextColor() {
        return this.prefixTextColor;
    }

    public int getSuffixTextColor() {
        return this.suffixTextColor;
    }

    public int getPanelBackgroundColor() {
        return this.panelBackgroundColor;
    }

    public int getMaxCharacters() {
        return this.maxCharacters;
    }

    public int getMinCharacters() {
        return this.minCharacters;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean getSingleLine() {
        return this.singleLine;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public int getIconSignifierResourceId() {
        return this.iconSignifierResourceId;
    }

    public boolean getHasFocus() {
        return this.hasFocus;
    }
}

