/*
 * Decompiled with CFR 0.152.
 */
package studio.carbonylgroup.textfieldboxes;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.AppCompatTextView;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import studio.carbonylgroup.textfieldboxes.R;
import studio.carbonylgroup.textfieldboxes.Utils;

public class TextFieldBoxes
extends FrameLayout {
    public final int DEFAULT_TEXT_COLOR = this.getContext().getResources().getColor(R.color.per54black);
    public final int DEFAULT_ERROR_COLOR = this.getContext().getResources().getColor(R.color.A400red);
    public final int DEFAULT_DISABLED_TEXT_COLOR = this.getContext().getResources().getColor(R.color.per42black);
    public final int DEFAULT_DISABLED_BG_COLOR = this.getContext().getResources().getColor(R.color.per10black);
    public final int DEFAULT_ENABLED_BG_COLOR = this.getContext().getResources().getColor(R.color.per06black);
    protected boolean enabled;
    protected String text;
    protected String hint;
    protected String helperText;
    protected boolean singleLine;
    protected int maxLines;
    protected int maxCharacters;
    protected int minCharacters;
    protected int helperTextColor;
    protected int errorColor;
    protected int primaryColor;
    protected boolean hasFocus;
    public View card;
    public TextView label;
    public EditText editText;
    public ViewGroup editTextLayout;
    public AppCompatTextView helper;
    public AppCompatTextView counter;
    protected InputMethodManager inputMethodManager;
    protected int labelColor = -1;
    protected int labelTopMargin = -1;
    protected int ANIMATION_DURATION = 100;
    protected boolean onError = false;
    protected boolean activated = false;

    public TextFieldBoxes(Context context) {
        super(context);
        this.init();
    }

    public TextFieldBoxes(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.handleAttributes(context, attrs);
        this.init();
    }

    public TextFieldBoxes(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.handleAttributes(context, attrs);
        this.init();
    }

    protected void init() {
        this.inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.addView(LayoutInflater.from((Context)this.getContext()).inflate(R.layout.text_field_boxes_layout, (ViewGroup)this, false));
        this.card = this.findViewById(R.id.text_field_boxes_card);
        this.editTextLayout = (ViewGroup)this.findViewById(R.id.text_field_boxes_editTextLayout);
        this.editText = (EditText)this.findViewById(R.id.text_field_boxes_editText);
        this.editText.setBackgroundColor(0);
        this.editText.setAlpha(0.0f);
        this.label = (TextView)this.findViewById(R.id.text_field_boxes_label);
        this.label.setPivotX(0.0f);
        this.label.setPivotY(0.0f);
        this.labelColor = this.label.getCurrentTextColor();
        this.labelTopMargin = ((RelativeLayout.LayoutParams)RelativeLayout.LayoutParams.class.cast((Object)this.label.getLayoutParams())).topMargin;
        this.helper = (AppCompatTextView)this.findViewById(R.id.text_field_boxes_helper);
        this.counter = (AppCompatTextView)this.findViewById(R.id.text_field_boxes_counter);
        this.card.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!TextFieldBoxes.this.isActivated()) {
                    TextFieldBoxes.this.activate(true);
                }
                TextFieldBoxes.this.setHasFocus(true);
                TextFieldBoxes.this.inputMethodManager.showSoftInput((View)TextFieldBoxes.this.editText, 1);
            }
        });
        this.editText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean b) {
                if (b) {
                    TextFieldBoxes.this.setHasFocus(true);
                } else {
                    TextFieldBoxes.this.setHasFocus(false);
                }
            }
        });
        this.editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                TextFieldBoxes.this.text = TextFieldBoxes.this.editText.getText().toString();
                TextFieldBoxes.this.removeError();
                TextFieldBoxes.this.updateCounterText();
            }
        });
        this.setEnabled(this.enabled);
        this.setText(this.text);
        this.setHint(this.hint);
        this.setSingleLine(this.singleLine);
        this.setMaxLines(this.maxLines);
        this.setMaxCharacters(this.maxCharacters);
        this.setMinCharacters(this.minCharacters);
        this.setHelperText(this.helperText);
        this.setHelperTextColor(this.helperTextColor);
        this.setErrorColor(this.errorColor);
        this.setPrimaryColor(this.primaryColor);
        this.setHasFocus(this.hasFocus);
        this.updateCounterText();
    }

    protected void handleAttributes(Context context, AttributeSet attrs) {
        try {
            TypedArray styledAttrs = context.obtainStyledAttributes(attrs, R.styleable.TextFieldBoxes);
            this.text = styledAttrs.getString(R.styleable.TextFieldBoxes_text) == null ? "" : styledAttrs.getString(R.styleable.TextFieldBoxes_text);
            this.hint = styledAttrs.getString(R.styleable.TextFieldBoxes_hint) == null ? "" : styledAttrs.getString(R.styleable.TextFieldBoxes_hint);
            this.singleLine = styledAttrs.getBoolean(R.styleable.TextFieldBoxes_singleLine, false);
            this.maxLines = styledAttrs.getInt(R.styleable.TextFieldBoxes_maxLines, Integer.MAX_VALUE);
            this.maxCharacters = styledAttrs.getInt(R.styleable.TextFieldBoxes_maxCharacters, 0);
            this.minCharacters = styledAttrs.getInt(R.styleable.TextFieldBoxes_minCharacters, 0);
            this.helperText = styledAttrs.getString(R.styleable.TextFieldBoxes_helperText) == null ? "" : styledAttrs.getString(R.styleable.TextFieldBoxes_helperText);
            this.helperTextColor = styledAttrs.getInt(R.styleable.TextFieldBoxes_helperTextColor, this.DEFAULT_TEXT_COLOR);
            this.errorColor = styledAttrs.getInt(R.styleable.TextFieldBoxes_errorColor, this.DEFAULT_ERROR_COLOR);
            this.primaryColor = styledAttrs.getColor(R.styleable.TextFieldBoxes_primaryColor, Utils.fetchPrimaryColor(this.getContext()));
            this.hasFocus = styledAttrs.getBoolean(R.styleable.TextFieldBoxes_hasFocus, false);
            this.enabled = styledAttrs.getBoolean(R.styleable.TextFieldBoxes_enabled, true);
            styledAttrs.recycle();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void deactivate() {
        if (this.editText.getText().toString().equals("")) {
            ViewCompat.animate((View)this.label).alpha(1.0f).scaleX(1.0f).scaleY(1.0f).translationY(0.0f).setDuration((long)this.ANIMATION_DURATION);
            this.editText.setVisibility(8);
            if (this.editText.hasFocus()) {
                this.inputMethodManager.hideSoftInputFromWindow(this.editText.getWindowToken(), 0);
                this.editText.clearFocus();
            }
        }
        this.activated = false;
    }

    protected void activate(boolean animated) {
        this.editText.setVisibility(0);
        if (animated) {
            if (this.editText.getText().toString().equals("") && !this.isActivated()) {
                this.editText.setAlpha(0.0f);
                this.label.setScaleX(1.0f);
                this.label.setScaleY(1.0f);
                this.label.setTranslationY(0.0f);
            }
            ViewCompat.animate((View)this.editText).alpha(1.0f).setDuration((long)this.ANIMATION_DURATION);
            ViewCompat.animate((View)this.label).scaleX(0.75f).scaleY(0.75f).translationY((float)(-this.labelTopMargin + this.getContext().getResources().getDimensionPixelOffset(R.dimen.text_field_boxes_margin_top))).setDuration((long)this.ANIMATION_DURATION);
        } else {
            this.editText.setAlpha(1.0f);
            this.label.setScaleX(0.75f);
            this.label.setScaleY(0.75f);
            this.label.setTranslationY((float)(-this.labelTopMargin + this.getContext().getResources().getDimensionPixelOffset(R.dimen.text_field_boxes_margin_top)));
        }
        this.activated = true;
    }

    protected void setHighlightColor(int colorRes) {
        this.label.setTextColor(colorRes);
        Utils.setCursorDrawableColor(this.editText, colorRes);
        ((GradientDrawable)((LayerDrawable)this.card.getBackground()).findDrawableByLayerId(R.id.bg_bottom_line)).setColor(colorRes);
    }

    protected void updateCounterText() {
        int length = this.getText().replaceAll(" ", "").replaceAll("\n", "").length();
        String lengthStr = Integer.toString(length) + " / ";
        if (this.maxCharacters > 0) {
            if (this.minCharacters > 0) {
                this.counter.setText((CharSequence)(lengthStr + Integer.toString(this.minCharacters) + "-" + Integer.toString(this.maxCharacters)));
                if (length < this.minCharacters || length > this.maxCharacters) {
                    this.setCounterError();
                } else {
                    this.removeCounterError();
                }
            } else {
                this.counter.setText((CharSequence)(lengthStr + Integer.toString(this.maxCharacters)));
                if (length > this.maxCharacters) {
                    this.setCounterError();
                } else {
                    this.removeCounterError();
                }
            }
        } else if (this.minCharacters > 0) {
            this.counter.setText((CharSequence)(lengthStr + Integer.toString(this.minCharacters) + "+"));
            if (length < this.minCharacters) {
                this.setCounterError();
            } else {
                this.removeCounterError();
            }
        } else {
            this.counter.setText((CharSequence)"");
        }
    }

    protected void setCounterError() {
        this.onError = true;
        this.setHighlightColor(this.errorColor);
        this.counter.setTextColor(this.errorColor);
    }

    protected void removeCounterError() {
        this.onError = false;
        if (this.hasFocus) {
            this.setHighlightColor(this.primaryColor);
        } else {
            this.setHighlightColor(this.DEFAULT_TEXT_COLOR);
        }
        this.counter.setTextColor(this.DEFAULT_TEXT_COLOR);
    }

    public void setEnabled(boolean _enabled) {
        this.enabled = _enabled;
        if (this.enabled) {
            this.editText.setEnabled(true);
            this.editText.setFocusableInTouchMode(true);
            this.editText.setFocusable(true);
            this.helper.setVisibility(0);
            this.counter.setVisibility(0);
            this.card.setEnabled(true);
            this.setHighlightColor(this.DEFAULT_TEXT_COLOR);
            ((GradientDrawable)((LayerDrawable)this.card.getBackground()).findDrawableByLayerId(R.id.bg_cover)).setColor(this.DEFAULT_ENABLED_BG_COLOR);
            this.updateCounterText();
        } else {
            this.removeError();
            this.setHasFocus(false);
            this.editText.setEnabled(false);
            this.editText.setFocusableInTouchMode(false);
            this.editText.setFocusable(false);
            this.label.setTextColor(this.DEFAULT_DISABLED_TEXT_COLOR);
            this.helper.setVisibility(4);
            this.counter.setVisibility(4);
            this.card.setEnabled(false);
            ((GradientDrawable)((LayerDrawable)this.card.getBackground()).findDrawableByLayerId(R.id.bg_cover)).setColor(this.DEFAULT_DISABLED_BG_COLOR);
            ((GradientDrawable)((LayerDrawable)this.card.getBackground()).findDrawableByLayerId(R.id.bg_bottom_line)).setColor(this.DEFAULT_DISABLED_BG_COLOR);
        }
    }

    public void setError(String _errorText) {
        if (this.enabled) {
            this.onError = true;
            this.setHighlightColor(this.errorColor);
            this.helper.setTextColor(this.errorColor);
            this.helper.setText((CharSequence)_errorText);
        }
    }

    public void removeError() {
        this.onError = false;
        if (this.hasFocus) {
            this.setHighlightColor(this.primaryColor);
        } else {
            this.setHighlightColor(this.DEFAULT_TEXT_COLOR);
        }
        this.helper.setTextColor(this.helperTextColor);
        this.helper.setText((CharSequence)this.helperText);
    }

    public void setText(String _text) {
        if (_text != null) {
            this.text = _text;
            this.editText.setText((CharSequence)this.text);
            if (!_text.equals("")) {
                this.activate(false);
            }
        }
    }

    public void setHint(String _hint) {
        this.hint = _hint;
        this.label.setText((CharSequence)this.hint);
    }

    public void setSingleLine(boolean _singleLine) {
        this.singleLine = _singleLine;
        this.editText.setSingleLine(this.singleLine);
    }

    public void setMaxLines(int _maxLines) {
        this.maxLines = _maxLines;
        this.editText.setMaxLines(this.maxLines);
    }

    public void removeMaxLines() {
        this.maxLines = Integer.MAX_VALUE;
        this.editText.setMaxLines(this.maxLines);
    }

    public void setMaxCharacters(int _maxCharacters) {
        this.maxCharacters = _maxCharacters;
    }

    public void removeMaxCharacters() {
        this.maxCharacters = 0;
    }

    public void setMinCharacters(int _minCharacters) {
        this.minCharacters = _minCharacters;
    }

    public void removeMinCharacters() {
        this.minCharacters = 0;
    }

    public void setHelperText(String _helperText) {
        this.helperText = _helperText;
        this.helper.setText((CharSequence)this.helperText);
    }

    public void setHelperTextColor(int _colorRes) {
        this.helperTextColor = _colorRes;
        this.helper.setTextColor(this.helperTextColor);
    }

    public void setErrorColor(int _colorRes) {
        this.errorColor = _colorRes;
    }

    public void setPrimaryColor(int _colorRes) {
        this.primaryColor = _colorRes;
        if (this.hasFocus) {
            this.setHighlightColor(this.primaryColor);
        }
    }

    public void setHasFocus(boolean _hasFocus) {
        this.hasFocus = _hasFocus;
        if (_hasFocus) {
            this.activate(false);
            this.editText.requestFocus();
            if (!this.onError && this.enabled) {
                this.setHighlightColor(this.primaryColor);
            }
        } else {
            this.deactivate();
            if (!this.onError && this.enabled) {
                this.setHighlightColor(this.DEFAULT_TEXT_COLOR);
            }
        }
    }

    public boolean isActivated() {
        return this.activated;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public EditText getEditText() {
        return this.editText;
    }

    public String getText() {
        return this.text;
    }

    public String getHint() {
        return this.hint;
    }

    public boolean getSingleLine() {
        return this.singleLine;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public int getMaxCharacters() {
        return this.maxCharacters;
    }

    public int getMinCharacters() {
        return this.minCharacters;
    }

    public String getHelperText() {
        return this.helperText;
    }

    public String getCounterText() {
        return this.counter.getText().toString();
    }

    public int getHelperTextColor() {
        return this.helperTextColor;
    }

    public int getErrorColor() {
        return this.errorColor;
    }

    public int getPrimaryColor() {
        return this.primaryColor;
    }

    public boolean getHasFocus() {
        return this.hasFocus;
    }
}

