/*
 * Decompiled with CFR 0.152.
 */
package com.hbisoft.pickit;

import android.app.Activity;
import android.content.ClipData;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.provider.DocumentsContract;
import android.util.Log;
import android.webkit.MimeTypeMap;
import com.hbisoft.pickit.CallBackTask;
import com.hbisoft.pickit.DownloadAsyncTask;
import com.hbisoft.pickit.PickiTCallbacks;
import com.hbisoft.pickit.Utils;
import java.io.File;
import java.util.ArrayList;

public class PickiT
implements CallBackTask {
    private final Context context;
    private final PickiTCallbacks pickiTCallbacks;
    private boolean isDriveFile = false;
    private boolean isMsfDownload = false;
    private boolean isFromUnknownProvider = false;
    private DownloadAsyncTask asyntask;
    private boolean unknownProviderCalledBefore = false;
    private final Activity mActivity;
    ArrayList<String> multiplePaths = new ArrayList();
    private boolean wasMultipleFileSelected = false;
    private int countMultiple;
    private int driveCountRef;
    private boolean enableProc = true;
    private boolean wasUriReturnedCalledBefore = false;
    private boolean wasPreExecuteCalledBefore = false;

    public PickiT(Context context, PickiTCallbacks listener, Activity activity) {
        this.context = context;
        this.pickiTCallbacks = listener;
        this.mActivity = activity;
    }

    public void getMultiplePaths(ClipData clipData) {
        this.wasMultipleFileSelected = true;
        this.countMultiple = clipData.getItemCount();
        for (int i = 0; i < clipData.getItemCount(); ++i) {
            Uri imageUri = clipData.getItemAt(i).getUri();
            this.getPath(imageUri, Build.VERSION.SDK_INT);
        }
        if (!this.isDriveFile) {
            this.pickiTCallbacks.PickiTonMultipleCompleteListener(this.multiplePaths, true, "");
            this.multiplePaths.clear();
            this.wasMultipleFileSelected = false;
            this.wasUriReturnedCalledBefore = false;
            this.wasPreExecuteCalledBefore = false;
        }
    }

    public void getPath(Uri uri, int APILevel) {
        block26: {
            if (APILevel >= 19) {
                String docId = null;
                try {
                    if (Build.VERSION.SDK_INT >= 19) {
                        docId = DocumentsContract.getDocumentId((Uri)uri);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.isOneDrive(uri) || this.isDropBox(uri) || this.isGoogleDrive(uri)) {
                    this.isDriveFile = true;
                    this.downloadFile(uri);
                } else if (docId != null && docId.startsWith("msf")) {
                    String fileName = Utils.getFilePath(this.context, uri);
                    try {
                        File file = new File(Environment.getExternalStorageDirectory().toString() + "/Download/" + fileName);
                        if (file.exists()) {
                            this.pickiTCallbacks.PickiTonCompleteListener(file.getAbsolutePath(), false, false, true, "");
                            break block26;
                        }
                        if (this.enableProc) {
                            try {
                                ParcelFileDescriptor parcelFileDescriptor = this.context.getContentResolver().openFileDescriptor(uri, "r");
                                int fd = parcelFileDescriptor.getFd();
                                int pid = Process.myPid();
                                String mediaFile = "/proc/" + pid + "/fd/" + fd;
                                File file1 = new File(mediaFile);
                                if (file1.exists() && file1.canRead() && file1.canWrite()) {
                                    this.pickiTCallbacks.PickiTonCompleteListener(file1.getAbsolutePath(), false, false, true, "");
                                    break block26;
                                }
                                this.isMsfDownload = true;
                                this.downloadFile(uri);
                            }
                            catch (Exception e) {
                                this.isMsfDownload = true;
                                this.downloadFile(uri);
                            }
                            break block26;
                        }
                        this.isMsfDownload = true;
                        this.downloadFile(uri);
                    }
                    catch (Exception e) {
                        this.isMsfDownload = true;
                        this.downloadFile(uri);
                    }
                } else {
                    String returnedPath = Utils.getRealPathFromURI_API19(this.context, uri);
                    MimeTypeMap mime = MimeTypeMap.getSingleton();
                    String subStringExtension = String.valueOf(returnedPath).substring(String.valueOf(returnedPath).lastIndexOf(".") + 1);
                    String extensionFromMime = mime.getExtensionFromMimeType(this.context.getContentResolver().getType(uri));
                    if (returnedPath == null || returnedPath.equals("")) {
                        if (!this.unknownProviderCalledBefore) {
                            this.unknownProviderCalledBefore = true;
                            if (uri.getScheme() != null && uri.getScheme().equals("content")) {
                                if (Utils.errorReason() != null && Utils.errorReason().equals("dataReturnedNull")) {
                                    this.isFromUnknownProvider = true;
                                    this.downloadFile(uri);
                                    return;
                                }
                                if (Utils.errorReason() != null && Utils.errorReason().contains("column '_data' does not exist")) {
                                    this.isFromUnknownProvider = true;
                                    this.downloadFile(uri);
                                    return;
                                }
                                if (Utils.errorReason() != null && Utils.errorReason().equals("uri")) {
                                    this.isFromUnknownProvider = true;
                                    this.downloadFile(uri);
                                    return;
                                }
                            }
                        }
                        this.pickiTCallbacks.PickiTonCompleteListener(returnedPath, false, false, false, Utils.errorReason());
                    } else {
                        if (!subStringExtension.equals("jpeg") && !subStringExtension.equals(extensionFromMime) && uri.getScheme() != null && uri.getScheme().equals("content")) {
                            this.isFromUnknownProvider = true;
                            this.downloadFile(uri);
                            return;
                        }
                        if (this.wasMultipleFileSelected) {
                            this.multiplePaths.add(returnedPath);
                        } else {
                            this.pickiTCallbacks.PickiTonCompleteListener(returnedPath, false, false, true, "");
                        }
                    }
                }
            } else {
                String returnedPath = Utils.getRealPathFromURI_BelowAPI19(this.context, uri);
                this.pickiTCallbacks.PickiTonCompleteListener(returnedPath, false, false, true, "");
            }
        }
    }

    public void enableProcProtocol(boolean shouldEnable) {
        this.enableProc = shouldEnable;
    }

    private void downloadFile(Uri uri) {
        this.asyntask = new DownloadAsyncTask(uri, this.context, this, this.mActivity);
        this.asyntask.execute(new Uri[0]);
    }

    public void cancelTask() {
        if (this.asyntask != null) {
            this.asyntask.cancel(true);
            this.deleteTemporaryFile(this.context);
        }
    }

    public boolean wasLocalFileSelected(Uri uri) {
        return !this.isDropBox(uri) && !this.isGoogleDrive(uri) && !this.isOneDrive(uri);
    }

    private boolean isDropBox(Uri uri) {
        return String.valueOf(uri).toLowerCase().contains("content://com.dropbox.");
    }

    private boolean isGoogleDrive(Uri uri) {
        return String.valueOf(uri).toLowerCase().contains("com.google.android.apps");
    }

    private boolean isOneDrive(Uri uri) {
        return String.valueOf(uri).toLowerCase().contains("com.microsoft.skydrive.content");
    }

    @Override
    public void PickiTonUriReturned() {
        if (this.wasMultipleFileSelected) {
            if (!this.wasUriReturnedCalledBefore) {
                this.pickiTCallbacks.PickiTonUriReturned();
                this.wasUriReturnedCalledBefore = true;
            }
        } else {
            this.pickiTCallbacks.PickiTonUriReturned();
        }
    }

    @Override
    public void PickiTonPreExecute() {
        if (this.wasMultipleFileSelected || this.isMsfDownload) {
            if (!this.wasPreExecuteCalledBefore) {
                this.wasPreExecuteCalledBefore = true;
                this.pickiTCallbacks.PickiTonStartListener();
            }
        } else {
            this.pickiTCallbacks.PickiTonUriReturned();
        }
    }

    @Override
    public void PickiTonProgressUpdate(int progress) {
        this.pickiTCallbacks.PickiTonProgressUpdate(progress);
    }

    @Override
    public void PickiTonPostExecute(String path, boolean wasDriveFile, boolean wasSuccessful, String reason) {
        this.unknownProviderCalledBefore = false;
        if (wasSuccessful) {
            if (this.wasMultipleFileSelected) {
                ++this.driveCountRef;
                this.multiplePaths.add(path);
                if (this.driveCountRef == this.countMultiple) {
                    this.wasPreExecuteCalledBefore = false;
                    this.wasUriReturnedCalledBefore = false;
                    this.pickiTCallbacks.PickiTonMultipleCompleteListener(this.multiplePaths, true, "");
                    this.multiplePaths.clear();
                    this.wasUriReturnedCalledBefore = false;
                    this.wasPreExecuteCalledBefore = false;
                }
            } else if (this.isDriveFile) {
                this.pickiTCallbacks.PickiTonCompleteListener(path, true, false, true, "");
            } else if (this.isFromUnknownProvider) {
                this.pickiTCallbacks.PickiTonCompleteListener(path, false, true, true, "");
            } else if (this.isMsfDownload) {
                this.pickiTCallbacks.PickiTonCompleteListener(path, false, true, true, "");
            }
        } else if (this.isDriveFile) {
            this.pickiTCallbacks.PickiTonCompleteListener(path, true, false, false, reason);
        } else if (this.isFromUnknownProvider) {
            this.pickiTCallbacks.PickiTonCompleteListener(path, false, true, false, reason);
        }
    }

    public void deleteTemporaryFile(Context context) {
        File folder = context.getExternalFilesDir("Temp");
        if (folder != null && this.deleteDirectory(folder)) {
            Log.i((String)"PickiT ", (String)" deleteDirectory was called");
        }
    }

    private boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            if (files == null) {
                return false;
            }
            for (File file : files) {
                if (file.isDirectory()) {
                    this.deleteDirectory(file);
                    continue;
                }
                boolean wasSuccessful = file.delete();
                if (!wasSuccessful) continue;
                Log.i((String)"Deleted ", (String)"successfully");
            }
        }
        return path.delete();
    }
}

