/*
 * Decompiled with CFR 0.152.
 */
package com.hbisoft.pickit;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SDUtil {
    private static final String EXTERNAL_STORAGE = System.getenv("EXTERNAL_STORAGE");
    private static final String SECONDARY_STORAGES = System.getenv("SECONDARY_STORAGE");
    private static final String EMULATED_STORAGE_TARGET = System.getenv("EMULATED_STORAGE_TARGET");
    @SuppressLint(value={"SdCardPath"})
    private static final String[] KNOWN_PHYSICAL_PATHS = new String[]{"/storage/sdcard0", "/storage/sdcard1", "/storage/extsdcard", "/storage/sdcard0/external_sdcard", "/mnt/extsdcard", "/mnt/sdcard/external_sd", "/mnt/sdcard/ext_sd", "/mnt/external_sd", "/mnt/media_rw/sdcard1", "/removable/microsd", "/mnt/emmc", "/storage/external_SD", "/storage/ext_sd", "/storage/removable/sdcard1", "/data/sdext", "/data/sdext2", "/data/sdext3", "/data/sdext4", "/sdcard1", "/sdcard2", "/storage/microsd"};

    public static String[] getStorageDirectories(Context context) {
        HashSet<String> availableDirectoriesSet = new HashSet<String>();
        if (!TextUtils.isEmpty((CharSequence)EMULATED_STORAGE_TARGET)) {
            availableDirectoriesSet.add(SDUtil.getEmulatedStorageTarget());
        } else {
            availableDirectoriesSet.addAll(SDUtil.getExternalStorage(context));
        }
        Collections.addAll(availableDirectoriesSet, SDUtil.getAllSecondaryStorages());
        String[] storagesArray = new String[availableDirectoriesSet.size()];
        return availableDirectoriesSet.toArray(storagesArray);
    }

    private static Set<String> getExternalStorage(Context context) {
        HashSet<String> availableDirectoriesSet = new HashSet<String>();
        if (Build.VERSION.SDK_INT >= 23) {
            File[] files;
            for (File file : files = SDUtil.getExternalFilesDirs(context)) {
                if (file == null) continue;
                String applicationSpecificAbsolutePath = file.getAbsolutePath();
                String rootPath = applicationSpecificAbsolutePath.substring(9, applicationSpecificAbsolutePath.indexOf("Android/data"));
                rootPath = rootPath.substring(rootPath.indexOf("/storage/") + 1);
                if ((rootPath = rootPath.substring(0, rootPath.indexOf("/"))).equals("emulated")) continue;
                availableDirectoriesSet.add(rootPath);
            }
        } else if (TextUtils.isEmpty((CharSequence)EXTERNAL_STORAGE)) {
            availableDirectoriesSet.addAll(SDUtil.getAvailablePhysicalPaths());
        } else {
            availableDirectoriesSet.add(EXTERNAL_STORAGE);
        }
        return availableDirectoriesSet;
    }

    private static String getEmulatedStorageTarget() {
        String path;
        String[] folders;
        String lastSegment;
        String rawStorageId = "";
        if (Build.VERSION.SDK_INT >= 17 && !TextUtils.isEmpty((CharSequence)(lastSegment = (folders = (path = Environment.getExternalStorageDirectory().getAbsolutePath()).split(File.separator))[folders.length - 1])) && TextUtils.isDigitsOnly((CharSequence)lastSegment)) {
            rawStorageId = lastSegment;
        }
        if (TextUtils.isEmpty((CharSequence)rawStorageId)) {
            return EMULATED_STORAGE_TARGET;
        }
        return EMULATED_STORAGE_TARGET + File.separator + rawStorageId;
    }

    private static String[] getAllSecondaryStorages() {
        if (!TextUtils.isEmpty((CharSequence)SECONDARY_STORAGES)) {
            return SECONDARY_STORAGES.split(File.pathSeparator);
        }
        return new String[0];
    }

    private static List<String> getAvailablePhysicalPaths() {
        ArrayList<String> availablePhysicalPaths = new ArrayList<String>();
        for (String physicalPath : KNOWN_PHYSICAL_PATHS) {
            File file = new File(physicalPath);
            if (!file.exists()) continue;
            availablePhysicalPaths.add(physicalPath);
        }
        return availablePhysicalPaths;
    }

    private static File[] getExternalFilesDirs(Context context) {
        if (Build.VERSION.SDK_INT >= 19) {
            return context.getExternalFilesDirs(null);
        }
        return new File[]{context.getExternalFilesDir(null)};
    }
}

