/*
 * Decompiled with CFR 0.152.
 */
package com.gkemon.XMLtoPDF;

import android.annotation.SuppressLint;
import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.util.Log;
import android.webkit.MimeTypeMap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.FileProvider;
import androidx.loader.content.CursorLoader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.Comparator;

public class FileUtils {
    public static final String DOCUMENTS_DIR = "documents";
    public static final String AUTHORITY = "YOUR_AUTHORITY.provider";
    public static final String HIDDEN_PREFIX = ".";
    static final String TAG = "FileUtils";
    private static final boolean DEBUG = false;
    public static Comparator<File> sComparator = (f1, f2) -> f1.getName().toLowerCase().compareTo(f2.getName().toLowerCase());
    public static FileFilter sFileFilter = file -> {
        String fileName = file.getName();
        return file.isFile() && !fileName.startsWith(HIDDEN_PREFIX);
    };
    public static FileFilter sDirFilter = file -> {
        String fileName = file.getName();
        return file.isDirectory() && !fileName.startsWith(HIDDEN_PREFIX);
    };

    private FileUtils() {
    }

    public static String getExtension(String uri) {
        if (uri == null) {
            return null;
        }
        int dot = uri.lastIndexOf(HIDDEN_PREFIX);
        if (dot >= 0) {
            return uri.substring(dot);
        }
        return "";
    }

    public static boolean isLocal(String url) {
        return url != null && !url.startsWith("http://") && !url.startsWith("https://");
    }

    public static boolean isMediaUri(Uri uri) {
        return "media".equalsIgnoreCase(uri.getAuthority());
    }

    public static Uri getUri(File file) {
        return file != null ? Uri.fromFile((File)file) : null;
    }

    public static File getPathWithoutFilename(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return file;
            }
            String filename = file.getName();
            String filepath = file.getAbsolutePath();
            String pathwithoutname = filepath.substring(0, filepath.length() - filename.length());
            if (pathwithoutname.endsWith("/")) {
                pathwithoutname = pathwithoutname.substring(0, pathwithoutname.length() - 1);
            }
            return new File(pathwithoutname);
        }
        return null;
    }

    public static String getMimeType(File file) {
        String extension = FileUtils.getExtension(file.getName());
        if (extension.length() > 0) {
            return MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension.substring(1));
        }
        return "application/octet-stream";
    }

    public static String getMimeType(Context context, Uri uri) throws IOException {
        File file = new File(FileUtils.getPath(context, uri));
        return FileUtils.getMimeType(file);
    }

    public static String getMimeType(Context context, String url) {
        String type = context.getContentResolver().getType(Uri.parse((String)url));
        if (type == null) {
            type = "application/octet-stream";
        }
        return type;
    }

    public static boolean isLocalStorageDocument(Uri uri) {
        return AUTHORITY.equals(uri.getAuthority());
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    public static boolean isGoogleDriveUri(Uri uri) {
        return "com.google.android.apps.docs.storage.legacy".equals(uri.getAuthority()) || "com.google.android.apps.docs.storage".equals(uri.getAuthority());
    }

    public static String getPath(Context context, Uri uri) throws IOException {
        String absolutePath = FileUtils.getLocalPath(context, uri);
        return absolutePath != null ? absolutePath : uri.toString();
    }

    private static String getLocalPath(Context context, Uri uri) throws IOException {
        boolean isKitKat;
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (FileUtils.isLocalStorageDocument(uri)) {
                return DocumentsContract.getDocumentId((Uri)uri);
            }
            if (FileUtils.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }
                if ("home".equalsIgnoreCase(type)) {
                    return Environment.getExternalStorageDirectory() + "/documents/" + split[1];
                }
            } else {
                if (FileUtils.isDownloadsDocument(uri)) {
                    String[] contentUriPrefixesToTry;
                    String id = DocumentsContract.getDocumentId((Uri)uri);
                    if (id != null && id.startsWith("raw:")) {
                        return id.substring(4);
                    }
                    for (String contentUriPrefix : contentUriPrefixesToTry = new String[]{"content://downloads/public_downloads", "content://downloads/my_downloads"}) {
                        Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)contentUriPrefix), (long)Long.valueOf(id));
                        String path = FileUtils.getDataColumn(context, contentUri, null, null);
                        if (path == null) continue;
                        return path;
                    }
                    String fileName = FileUtils.getFileName(context, uri);
                    File cacheDir = FileUtils.getDocumentCacheDir(context);
                    File file = FileUtils.generateFileName(fileName, cacheDir);
                    String destinationPath = null;
                    if (file != null) {
                        destinationPath = file.getAbsolutePath();
                        FileUtils.saveFileFromUri(context, uri, destinationPath);
                    }
                    return destinationPath;
                }
                if (FileUtils.isMediaDocument(uri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return FileUtils.getDataColumn(context, contentUri, "_id=?", selectionArgs);
                }
                if (FileUtils.isGoogleDriveUri(uri)) {
                    return FileUtils.getGoogleDriveFilePath(uri, context);
                }
            }
        } else {
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                if (FileUtils.isGooglePhotosUri(uri)) {
                    return uri.getLastPathSegment();
                }
                if (FileUtils.isGoogleDriveUri(uri)) {
                    return FileUtils.getGoogleDriveFilePath(uri, context);
                }
                return FileUtils.getDataColumn(context, uri, null, null);
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return uri.getPath();
            }
        }
        return null;
    }

    public static File getFile(Context context, Uri uri) throws IOException {
        String path;
        if (uri != null && FileUtils.isLocal(path = FileUtils.getRealPath(context, uri))) {
            return new File(path);
        }
        return null;
    }

    public static String getReadableFileSize(int size) {
        int BYTES_IN_KILOBYTES = 1024;
        DecimalFormat dec = new DecimalFormat("###.#");
        String KILOBYTES = " KB";
        String MEGABYTES = " MB";
        String GIGABYTES = " GB";
        float fileSize = 0.0f;
        String suffix = " KB";
        if (size > 1024 && (fileSize = (float)(size / 1024)) > 1024.0f) {
            if ((fileSize /= 1024.0f) > 1024.0f) {
                fileSize /= 1024.0f;
                suffix = " GB";
            } else {
                suffix = " MB";
            }
        }
        return String.valueOf(dec.format(fileSize) + suffix);
    }

    public static Intent createGetContentIntent() {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType("*/*");
        intent.addCategory("android.intent.category.OPENABLE");
        return intent;
    }

    public static Intent getViewIntent(Context context, File file) {
        Uri uri = FileProvider.getUriForFile((Context)context, (String)AUTHORITY, (File)file);
        Intent intent = new Intent("android.intent.action.VIEW");
        String url = file.toString();
        if (url.contains(".doc") || url.contains(".docx")) {
            intent.setDataAndType(uri, "application/msword");
        } else if (url.contains(".pdf")) {
            intent.setDataAndType(uri, "application/pdf");
        } else if (url.contains(".ppt") || url.contains(".pptx")) {
            intent.setDataAndType(uri, "application/vnd.ms-powerpoint");
        } else if (url.contains(".xls") || url.contains(".xlsx")) {
            intent.setDataAndType(uri, "application/vnd.ms-excel");
        } else if (url.contains(".zip") || url.contains(".rar")) {
            intent.setDataAndType(uri, "application/x-wav");
        } else if (url.contains(".rtf")) {
            intent.setDataAndType(uri, "application/rtf");
        } else if (url.contains(".wav") || url.contains(".mp3")) {
            intent.setDataAndType(uri, "audio/x-wav");
        } else if (url.contains(".gif")) {
            intent.setDataAndType(uri, "image/gif");
        } else if (url.contains(".jpg") || url.contains(".jpeg") || url.contains(".png")) {
            intent.setDataAndType(uri, "image/jpeg");
        } else if (url.contains(".txt")) {
            intent.setDataAndType(uri, "text/plain");
        } else if (url.contains(".3gp") || url.contains(".mpg") || url.contains(".mpeg") || url.contains(".mpe") || url.contains(".mp4") || url.contains(".avi")) {
            intent.setDataAndType(uri, "video/*");
        } else {
            intent.setDataAndType(uri, "*/*");
        }
        intent.addFlags(0x10000000);
        intent.addFlags(1);
        intent.addFlags(2);
        return intent;
    }

    public static File getDownloadsDir() {
        return Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
    }

    public static File getDocumentCacheDir(@NonNull Context context) {
        File dir = new File(context.getCacheDir(), DOCUMENTS_DIR);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        FileUtils.logDir(context.getCacheDir());
        FileUtils.logDir(dir);
        return dir;
    }

    private static void logDir(File dir) {
    }

    @Nullable
    public static File generateFileName(@Nullable String name, File directory) {
        if (name == null) {
            return null;
        }
        File file = new File(directory, name);
        if (file.exists()) {
            String fileName = name;
            String extension = "";
            int dotIndex = name.lastIndexOf(46);
            if (dotIndex > 0) {
                fileName = name.substring(0, dotIndex);
                extension = name.substring(dotIndex);
            }
            int index = 0;
            while (file.exists()) {
                name = fileName + '(' + ++index + ')' + extension;
                file = new File(directory, name);
            }
        }
        try {
            if (!file.createNewFile()) {
                return null;
            }
        }
        catch (IOException e) {
            Log.w((String)TAG, (Throwable)e);
            return null;
        }
        FileUtils.logDir(directory);
        return file;
    }

    private static void saveFileFromUri(Context context, Uri uri, String destinationPath) throws IOException {
        InputStream is = null;
        BufferedOutputStream bos = null;
        is = context.getContentResolver().openInputStream(uri);
        bos = new BufferedOutputStream(new FileOutputStream(destinationPath, false));
        byte[] buf = new byte[1024];
        is.read(buf);
        do {
            bos.write(buf);
        } while (is.read(buf) != -1);
        is.close();
        bos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytesFromFile(String filePath) {
        FileInputStream fileInputStream = null;
        byte[] bytesArray = null;
        try {
            File file = new File(filePath);
            bytesArray = new byte[(int)file.length()];
            fileInputStream = new FileInputStream(file);
            fileInputStream.read(bytesArray);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return bytesArray;
    }

    public static File createTempImageFile(Context context, String fileName) throws IOException {
        File storageDir = new File(context.getCacheDir(), DOCUMENTS_DIR);
        return File.createTempFile(fileName, ".jpg", storageDir);
    }

    public static String getFileName(@NonNull Context context, Uri uri) throws IOException {
        String mimeType = context.getContentResolver().getType(uri);
        String filename = null;
        if (mimeType == null && context != null) {
            String path = FileUtils.getPath(context, uri);
            if (path == null) {
                filename = FileUtils.getName(uri.toString());
            } else {
                File file = new File(path);
                filename = file.getName();
            }
        } else {
            Cursor returnCursor = context.getContentResolver().query(uri, null, null, null, null);
            if (returnCursor != null) {
                int nameIndex = returnCursor.getColumnIndex("_display_name");
                returnCursor.moveToFirst();
                filename = returnCursor.getString(nameIndex);
                returnCursor.close();
            }
        }
        return filename;
    }

    public static String getName(String filename) {
        if (filename == null) {
            return null;
        }
        int index = filename.lastIndexOf(47);
        return filename.substring(index + 1);
    }

    private static String getGoogleDriveFilePath(Uri uri, Context context) {
        Uri returnUri = uri;
        Cursor returnCursor = context.getContentResolver().query(returnUri, null, null, null, null);
        int nameIndex = returnCursor.getColumnIndex("_display_name");
        int sizeIndex = returnCursor.getColumnIndex("_size");
        returnCursor.moveToFirst();
        String name = returnCursor.getString(nameIndex);
        String size = Long.toString(returnCursor.getLong(sizeIndex));
        File file = new File(context.getCacheDir(), name);
        try {
            InputStream inputStream = context.getContentResolver().openInputStream(uri);
            FileOutputStream outputStream = new FileOutputStream(file);
            int read = 0;
            int maxBufferSize = 0x100000;
            int bytesAvailable = inputStream.available();
            int bufferSize = Math.min(bytesAvailable, maxBufferSize);
            byte[] buffers = new byte[bufferSize];
            while ((read = inputStream.read(buffers)) != -1) {
                outputStream.write(buffers, 0, read);
            }
            inputStream.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return file.getPath();
    }

    public static String getRealPath(Context context, Uri fileUri) {
        String realPath = Build.VERSION.SDK_INT < 11 ? FileUtils.getRealPathFromURI_BelowAPI11(context, fileUri) : (Build.VERSION.SDK_INT < 19 ? FileUtils.getRealPathFromURI_API11to18(context, fileUri) : FileUtils.getRealPathFromURI_API19(context, fileUri));
        return realPath;
    }

    @SuppressLint(value={"NewApi"})
    public static String getRealPathFromURI_API11to18(Context context, Uri contentUri) {
        String[] proj = new String[]{"_data"};
        String result = null;
        CursorLoader cursorLoader = new CursorLoader(context, contentUri, proj, null, null, null);
        Cursor cursor = cursorLoader.loadInBackground();
        if (cursor != null) {
            int column_index = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            result = cursor.getString(column_index);
            cursor.close();
        }
        return result;
    }

    public static String getRealPathFromURI_BelowAPI11(Context context, Uri contentUri) {
        String[] proj = new String[]{"_data"};
        Cursor cursor = context.getContentResolver().query(contentUri, proj, null, null, null);
        int column_index = 0;
        String result = "";
        if (cursor != null) {
            column_index = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            result = cursor.getString(column_index);
            cursor.close();
            return result;
        }
        return result;
    }

    @SuppressLint(value={"NewApi"})
    public static String getRealPathFromURI_API19(Context context, Uri uri) {
        boolean isKitKat;
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (FileUtils.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    if (split.length > 1) {
                        return Environment.getExternalStorageDirectory() + "/" + split[1];
                    }
                    return Environment.getExternalStorageDirectory() + "/";
                }
                return "storage/" + docId.replace(":", "/");
            }
            if (FileUtils.isDownloadsDocument(uri)) {
                File file;
                String fileName = FileUtils.getFilePath(context, uri);
                if (fileName != null) {
                    return Environment.getExternalStorageDirectory().toString() + "/Download/" + fileName;
                }
                String id = DocumentsContract.getDocumentId((Uri)uri);
                if (id.startsWith("raw:") && (file = new File(id = id.replaceFirst("raw:", ""))).exists()) {
                    return id;
                }
                Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id));
                return FileUtils.getDataColumn(context, contentUri, null, null);
            }
            if (FileUtils.isMediaDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                Uri contentUri = null;
                if ("image".equals(type)) {
                    contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                } else if ("video".equals(type)) {
                    contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                } else if ("audio".equals(type)) {
                    contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                }
                String selection = "_id=?";
                String[] selectionArgs = new String[]{split[1]};
                return FileUtils.getDataColumn(context, contentUri, "_id=?", selectionArgs);
            }
        } else {
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                if (FileUtils.isGooglePhotosUri(uri)) {
                    return uri.getLastPathSegment();
                }
                return FileUtils.getDataColumn(context, uri, null, null);
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return uri.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int index = cursor.getColumnIndexOrThrow("_data");
                String string = cursor.getString(index);
                return string;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFilePath(Context context, Uri uri) {
        String[] projection = new String[]{"_display_name"};
        try (Cursor cursor = null;){
            cursor = context.getContentResolver().query(uri, projection, null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                int index = cursor.getColumnIndexOrThrow("_display_name");
                String string = cursor.getString(index);
                return string;
            }
        }
        return null;
    }
}

