/*
 * Decompiled with CFR 0.152.
 */
package com.zjy.pdfview.download;

import android.app.IntentService;
import android.content.Intent;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.zjy.pdfview.download.DownloadManager;
import com.zjy.pdfview.download.IDownloadCallback;
import com.zjy.pdfview.utils.PdfLog;

public class DownloadService
extends IntentService {
    public static final String DOWNLOAD_URL_KEY = "DOWNLOAD_URL_KEY";
    private String downLoadUrl;
    private DownloadManager downloadManager;

    public DownloadService() {
        super("download_pdf");
    }

    protected void onHandleIntent(@Nullable Intent intent) {
        PdfLog.logDebug("onHandleIntent");
        if (intent != null) {
            this.downLoadUrl = intent.getStringExtra(DOWNLOAD_URL_KEY);
        }
        if (!TextUtils.isEmpty((CharSequence)this.downLoadUrl)) {
            this.downloadManager = new DownloadManager(new IDownloadCallback(){

                @Override
                public void downloadSuccess(String resultPath) {
                    DownloadService.this.sendDownloadState(1, resultPath);
                }

                @Override
                public void downloadFail() {
                    DownloadService.this.sendDownloadState(2, "");
                }

                @Override
                public void downloadComplete(String path) {
                    DownloadService.this.sendDownloadState(3, path);
                }
            });
            this.downloadManager.downloadFile(this.getApplicationContext(), this.downLoadUrl);
        }
    }

    private void sendDownloadState(int state, String path) {
        Intent it = new Intent();
        it.setAction("DOWN_LOAD_ACTION");
        if (!TextUtils.isEmpty((CharSequence)path)) {
            it.putExtra("DOWNLOAD_RESULT", path);
        }
        it.putExtra("DOWNLOAD_STATE", state);
        this.sendBroadcast(it);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.downloadManager != null) {
            this.downloadManager.cancel();
        }
    }
}

