/*
 * Decompiled with CFR 0.152.
 */
package com.zjy.pdfview;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.widget.Toast;
import com.zjy.pdfview.PdfRendererActivity;
import com.zjy.pdfview.download.DownloadManager;
import com.zjy.pdfview.download.IDownloadCallback;

public class PdfPreviewUtils {
    public static void previewPdf(final Context context, String url) {
        if (Build.VERSION.SDK_INT >= 21) {
            PdfRendererActivity.startPreview(context, url);
        } else {
            DownloadManager downloadManager = new DownloadManager(new IDownloadCallback(){

                @Override
                public void downloadSuccess(String path) {
                }

                @Override
                public void downloadFail() {
                }

                @Override
                public void downloadComplete(String path) {
                    Uri uri = Uri.parse((String)("file://" + path));
                    Intent intent = new Intent();
                    intent.setAction("android.intent.action.VIEW");
                    intent.setData(uri);
                    if (intent.resolveActivity(context.getPackageManager()) != null) {
                        context.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"\u8bf7\u9009\u62e9\u6d4f\u89c8\u5668\u6253\u5f00"));
                    } else {
                        Toast.makeText((Context)context, (CharSequence)"\u6ca1\u6709\u53ef\u7528\u7684\u6d4f\u89c8\u5668", (int)0).show();
                    }
                }
            });
            downloadManager.downloadFile(context, url);
        }
    }
}

